/*******************************************************************************
*
* University of Western Australia
* Department of Computer Science
* Copyright (c) University of Western Australia
*
* SYSTEM :              VIP
* RELEASE:		3
* SUBSYSTEM:            VIP
* MODULE:		sqrim.c - Apply the pixel-wise square operation to an
*			          image.
* REVISION:             3.1
* AUTHOR:               CA
* CREATION DATE:        27 May 1987
* REVISION DATE:	3/16/94        
*
********************************************************************************
*
* REVISION LOG
*
* REVISION:		3.1
* REVISION DATE:	16 March 1994
* COMMENT:		ANSIfied and SCCS'd
* BY:			CFF
*
* REVISION:		-
* REVISION DATE:	07 Jan 1992
* COMMENT:		NEWVIP
* BY:			DH
*
*******************************************************************************/

#ifndef lint
static char *sccs_id = "@(#)sqrim.c	3.1 3/16/94";
#endif


#include <stdio.h>
#include <stdlib.h>
#include <math.h>
#include "vip.h"


/*- Usage -----------------------------------------------------------

Print message and exit program.

--------------------------------------------------------------------*/

void Usage()
{
    (void) fprintf(stderr,
	    "usage: sqrim [input_file] [-o output_file]\n");
    exit(1);
}


/*- Pperror ---------------------------------------------------------

Print message and exit program.

--------------------------------------------------------------------*/

void Pperror(e)
char   *e;
{
    (void) fprintf(stderr, "sqrim: %s\n", e);
    exit(1);
}


/*- Main ------------------------------------------------------------

Main body of the program.

--------------------------------------------------------------------*/

main(argc, argv)
int     argc;
char   *argv[];
{
    int     argn;
    char   *in_arg = NULL;
    char   *out_arg = NULL;
    IMAGE  *im, *outim;

    for (argn = 1; argn < argc; argn++)
	if (argv[argn][0] == '-')
	    switch (argv[argn][1]) {
	    case 'o':
		out_arg = argv[++argn];
		break;
	    default:
		Usage();
	    }
	else if (!in_arg)
	    in_arg = argv[argn];
	else
	    Usage();

    if (!(im = ( IMAGE * ) Read_Image(in_arg)))
	Pperror("vision system error in Read_Image");

    outim = ( IMAGE * ) Sqr_Image(im);

    if (outim)
	Write_Image(outim, out_arg);

    exit(0);
}
