/*******************************************************************************
*
* University of Western Australia
* Department of Computer Science
* Copyright (c) University of Western Australia
*
* SYSTEM :              VIP
* RELEASE:		3
* SUBSYSTEM:            VIP
* MODULE:		raster2vip.c -	Convert an image from the raster format
*					to vip format, making use of SunOs pnm
*				 	and related utilities.
* REVISION:             3.1
* AUTHOR:		CFF               
* CREATION DATE:        06 August 1992
* REVISION DATE:	8/6/92
*
********************************************************************************
*
* REVISION LOG
*
* REVISION:		3.1
* CREATION DATE:	06 August 1992
* COMMENT:		A new utility.
* BY:			CFF
*
*******************************************************************************/

#ifndef lint
static char *sccs_id = "@(#)raster2vip.c	3.1 8/6/92";
#endif


#include <stdio.h>
#include <stdlib.h>
#include <math.h>
#include "vip.h"
#include "rast.h"


/*- Usage -----------------------------------------------------------

Print error message and exit the program.

--------------------------------------------------------------------*/

void Usage()
{
    (void) fprintf(stderr, "usage: raster2vip [raster_image_file] [-o vip_image_file]\n");
    exit(1);
}


/*- Pperror ---------------------------------------------------------

Print error message and exit the program.

--------------------------------------------------------------------*/

void Pperror(e)
char   *e;
{
    (void) fprintf(stderr, "raster2vip : %s\n", e);
    exit(1);
}


/*- Main ------------------------------------------------------------

Main body of the program.

--------------------------------------------------------------------*/

main(argc, argv)
int     argc;
char   *argv[];
{
    int     argn;
    char   *in_arg = NULL;
    char   *out_arg = NULL;
    IMAGE  *im;
    RASTER *raster;
    char   command_string[100];

    for (argn = 1; argn < argc; argn++)
	if (argv[argn][0] == '-')
	    switch (argv[argn][1]) {
	    case 'o':
		out_arg = argv[++argn];
		break;
	    default:
		Usage();
	    }
	else if (!in_arg)
	    in_arg = argv[argn];
	else
	    Usage();

    (void) sprintf (command_string, 
		    "%s %s %c %s%c", "rasttopnm", in_arg, '>', "rtp.tmp", '\0');
    (void) system(command_string);
    command_string[0] = '\0';

    (void) sprintf (command_string, 
		    "%s %s %s %s%c", "pm2vip", "rtp.tmp", "-o", out_arg,'\0');
    (void) printf("pm2vip: writing VIP file.\n");
    (void) system(command_string);
    (void) system("rm rtp.tmp");

/*
    Original calls to Du's functions .....
*/

/* 
    if (raster = ( RASTER * ) Read_Raster_Image(in_arg))
	if (im = ( IMAGE * ) Raster_To_VIP(raster)) {
	    Rclose(raster);
	    Write_Image(im, out_arg);
	}
*/
    exit(0);
}
