/*******************************************************************************
*
* University of Western Australia
* Department of Computer Science
* Copyright (c) University of Western Australia
*
* SYSTEM :              VIP
* RELEASE:		3
* SUBSYSTEM:            VIP
* MODULE:		nlogim.c - Calculate the natural log of an image
*			           (to base e).  The value of each pixel is
*				   incremented by one before the natural log
*				   operation is applied.
* REVISION:             3.3
* AUTHOR:               CA/DH
* CREATION DATE:        22 March 1994
* REVISION DATE:	4/26/94        
*
********************************************************************************
*
* REVISION LOG
*
* REVISION:		3.3
* REVISION DATE:	26 April 1994
* COMMENT:		Changed to use library function Log_Image
* BY:			PK
*
* REVISION:		3.2
* REVISION DATE:	22 March 1994
* COMMENT:		Fixed table
* BY:			CFF
*
* REVISION:		3.1
* REVISION DATE:	16 March 1994
* COMMENT:		ANSIfied and SCCS'd
* BY:			CFF
*
* REVISION:		
* REVISION DATE:	03 Feb 1992
* COMMENT:		NEWVIP
* BY:			DH
*
*******************************************************************************/

#ifndef lint
static char *sccs_id = "@(#)nlogim.c	3.3 4/26/94";
#endif



#include <stdio.h>
#include <stdlib.h>
#include <math.h>
#include "vip.h"

void Usage();
void Pperror(char *);

/*- Usage -----------------------------------------------------------

Print error message and exit program.

--------------------------------------------------------------------*/

void Usage()
{
    (void) fprintf(stderr, "usage: nlogim [in_file] [-o out_file]\n");
    exit(1);
}


/*- Pperror ---------------------------------------------------------

Print error message and exit program.

--------------------------------------------------------------------*/

void Pperror(e)
char   *e;
{
    (void) fprintf(stderr, "nlogim: %s\n", e);
    exit(1);
}


/*- Main ------------------------------------------------------------

Main body of the program.

--------------------------------------------------------------------*/

int main(argc, argv)
int     argc;
char   *argv[];
{
    int argn;
    char   *in_arg = NULL, *out_arg = NULL;
    IMAGE  *im, *out;

   
    for (argn = 1; argn < argc; argn++)
        if (argv[argn][0] == '-')
            switch (argv[argn][1]) {
            case 'o':
                if (++argn < argc)
                    out_arg = argv[argn];
                else
                    Usage();
                break;
            default:
                Usage();
            }
        else if (!in_arg)
            in_arg = argv[argn];
        else
            Usage();


    if (!(im = ( IMAGE * ) Read_Image(in_arg)))
	exit(1);

    out = ( IMAGE * ) Log_Image(im);
    if (out)
	Write_Image(out, out_arg);
    exit(0);
}



