/*******************************************************************************
*
* University of Western Australia
* Department of Computer Science
* Copyright (c) University of Western Australia
*
* SYSTEM :              VIP
* RELEASE:		3
* SUBSYSTEM:            VIP
* MODULE:		knn.c - K-Nearest-Neighbour Smoothing knn is slower
*			        than snn but preserves the sharpness of edges
*			        better than does snn.
* REVISION:             3.1
* AUTHOR:               DH
* CREATION DATE:        06 Jul 90
* REVISION DATE:	7/10/92        
*
********************************************************************************
*
* REVISION LOG
*
* REVISION:		3.1
* REVISION DATE:	11 July 1992
* COMMENT:		ANSIfied and SCCS'd
* BY:			CFF
*
* REVISION:		
* REVISION DATE:	08 Jan 1992
* COMMENT:		NEWVIP
* BY:			DH
*
*******************************************************************************/

#ifndef lint
static char *sccs_id = "@(#)knn.c	3.1 7/10/92";
#endif


#include <stdio.h>
#include <stdlib.h>
#include <math.h>
#include "vip.h"

void            Usage();
void            Pperror( char * );


/*- Usage -----------------------------------------------------------

Print usage and exit program.

--------------------------------------------------------------------*/

void Usage()
{
    (void) fprintf(stderr, "usage: knn [-n nNum] [-k kNum] [in_image_file] [-o out_image_file]\n");
    (void) fprintf(stderr, "       -n size of neighbourhood is (2*nnum+1) X (2*nnum+1)\n");
    (void) fprintf(stderr, "          (default:nnum=1)\n");
    (void) fprintf(stderr, "       -k the number of pixels taken in the average calculation\n");
    (void) fprintf(stderr, "          (default:knum=4)\n");
    (void) fprintf(stderr, "default: knn -n 1 -k 4 stdin -o stdout\n");
    exit(1);
}


/*- Pperror ---------------------------------------------------------

Print error message and exit program.

--------------------------------------------------------------------*/

void Pperror(m1)
char   *m1;

/* print error message and exit program. */
{
    (void) fprintf(stderr, "knn: %s.\n", m1);
    exit(1);
}


/*- Main ------------------------------------------------------------

Main body of the program.

--------------------------------------------------------------------*/

main(argc, argv)
char   *argv[];
{
    register int arg;
    int     n = 1, k = 4;
    char   *infile = NULL, *outfile = NULL;
    IMAGE  *im, *mat;

    for (arg = 1; arg < argc; arg++)
	if (argv[arg][0] == '-')
	    switch (argv[arg][1]) {
	    case 'k':
		if (++arg < argc)
		    k = atoi(argv[arg]);
		else
		    Usage();
		break;
	    case 'n':
		if (++arg < argc)
		    n = atoi(argv[arg]);
		else
		    Usage();
		break;
	    case 'o':
		if (++arg < argc)
		    outfile = argv[arg];
		else
		    Usage();
		break;
	    default:
		Usage();
	    }
	else if (!infile)
	    infile = argv[arg];
	else
	    Usage();

    if (!(im = ( IMAGE * ) Read_Image(infile)))
	Pperror("Error in reading image from file");

    mat = ( IMAGE * ) Knn_Image(im, n, k);
    Write_Image(mat, outfile);
    exit(0);
}
