/*******************************************************************************
*
* University of Western Australia
* Department of Computer Science
* Copyright (c) University of Western Australia
*
* SYSTEM :              VIP
* RELEASE:		3
* SUBSYSTEM:            VIP
* MODULE:		imtest.c - Program to generate a test image in the
*				   new VIP format for viewing.
* REVISION:             3.1
* AUTHOR:               PK
* CREATION DATE:        Sept 1991
* REVISION DATE:	7/10/92        
*
********************************************************************************
*
* REVISION LOG
*
* REVISION:		3.1
* REVISION DATE:	11 July 1992
* COMMENT:		ANSIfied and SCCS'd
* BY:			CFF
*
*******************************************************************************/

#ifndef lint
static char *sccs_id = "@(#)imtest.c	3.1 7/10/92";
#endif

#include <stdio.h>
#include <stdlib.h>
#include <math.h>
#include "vip.h"

main(argc, argv)
int     argc;
char   *argv[];
{

    IMAGE  *image;
    int     i, j, SIZE;

    if (argc != 3) {
	(void) printf("usage:test size filename\n");
	return;
    }

    SIZE = atoi(argv[1]);
    (void) printf("size = %d\n", SIZE);
    image = ( IMAGE * ) Allocate_Image(0, 0, SIZE, SIZE, BYTETYPE);
    if (!image) {
	(void) printf("could bot allocate image size %d \n", SIZE);
	return;
    }
    for (j = 0; j < SIZE; j++) {
	for (i = 0; i < SIZE; i++)
	    image->i.c[j][i] = 120 * sin((double) i / 20 + (double) j / 100) + 128;
    }

    Write_Image(image, argv[2]);

    return;
}
