/*******************************************************************************
*
* University of Western Australia
* Department of Computer Science
* Copyright (c) University of Western Australia
*
* SYSTEM :              VIP
* RELEASE:		3
* SUBSYSTEM:            VIP
* MODULE:		ifft.c - Inverse Fast Fourier Transform of a
*				 complex image.
* REVISION:             3.2
* AUTHOR:               DH
* CREATION DATE:        29 Sep 1988
* REVISION DATE:	3/15/94
*
********************************************************************************
*
* REVISION LOG
*
* REVISION:		3.3
* REVISION DATE:	8 April 1994
* COMMENT:		Removed Next_Power_Of_2 and fixed compiler warnings
* BY:			BJR
*
* REVISION:		3.2
* REVISION DATE:	15 March 1994
* COMMENT:		Edited out PadImage etc.
* BY:			CFF
*
* REVISION:		3.1
* REVISION DATE:	11 July 1992
* COMMENT:		ANSIfied and SCCS'd
* BY:			CFF
*
* REVISION:
* REVISION DATE:	08 Jan 1992
* COMMENT:		NEWVIP
* BY:			DH
*
*******************************************************************************/

#ifndef lint
static char *sccs_id = "@(#)ifft.c	3.2 3/15/94";

#endif

#include <stdio.h>
#include <stdlib.h>
#include "vip.h"

/*- Usage -----------------------------------------------------------

Print error message and exit program.

--------------------------------------------------------------------*/

void    Usage()
{
    (void) fprintf(stderr, "usage: ifft [-s] [complex_image_file] [-o output_complex_file]\n");
    exit(1);
}



/*- Main ------------------------------------------------------------

Main body of the program.

--------------------------------------------------------------------*/

int     main(argc, argv)
int     argc;
char   *argv[];
{
    int     argn, sh = 0;
    char   *input_arg = NULL;
    char   *output_arg = NULL;
    IMAGE  *im = NULL, *outim = NULL;

    for (argn = 1; argn < argc; argn++)
	if (argv[argn][0] == '-')
	    switch (argv[argn][1]) {
	    case 'o':
		output_arg = argv[++argn];
		break;
	    case 's':
		sh = 1;
		break;
	    default:
		Usage();
	    }
	else if (!input_arg)
	    input_arg = argv[argn];
	else
	    Usage();

    if ((im = (IMAGE *) Read_Image(input_arg)) == NULL)
	exit(1);

    if ((outim = (IMAGE *) FT_Image(im, sh,"inverse")))
	Write_Image(outim, output_arg);

    Free_Image(im);
    Free_Image(outim);

    exit(0);
}
