/*******************************************************************************
*
* University of Western Australia
* Department of Computer Science
* Copyright (c) University of Western Australia
*
* SYSTEM :              VIP
* RELEASE:		3
* SUBSYSTEM:            VIP
* MODULE:		homomorphic.c - Program to perform homomorphic filtering
*		        on an image.	
* REVISION:             3.1
* AUTHOR:              	PK
* CREATION DATE:	24 March 1994
* REVISION DATE:	3/24/94
*
********************************************************************************
*
* REVISION LOG
*
* REVISION:		3.1
* CREATION DATE:	24 March 1994
* COMMENT:		ANSIfied and SCCS'd
* BY:			PK
*
*******************************************************************************/

#ifndef lint
static char *sccs_id = "@(#)homomorphic.c	3.1 3/24/94";
#endif


/*- homomorphic.c ------------------------------------------------

Program to perform homomorphic filtering on an image. An image
enhancing process that attempts to reduce the effects of low frequency
lighting variations across an image, yet at the same time accentuating
high frequency intensity variations to highlight the detail.
Reference: Gonzalez and Woods "Digital Image Processing" page 213.

Peter Kovesi  January 1994

input: image    - input image.
       LowGain  - gain factor for low frequencies (suggest 0.5).
       HighGain - gain factor for high frequencies (suggest 2.0).
       CutOff   - frequency at which transition from LowGain to
                  HighGain occurs (suggest 0.4).
       order    - order of Butterworth type filter (suggest 1)
       lHistogramCut - percentage of low end of histogram to
                       truncate (suggest 1).
       uHistogramCut - percentage of high end of histogram to
                       truncate (suggest 5).

Peter Kovesi  January 1994

------------------------------------------------------------------*/

#include <stdio.h>
#include <stdlib.h>
#include "vip.h"

/*------------------------------------------------------------*/


void    main(int argc, char *argv[])
{
    IMAGE  *image, *outimage;
    double  HighGain, LowGain, CutOff;
    int     order;
    int     lHistogramCut, uHistogramCut;
 

    if (argc != 9) {
	fprintf(stderr, "Usage: homomorphic inimage LowGain HighGain CutOff order lhistogram_cut uhistogram_cut outimage \n");
	fprintf(stderr, "suggested values: homomorphic image_name .5 2 .25 2 5 5 out_image_name\n");
	return;
    }

    LowGain = atof(argv[2]);
    HighGain = atof(argv[3]);
    CutOff = atof(argv[4]);
    order = atoi(argv[5]);
    lHistogramCut = atoi(argv[6]);
    uHistogramCut = atoi(argv[7]);


    image = Read_Image(argv[1]);
    if (!image)
	return;

    outimage = Homomorphic(image, LowGain, HighGain, CutOff, order, 
                          lHistogramCut, uHistogramCut);

    Write_Image(outimage, argv[8]);

    Free_Image(outimage);
    return;
}

