/*******************************************************************************
*
* University of Western Australia
* Department of Computer Science
* Copyright (c) University of Western Australia
*
* SYSTEM :              VIP
* RELEASE:		3
* SUBSYSTEM:            VIP
* MODULE:		differ.c - Output an image highlighting the difference
*				   between two BYTETYPE images.
* REVISION:             3.1
* AUTHOR:               CFF
* CREATION DATE:        19 Nov 1992
* REVISION DATE:	11/19/92
*
********************************************************************************
*
* REVISION LOG
*
* REVISION:		3.2
* REVISION DATE:	22 April 94
* COMMENT:		removed used of differfn.h
* BY:			PK
*
* REVISION:		3.1
* REVISION DATE:	19 Nov 1992
* COMMENT:		ANSIfied and SCCS'd
* BY:			CFF
*
* REVISION:		3.2
* REVISION DATE:	19 Nov 1992
* COMMENT:		Improved error trapping.		
* BY:			CFF
*
*******************************************************************************/

#ifndef lint
static char *sccs_id = "@(#)differ.c	3.1 11/19/92";
#endif



#include <stdio.h>
#include <stdlib.h>

#ifdef DOS

#ifdef MSC
#include <sys\types.h>
#endif

#include <fcntl.h>
#include <sys\stat.h>
#else
#include <sys/file.h>
#endif

#include "vip.h"

void            Usage();
void            Pperror( char * );


/*- Usage -----------------------------------------------------------

Print error message and exit program.

--------------------------------------------------------------------*/

void Usage()
{
    (void) fprintf(stderr, "usage: differ [-i BYTETYPE_in_file1] [-j BYTETYPE_in_file2] [-a -b -c] [-o BYTETYPE_out_file]\n");
    (void) fprintf(stderr, "\n");
    (void) fprintf(stderr, "* Images must be of identical dimensions\n");
    (void) fprintf(stderr, "\n");
    (void) fprintf(stderr, "-a outputs a difference image with pixel intensity\n");
    (void) fprintf(stderr, "   values equal to pixel intensity values in the\n");
    (void) fprintf(stderr, "   first given image if intensity values differ in\n");
    (void) fprintf(stderr, "   both given imges. If pixel intensities in both given\n");
    (void) fprintf(stderr, "   images are identical then the minimum pixel\n");
    (void) fprintf(stderr, "   intensity value, (ie; 0), is assigned \n");
    (void) fprintf(stderr, "-b outputs a difference image with pixel intensity\n");
    (void) fprintf(stderr, "   values equal to pixel intensity values in the\n");
    (void) fprintf(stderr, "   second given image if intensity values differ in\n");
    (void) fprintf(stderr, "   both given imges. If pixel intensities in both given\n");
    (void) fprintf(stderr, "   images are identical then the minimum pixel\n");
    (void) fprintf(stderr, "   intensity value, (ie; 0), is assigned \n");
    (void) fprintf(stderr, "-c outputs a difference image with pixel intensity\n");
    (void) fprintf(stderr, "   values equal to the difference in pixel intensity\n");
    (void) fprintf(stderr, "   values between both given images\n");

    exit(1);
}


/*- Pperror ---------------------------------------------------------

Print error message and exit program.

--------------------------------------------------------------------*/

void Pperror(e)
char   *e;
{
    (void) fprintf(stderr, "differ : %s\n", e);
    exit(1);
}


/*- Main ------------------------------------------------------------

Main body of the program.

--------------------------------------------------------------------*/

int main(argc, argv)
int     argc;
char   *argv[];
{
    int     argn;
    char   *in1_arg = NULL;
    char   *in2_arg = NULL;
    char   *out_arg = NULL;
    IMAGE  *im1;
    IMAGE  *im2;
    IMAGE  *im3;
    register int r, c;
    int    type_arg=1;
    int	   diff_res1=0;
    int	   diff_res2=0;
    int	   diff_res3=0;

    for (argn = 1; argn < argc; argn++)
	if (argv[argn][0] == '-')
	    switch (argv[argn][1]) {
	    case 'i':
		in1_arg = argv[++argn];
		break;
	    case 'j':
		in2_arg = argv[++argn];
		break;
	    case 'o':
		out_arg = argv[++argn];
		break;
	    case 'a':
		type_arg = 1;
		break;
	    case 'b':
		type_arg = 2;
		break;
	    case 'c':
		type_arg = 3;
		break;
	    default:
		Usage();
	    }
	else
	    Usage();


    if (!(im1 = ( IMAGE * ) Read_Image(in1_arg)))
	Pperror("vision system error in read_image\n");

    if (!(im2= ( IMAGE * ) Read_Image(in2_arg)))
	Pperror("vision system error in read_image\n");

    if (im1->rows != im2->rows) {
	Pperror("input images not of identical dimensions\n");
    }

    if (im1->cols != im2->cols) {
	Pperror("input images not of identical dimensions\n");
    }

    if (!(im3= ( IMAGE * ) Read_Image(in1_arg)))
	Pperror("vision system error in read_image\n");

    switch (im1->type) {
    case BYTETYPE:
            if (type_arg==1) {
	        for (r = im1->rows - 1; r >= 0; r--) {
	            for (c = im1->cols - 1; c >= 0; c--) {
		        if ( im1->i.c[r][c] == im2->i.c[r][c] ) {
		            im3->i.c[r][c] = 0;
	                }
		        else {
		            im3->i.c[r][c] = im1->i.c[r][c];
		        }
		    }
		}
	    }

            if (type_arg==2) {
	        for (r = im1->rows - 1; r >= 0; r--) {
	            for (c = im1->cols - 1; c >= 0; c--) {
		        if ( im1->i.c[r][c] == im2->i.c[r][c] ) {
		            im3->i.c[r][c] = 0;
	                }
		        else {
		            im3->i.c[r][c] = im2->i.c[r][c];
		        }
		    }
		}
	    }

            if (type_arg==3) {
	        for (r = im1->rows - 1; r >= 0; r--) {
	            for (c = im1->cols - 1; c >= 0; c--) {
		        if (c<0) break;
		        if (r<0) break;
		        diff_res1 = im1->i.c[r][c];
		        diff_res2 = im2->i.c[r][c];
		        diff_res3 = diff_res1-diff_res2;

		        if (diff_res3 < 0) {
		            im3->i.c[r][c] = (diff_res3)*-1;
		        }
		        else {
		       	    im3->i.c[r][c] = diff_res3;
			}
	            }
		}
	    }

	    break;
    default:
	Pperror("Invalid image type");
    }

    Write_Image(im3, out_arg);
    exit(0);
}


