/*******************************************************************************
*
* University of Western Australia
* Department of Computer Science
* Copyright (c) University of Western Australia
*
* SYSTEM :              VIP
* RELEASE:		3
* SUBSYSTEM:            VIP
* MODULE:		clip.c - Clip a sub-image from a larger image.
* REVISION:             3.1
* AUTHOR:               
* CREATION DATE:        19 Sept 1990
* REVISION DATE:	7/10/92        
*
********************************************************************************
*
* REVISION LOG
*
* REVISION:		3.1
* REVISION DATE:	11 July 1992
* COMMENT:		ANSIfied and SCCS'd
* BY:			CFF
*
* REVISION:		
* REVISION DATE:	21 Jan 1992
* COMMENT:		NEWVIP
* BY:			DH
*
*******************************************************************************/

#ifndef lint
static char *sccs_id = "@(#)clip.c	3.1 7/10/92";
#endif



#include <stdio.h>
#include <stdlib.h>
#include <math.h>
#include "vip.h"

void Usage();
void Pperror(char *e);


/*- Usage -----------------------------------------------------------

Print error message and exit the program.

--------------------------------------------------------------------*/

void Usage()
{
    (void) fprintf(stderr, "usage: clip [in_file] [-d minr minc] [-w rows columns] [-o out_file]\n");
    (void) fprintf(stderr, "       -d the top-left corner of the sub-image (default=(0,0))\n");
    (void) fprintf(stderr, "       -w number of rows and columns of the sub-image (default=dimensions of image in in_file\n");
    exit(1);
}


/*- Pperror ---------------------------------------------------------

Print error message and exit the program.

--------------------------------------------------------------------*/

void Pperror(e)
char   *e;
{
    (void) fprintf(stderr, "clip: %s\n", e);
    exit(1);
}


/*- Main ------------------------------------------------------------

Main body of the program.

--------------------------------------------------------------------*/

main(argc, argv)
int     argc;
char   *argv[];
{
    register int argn;
    char   *in_arg = NULL, *out_arg = NULL;
    IMAGE  *im, *subim;
    int     orgr = -1, orgc = -1;	/* default origin */
    int     rows = 0, columns = 0;	/* default image size to be clipped */

    for (argn = 1; argn < argc; argn++)
	if (argv[argn][0] == '-')
	    switch (argv[argn][1]) {
	    case 'd':
		if (++argn < argc)
		    orgr = atoi(argv[argn]);
		else
		    Usage();
		if (++argn < argc)
		    orgc = atoi(argv[argn]);
		else
		    Usage();
		break;
	    case 'w':
		if (++argn < argc)
		    rows = atoi(argv[argn]);
		else
		    Usage();
		if (++argn < argc)
		    columns = atoi(argv[argn]);
		else
		    Usage();
		break;
	    case 'o':
		out_arg = argv[++argn];
		break;
	    default:
		Usage();
	    }
	else if (!in_arg)
	    in_arg = argv[argn];
	else
	    Usage();

    if (!(im = ( IMAGE * ) Read_Image(in_arg)))
	Pperror("main: Read_Image ruturns NULL");

    /* more checking on the arguments */
    if (orgr < 0 || orgc < 0)
	orgr = orgc = 0;
    if (rows <= 0 || columns <= 0) {
	rows = im->rows;
	columns = im->cols;
    }
    if (orgr + rows > im->rows)
	rows = im->rows - orgr;
    if (orgc + columns > im->cols)
	columns = im->cols - orgc;

    if (subim = ( IMAGE * ) Clip_Image(im, orgr, orgc, rows, columns)) {
	Write_Image(subim, out_arg);
	Free_Image(subim);
    }
    Free_Image(im);

    exit(0);
}
