/*******************************************************************************
*
* University of Western Australia
* Department of Computer Science
* Copyright (c) University of Western Australia
*
* SYSTEM :              VIP
* RELEASE:		3
* SUBSYSTEM:            VIP
* MODULE:		3edge.c - Feature detector as described by U.W.A.
*				  Department of Computer Science Technical
*				  Report 86/9 "Feature Detection from Local
*				  Energy" by Concetta Morrone and Robyn Owens.
*  				  Output edge file is in convolution format.
* REVISION:             3.1
* AUTHOR:               SV/IR/DH
* CREATION DATE:        Dec 1986
* REVISION DATE:	7/10/92        
*
********************************************************************************
*
* REVISION LOG
*
* REVISION:		3.1
* REVISION DATE:	11 July 1992
* COMMENT:		ANSIfied and SCCS'd
* BY:			CFF
*
* REVISION:		
* REVISION DATE:	12 Dec 1991
* COMMENT:		NEWVIP
* BY:			DH
*
*******************************************************************************/

#ifndef lint
static char *sccs_id = "@(#)3edge.c	3.1 7/10/92";
#endif

#include <stdio.h>
#include <stdlib.h>
#include <math.h>
#include "vip.h"

void    Usage();
void Pperror(char *mess1, char *mess2);

float   threshold = 50.0;


/*- Usage -----------------------------------------------------------

Print message and exit program.

--------------------------------------------------------------------*/

void    Usage()
{
    (void) fprintf(stderr, "usage: 3edge [image_file] [-o edge_file] [-t threshold] -m mask_file\n");
    (void) fprintf(stderr, "  -o output matrix file name\n");
    (void) fprintf(stderr, "  -t user-given threshold value (default=50.0)\n");
    (void) fprintf(stderr, "  -m name of the file that contains the mask for convolution\n");
    exit(1);
}


/*- Pperror ---------------------------------------------------------

Print message and exit program.

--------------------------------------------------------------------*/


void Pperror(mess1, mess2)
char   *mess1, *mess2;
{
    (void) fprintf(stderr, "3edge: %s %s.\n", mess1, mess2);
    exit(1);
}


/*- Main ------------------------------------------------------------

Main program.

--------------------------------------------------------------------*/

main(argc, argv)
int     argc;
char   *argv[];
{
    IMAGE  *im = NULL;
    IMAGE  *edge = NULL;
    char   *image_arg = NULL, *edge_arg = NULL, *filter_arg = NULL;
    register int argn;
    float  *odd_filter, *even_filter;
    int     filter_siz;

    for (argn = 1; argn < argc; argn++) {
	if (argv[argn][0] == '-') {
	    switch (argv[argn][1]) {
	    case 't':
		if (++argn < argc)
		    threshold = atof(argv[argn]);
		else
		    Usage();
		break;
	    case 'm':
		if (++argn < argc)
		    filter_arg = argv[argn];
		else
		    Usage();
		break;
	    case 'o':
		if (++argn < argc)
		    edge_arg = argv[argn];
		else
		    Usage();
		break;
	    default:
		Usage();
	    }
	}
	else {
	    if (!image_arg)
		image_arg = argv[argn];
	    else
		Usage();
	}
    }
    if (!filter_arg)
	Usage();

    if (!(im = ( IMAGE * ) Read_Image(image_arg)))
	Pperror("couldn't read image file", image_arg);

    if (!Read_Energy_Filter(filter_arg, &even_filter, &odd_filter, &filter_siz))
	exit(1);
    if (!(edge = ( IMAGE * ) Apply_Local_Energy(im, even_filter, odd_filter,
				    filter_siz, threshold)))
	exit(1);
    Write_Image(edge, edge_arg);

    exit(0);
}
