/******************************************************************************
*
* University of Western Australia
* Department of Computer Science
* Copyright (c) University of Western Australia
*
* SYSTEM :              VIP
* RELEASE:		3
* SUBSYSTEM:		SPLASH            
* MODULE:		splashm.c - Splash image displayer under Motif.
* REVISION:             3.2
* AUTHOR:		J. Trevelyan, P. Kovesi, Du Hunyh, CFF.               
* CREATION DATE:	17 Dec 1993 
* REVISION DATE:	1/31/94
*
********************************************************************************
*
* REVISION LOG
*
*
* REVISION:		3.2
* REVISION DATE:	31 Jan 1994
* COMMENT:		Fixed buttons on Tool panel
* BY:			CFF
*
* REVISION:		3.1
* REVISION DATE:	17 Dec 1993
* COMMENT:		Created and SCCS'd ANSI Splash under Motif
* BY:			CFF
*
*******************************************************************************/


#ifndef lint
static char *sccs_id = "@(#)splashm.c	3.2 1/31/94";
#endif

#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <math.h>
#include <malloc.h>
#include <memory.h>
#include <ctype.h>

#include <X11/Intrinsic.h>
#include <X11/Xutil.h>
#include <Xm/Xm.h>
#include <Xm/Form.h>
#include <Xm/Text.h>
#include <Xm/TextF.h>
#include <Xm/PushB.h>
#include <Xm/Label.h>
#include <Xm/DrawingA.h>
#include <Xm/ToggleB.h>
#include <Xm/ToggleBG.h>
#include <Xm/RowColumn.h>
#include <Xm/SelectioB.h>
#include <Xm/PushB.h>
#include <Xm/Scale.h>
#include <Xm/MessageB.h>

#include "vip.h"
#include "vipiofn.h"
#include "vip1Dfn.h"
#include "vipcalibfn.h"
#include "splash_motif.h"
#include "splash_motiffn.h"
#include "splashmfn.h"
#include "graphics.h"
#include "graphicsfn.h"

/* Motif Widgets etc. */

Widget			topLevel;
Widget			controlform;
Widget			quitbutton;
Widget			quitbutton2;
Widget			toolbutton;
Widget			threshbutton;
Widget			resetbutton;
Widget			resetbuttonlabel;
Widget			threshbuttonlabel;
Widget			clilabel;
Widget			imfilename_panel;
Widget			ucanvas;
Widget			vcanvas;
Widget			intcanvas;
Widget			imagecanvas;
Widget			mapcanvas;
Widget			toolsframe;
Widget			toolsform;
Widget			radiobox;
Widget			radiobox2;
Widget			radiobox3;
Widget			maglabel1;
Widget			magbutton1;
Widget			magbutton2;
Widget			magbutton3;
Widget			magbutton4;
Widget			magbutton5;
Widget			magbutton6;
Widget			imbutton1;
Widget			imbuttonlabel1;
Widget			imbuttonlabel2;
Widget			gammalabel;
Widget			gammascale;
Widget			threshlabel;
Widget			threshscale;
Widget			imagelabel;
Widget			savebutton;
Widget			toolslabel;
Widget			slicecanvas;
Widget			LUTslicecanvas;
Widget			xyzcanvas;
Widget			popupdialog;
Widget		        previous_useroptframe;
Widget		        useroptframe;
Widget			previous_useropt_chbox[2];
Widget			useropt_chbox[2];
Widget			useropt_qbutton;
Widget			previous_useropt_qbutton;
Widget			useroptpanel;
Widget			previous_useroptpanel;
Widget			useroptcanvas;
Widget			previous_useroptcanvas;
Widget 			conv_notice;
 
XmString		contstring;
XmString		setimagedialog;
XmString		popupstring;
XmString  		c_label_string_simple;
XtAppContext		appContext;

/* Local variables */

/*
static char   TranslationTable[]  =
"<Key>Return:   GetFile2()";
*/

long	b_count=0;
int	c_count=0;
char    *c_label_string[2];
char    d_label_string1[100];
char    d_label_string2[100];
int 	return_val=0;
int     firstset=1;
int	tools_selected=0;
int 	firstime=0;
int 	firstmap=1;
int     initial_image=1;

int	imx_coord=0;	/* Global image dimensions */
int	imy_coord=0;
static  int state = 0;
int     POST_EXPOSE=0;

int	mapx_coord=0;	/* Global map dimensions */
int	mapy_coord=0;
int	magimagecols=0;
int	magimagerows=0;
  
int	temprows=0, tempcols=0;
static  int magnification=1;

Pixel	bg_color;
Pixel	bg_color2;

XImage  *xmapimage = NULL;		/* the X image format  */
XImage  *ximage;			/* the X image format  */
XImage  *xblankimage;			/* the X image format  */
IMAGE   *image_check = NULL;
IMAGE   *image1 = NULL;
IMAGE   *image2 = NULL;
IMAGE   *prev_image1 = NULL;
IMAGE   *prev_image2 = NULL;
IMAGE   *tempimage = NULL;
IMAGE   *check_image = NULL;

SENSOR   sensor;
int      *LUT; /* 256 greyscale lookup table */

int      STATE = 0;
int      REDRAWN = FALSE;
char     ARGVIMAGE[250];
int	 IMAGE1_SPLASH=1;
int	 COMPLEX_CONVERTED=0;
int	 COMPLEX_IMAGE=0;
int	 IM_VALUE=0;
int	 PREVIOUS_IMAGE=0;
int	 CURR_COMPLEX=0;
int	 NO_INITIAL_IMAGE_ARG=0;
char     spl_str[250];
int	 useropt_chbox_choice=0;
int	 previous_useropt_chbox_choice=0;
int	 badfile_notice_exists=0;
double   power = 1;
int      popupdialogexists=0;


/*------------------------------------------------------------------------*/


main(argc, argv)
int      argc;
char    *argv[];
{
    VIP_STD_ERR = NULL;		/* suppress messages to screen - use alert
				 * boxes */

    /* Initialize toolkit */


    topLevel = XtAppInitialize(&appContext, "XSPLASH", NULL, 0, &argc, argv, 
			       NULL, NULL, 0);

    display = XtDisplay (topLevel);

    screen = XDefaultScreen (display);

    InitWindows(argc, argv);	

    exit(0);
}

/*-  ShowImage  ---------------------------------------------------------

This function draws the image to the screen. It is a slow draw, using the
basic pixel drawing capabilities of X through routine DrawPoint

------------------------------------------------------------------------*/

void     ShowImage(image)
IMAGE   *image;
{
    int      i, j, col;

    DrawInto2(imagecanvas);

    if (image == NULL)
	return;

    /* Clear the window in case some thing is already there. */

    for (i = 0; i < image->rows; i++)	/* Loop through the number of rows
					 * columns. */
	for (j = 0; j < image->cols; j++) {
	    if (image->i.c[i][j]) {	/* If colour value 0 then don't draw
					 * as the background is alredy that
					 * colour. */
		col = (int) image->i.c[i][j] / 4;	/* Get the colour value
							 * from the image. */
		XSetForeground(display, gc,
			       colour_table[col]);	/* Set the drawing
							 * colour. */
		XDrawPoint(display, win, gc, j, i);	/* Draw the point at vv j,i. */
	    }
	}
}


/*- SplashImage  ----------------------------------------------------------

James Trevelyan  September 1991

Function to quickly draw an image on the screen.  We clear the window, then
retrieve a small section to get the format right and check it for
consistency.  Then, we create a temporary holding area for the image data
and create it using assumed layout of the X colour table.  When the image
has been put into the window, the temporary holding areas are released.

This routine exploits the X image format to speed up the process and may not
be compatible with other hardware platforms.


To find out about X images, I wrote a test function to: (a) create a test
image (in the vision format) and (b) to display it using ShowImage(), (c)
to retrieve it using XGetImage, (d) to print out the header and data. This
showed that the X colour table values consist of the following when the
program is running: 0 - white 1 - black 2,3,4 - frame colours (normal,
rlight, dark) 5 - background colour 6 - grey frame colour (for scrollbars)
7....  colours generated for image display (from our client) Initially, my
colour(0) was black, so X saves space in its colour table by using a
reference to its colour(1) above.  This would complicate the image
generation, so I arranged for my darkest image shade to be not quite
black.

This done, the routine worked fine by assuming the first 7 colours were not
to be used. Until..........

Well, I put the PROPERTIES display up with all its colour palettes.  And
found that I had a problem. X had placed the palette colours where I
expected mine to be, so I produced a pseudo-colour image.  To get round
this, I decided to generate the 64 shades in my small test image, retrieve
them with the XGetImage call and use the resulting pixel array as a
look-up table.

------------------------------------------------------------------------------*/

#define NBYTE 4			/* number of bytes per word on this machine */
#define NXCOLOR 7		/* number of colours used by Xview for frame,
				 * background etc. */

void     SplashImage(image, sscale, map, x_orig, y_orig)
IMAGE   *image;			/* our image format */
int      sscale;
int	 map;
int 	 x_orig, y_orig;
{
    register char    *data, *data1, *save;
    register int      i, j, saved_bytes, ii, jj, im, nbl, nxc, nyc, imi, imj;
    static int	      LAST_IM_VALUE=0;

    if (image == NULL) {
        return;
    }

    if (map) {
	magimagecols=image->cols;
	magimagerows=image->rows;

        DrawInto2(mapcanvas);
    }
    else {
        DrawInto2(imagecanvas);
    }

    nxc = image->cols * sscale;
    nyc = image->rows * sscale;



    if (map==2) {
        XClearWindow(display, win);
    }

    if (!map) {
        XClearWindow(display, win);
    }
    else {
         if (LAST_IM_VALUE != IM_VALUE) {
             XClearWindow(display, win);
	 }
             LAST_IM_VALUE = IM_VALUE;
    }

    if (map) {

       if (xmapimage != NULL) {
	  XDestroyImage(xmapimage);
	  xmapimage = (XImage *) NULL;	
       }

       xmapimage = (XImage *) XCreateImage(display, DefaultVisual(display, DefaultScreen(display)),
				     (unsigned int) 8, (int) ZPixmap, (int) 0, (char *) NULL, 
				     (unsigned int) winwidth, (unsigned int) 10, (int) 8, (int) 640);
    }
    else {

	if (ximage != NULL) {
                XDestroyImage(ximage);
	        ximage = (XImage *) NULL;	
        }

        ximage = (XImage *) XCreateImage(display, DefaultVisual(display, DefaultScreen(display)),
			     (unsigned int) 8, (int) ZPixmap, (int) 0, (char *) NULL, 
			     (unsigned int) 128, (unsigned int) 10, (int) 8, (int) 640);
    }

#ifdef CUTOUT
    if (!(			/* check image format */
	  (ximage->byte_order == MSBFirst) &&
	  (ximage->bitmap_bit_order == MSBFirst) &&
	  (ximage->bitmap_unit == NBYTE * 8) &&
	  (ximage->depth == 8) &&
	  (ximage->bits_per_pixel == 8) &&
	  (ximage->xoffset == 0))) {

	(void) printf("SplashImage: Incompatible X image format\n");
	(void) printf("X image data\n");
	if (ximage->byte_order == LSBFirst)
	    (void) printf("LSBFirst\n");
	if (ximage->byte_order == MSBFirst)
	    (void) printf("MSBFirst\n");
	if (ximage->bitmap_bit_order == LSBFirst)
	    (void) printf("bits: LSBFirst\n");
	if (ximage->bitmap_bit_order == MSBFirst)
	    (void) printf("bits: MSBFirst\n");
	(void) printf("bitmap_unit: %d\n", ximage->bitmap_unit);
	(void) printf("depth: %d\n", ximage->depth);
	(void) printf("bytes_per_line: %d\n", ximage->bytes_per_line);
	(void) printf("bits_per_pixel: %d\n", ximage->bits_per_pixel);
	(void) printf("width %d\n", ximage->width);
	(void) printf("height %d\n", ximage->height);
	(void) printf("xoffset %d\n", ximage->xoffset);
    } else 
#endif
{
	if (map) { 

	    save = xmapimage->data;	/* retain original saved data pointer */
	    if (xmapimage->data != NULL) {
	        (void) free((char *) xmapimage->data);
	    }
	}
   	else {
	    save = ximage->data;	/* retain original saved data pointer */
	    if (ximage->data != NULL) {
	        (void) free((char *) ximage->data);
	    }
	}

	nbl = (((nxc - 1) / NBYTE + 1) * NBYTE);	/* bytes per line */

	if (xblankimage == NULL) {

            xblankimage = (XImage *) XCreateImage(display, DefaultVisual(display, DefaultScreen(display)), 
					  (unsigned int) 8, (int) ZPixmap, (int) 0, (char *) NULL, 
				     	  (unsigned int) winwidth, (unsigned int) 10, (int) 8, (int) 640);

            xblankimage->data = (char *) malloc(nbl * nyc * sizeof(char));
            if (xblankimage->data == NULL) {
                VIP_Error_Msg("SplashImage: Unable to allocate memory for blank map image");
                return;
	    }

	    xblankimage->bytes_per_line = nbl;

            for (j = 0, imj = 0; imj < image->rows, j < nyc; j += sscale, imj += 4 ) {
 	       if (imj >= image->rows) {
                   break;
               }

               data = xblankimage->data + j * xblankimage->bytes_per_line;
               for (i = 0, imi = 0; i < nxc, imi <= 344; i += sscale, imi += 4 ) {
		   im = *data = colour_table[LUT[0] / 2];
                    data++;
                    for (ii = 1;  ii < sscale; ii++, data++)
                       *data = im;
               }
               for (jj = 1; (jj < sscale) && (j + jj < image->rows ); jj++) {
                    data1 = xblankimage->data + j * xblankimage->bytes_per_line;
                    data = data1 + jj * xblankimage->bytes_per_line;
                    for (i = 0; i < image->cols ; i++, data++, data1++)
                        *data = *data1;
               }
            }

	    xblankimage->width = nxc;
	    xblankimage->height = nyc;
	}

	if (map) {
            xmapimage->data = (char *) malloc(nbl * nyc * sizeof(char));
	    if (xmapimage->data == NULL) {
                VIP_Error_Msg("SplashImage: Unable to allocate memory for map image");
                return;
            }
	}
	else {
            ximage->data = (char *) malloc(nbl * nyc * sizeof(char));
            if (ximage->data == NULL) {
                VIP_Error_Msg("SplashImage: Unable to allocate memory for image");
                return;
	    }
	}

        if (map) {
	        saved_bytes = xmapimage->bytes_per_line;
        }
        else {
          saved_bytes = ximage->bytes_per_line;
        }

        if (map) {
	     xmapimage->bytes_per_line = nbl;
	}
	else {
	   ximage->bytes_per_line = nbl;
	}

        if (!map) {
	    for (j = 0, imj = 0; j < nyc; j += sscale, imj++) {
		data = ximage->data + j * ximage->bytes_per_line;
		for (i = 0, imi = 0; i < nxc; i += sscale, imi++) {
		    im = *data = colour_table[LUT[image->i.c[imj][imi]] / 2];
	                  /* use colour_table as the lookup table */
		    data++;
		    for (ii = 1; ii < sscale; ii++, data++ ) {
			*data = im;
		    }
		}

		for (jj = 1; (jj < sscale) && (j + jj < nyc); jj++) {
		    data1 = ximage->data + j * ximage->bytes_per_line;
		    data = data1 + jj * ximage->bytes_per_line;
		    for (i = 0; i < nxc; i++, data++, data1++) {
			*data = *data1;
		    }
		}
	    }
 
	}



        if (map) {
           for (j = 0, imj = 0; imj < image->rows, j < nyc; j += sscale, imj += 4 ) {
 	       if (imj >= image->rows) {
                   break;
               }

               data = xmapimage->data + j * xmapimage->bytes_per_line;
               for (i = 0, imi = 0; i < nxc, imi <= 344; i += sscale, imi += 4 ) {
		   im = *data = colour_table[LUT[image->i.c[imj][imi]] / 2];
                   /* use colour_table as the lookup * table */
                    data++;
                    for (ii = 1;  ii < sscale; ii++, data++)
                       *data = im;
               }
               for (jj = 1; (jj < sscale) && (j + jj < image->rows ); jj++) {
                    data1 = xmapimage->data + j * xmapimage->bytes_per_line;
                    data = data1 + jj * xmapimage->bytes_per_line;
                    for (i = 0; i < image->cols ; i++, data++, data1++)
                        *data = *data1;
               }
           }
 
       }



	    if (map) {
	        xmapimage->width = nxc;
	        xmapimage->height = nyc;
	    }
            else {
	        ximage->width = nxc;
	        ximage->height = nyc;
	    }


	    /* now plonk the image into the window */

	    XPutImage(display, win, gc,	
	         map ? xmapimage : ximage,
		 map ? 0 : x_orig, map ? 0 : y_orig,
	         0, 0,
                 map ? image->cols/4 : winwidth, map ? image->rows/4 : winheight);
  
	    if (!map) {/*
	        free((char *) ximage->data);*/	/* free up the temporary area */
	    }

    }

    REDRAWN = TRUE;


    return;
}

/*- InitWindows  ----------------------------------------------------------*/

void InitWindows(argc, argv)
int      argc;
char    *argv[];
{
  static Xv_singlecolor colour[231];	/* The colour table. */
  Arg	args[15];
  XmString clistring = XmStringCreateSimple ("Image : ");
  XmString quitbuttonstring1 = XmStringCreateSimple("Quit");
  XmString quitbuttonstring2 = XmStringCreateSimple("Quit Tools");
  XmString resetbuttonstring = XmStringCreateSimple("Reset");
  XmString threshbuttonstring = XmStringCreateSimple("On/Off");
  XmString toolbuttonstring = XmStringCreateSimple("Tools");
  XmString maglabelstring1 = XmStringCreateSimple("Magnification Factor          ");
  XmString imbuttonlabelstring1 = XmStringCreateSimple("Prev/Curr Image");
  XmString gamma_label_string = XmStringCreateSimple ("Gamma Adjustment  ");
  XmString thresh_label_string = XmStringCreateSimple ("Threshold Value  ");
  XmString pushbutton_label_string = XmStringCreateSimple ("Save");
  XColor   color, unused;
  int	    imcanvaswidth;
  int	    imcanvasheight;
  int	    mapcanvaswidth;
  int	    mapcanvasheight;

    cmap = XDefaultColormap (display, screen);
    (void) XFreeColormap(display, cmap);
   
    LUT = (int *) malloc(256 * sizeof(int));

    Set_Look_Up_Table(LUT, 1.0);

    /* 
       Set up appln. colors in cmap and create the link to the global 
       colour_table. 
    */

    set_colormap (colour);

    ARGVIMAGE[0]='\0';

    if (argc == 2) {
        strcpy(ARGVIMAGE, argv[1]);
        initial_image=1;

        tempimage = ( IMAGE * ) Read_Image(ARGVIMAGE);

        if (tempimage) {
            temprows = tempimage->rows;
	    tempcols = tempimage->cols;
	    if (tempimage->type == COMPLEXTYPE) {
                COMPLEX_IMAGE=1;
	    }
            (void) Free_Image(tempimage);
        }
        else {
	    if (initial_image) {
	        (void) printf ("Specified image file not found or invalid : please try again\n");
	        exit(0);
	    }
	    else { 
                temprows = 249;
                tempcols = 249;
	    }
        }
    }
    else {
        strcpy(ARGVIMAGE, "\0");
	NO_INITIAL_IMAGE_ARG=1;
    }


    if (temprows < 345) {
        temprows = 249;
    }
    if (tempcols < 345) {
        tempcols = 249;
    }

    /* Set min dimensions for topLevel */

    XtVaSetValues (topLevel, XmNminWidth, tempcols < 345 ? 345 : tempcols, NULL);
    XtVaSetValues (topLevel, XmNminHeight, temprows < 345 ? 108 : (temprows/4)+16, NULL);

    /* Create a form to put buttons on */

    XtSetArg (args[0], XmNwidth, tempcols < 345 ? 345 : tempcols);
    XtSetArg (args[1], XmNheight, temprows < 345 ? 396+(temprows/4) :
			          (temprows+21)+(temprows/4));
    XtSetArg (args[2], XmNresizePolicy, XmRESIZE_ANY);

    controlform = XtCreateManagedWidget ("controlform", 
				  	  xmFormWidgetClass, 
				          topLevel, 
				          args, 3);


    /* Create a quit button. */

    XtSetArg (args[0], XmNx, 4);
    XtSetArg (args[1], XmNy, 45);
    XtSetArg (args[2], XmNlabelString, quitbuttonstring1);
    XtSetArg (args[3], XmNwidth, 75);
 
    quitbutton = XtCreateManagedWidget ("quitbutton", 
				         xmPushButtonWidgetClass, 
				         controlform, 
				         args, 4);

    XmStringFree(quitbuttonstring1);

    XtAddCallback (quitbutton, XmNactivateCallback, quit, NULL);
		     
    /* Create a tool button. */

    XtSetArg (args[0], XmNx, 4);
    XtSetArg (args[1], XmNy, 75);
    XtSetArg (args[2], XmNlabelString, toolbuttonstring);
    XtSetArg (args[3], XmNwidth, 75);

    toolbutton = XtCreateManagedWidget ("toolbutton", 
			                 xmPushButtonWidgetClass, 
					 controlform, 
			                 args, 4);

    if (strcmp(ARGVIMAGE, "\0")==0) {
        XtSetSensitive(toolbutton, FALSE);
    }
    else {
        XtSetSensitive(toolbutton, TRUE);
    }

    XtAddCallback (toolbutton, XmNactivateCallback, showtoolsframe, NULL);
		     

    /* Create a command line interface. */


    XtSetArg (args[0], XmNlabelString, clistring );
    XtSetArg (args[1], XmNx, 10);
    XtSetArg (args[2], XmNy, 15);
    XtSetArg (args[3], XmNwidth, 75);

    clilabel = XtCreateManagedWidget ("clilabel", 
				       xmLabelWidgetClass, 
				       controlform,
				       args, 4);

    XmStringFree(clistring);


    XtSetArg (args[0], XmNeditable, TRUE );
    XtSetArg (args[1], XmNwidth, (Dimension) 160);
    XtSetArg (args[2], XmNx, 85);
    XtSetArg (args[3], XmNy, 10);
    XtSetArg (args[4], XmNhighlightOnEnter, TRUE);

    imfilename_panel = XtCreateManagedWidget ("imfilename_panel", 
				      xmTextFieldWidgetClass, 
				      controlform, 
				      args, 4);

    XmTextFieldSetString (imfilename_panel, ARGVIMAGE);

    XtAddCallback (imfilename_panel, 
		   XmNactivateCallback, 
		   (XtCallbackProc) GetFile3, 
		   (char *) NULL);
		     

    XtSetArg (args[0], XmNx, 84);
    XtSetArg (args[1], XmNy, 50);
    XtSetArg (args[2], XmNwidth, 163);
    XtSetArg (args[3], XmNheight, 45);
    XtSetArg (args[4], XmNcolormap, cmap);
    XtSetArg (args[5], XmNresizePolicy, XmRESIZE_GROW);

    intcanvas = XtCreateManagedWidget ("intcanvas", 
				       xmDrawingAreaWidgetClass, 
				       controlform, 
				       args, 6);

    XtSetArg (args[0], XmNx, 0);
    XtSetArg (args[1], XmNy, temprows < 345 ? 112 : (temprows/4)+21);
    XtSetArg (args[2], XmNwidth, tempcols < 345 ? 345 : tempcols);
    XtSetArg (args[3], XmNheight, temprows < 345 ? 346: (temprows));
    XtSetArg (args[4], XmNcolormap, cmap);
    XtSetArg (args[5], XmNresizePolicy, XmRESIZE_GROW);

 
    imagecanvas = XtCreateManagedWidget ("imagecanvas", 
				         xmDrawingAreaWidgetClass, 
				         controlform, 
					 args, 6);

    XtSetArg (args[0], XmNx, tempcols < 345 ? 253 : 
			         (tempcols-5)-(tempcols/4));
    XtSetArg (args[1], XmNy, temprows < 345 ? 10 : 11);
    XtSetArg (args[2], XmNwidth, tempcols < 345 ? 349/4 :  (tempcols/4));
    XtSetArg (args[3], XmNheight, temprows < 345 ? 345/4: (temprows/4));
    XtSetArg (args[4], XmNcolormap, cmap);
    XtSetArg (args[5], XmNresizePolicy, XmRESIZE_GROW);

    mapcanvas = XtCreateManagedWidget ("mapcanvas", 
					   xmDrawingAreaWidgetClass, 
					   controlform, 
					   args, 6);

    XAllocNamedColor(display, cmap, "black", &color, &unused);
    bg_color = color.pixel;

    XtVaSetValues (imagecanvas, XmNbackground, bg_color, NULL);
    XtVaSetValues (mapcanvas, XmNbackground, bg_color, NULL);
    XtVaSetValues (intcanvas, XmNforeground, bg_color, NULL);

    /* Save canvas display(s) */

    XtSetArg (args[0], XmNwidth, &imcanvaswidth);
    XtGetValues(imagecanvas, args, 1);

    XtSetArg (args[0], XmNheight, &imcanvasheight);
    XtGetValues(imagecanvas, args, 1);

    SaveDpy( XtDisplay(controlform), 
	     XtWindow(imagecanvas),
             imcanvaswidth,
	     imcanvasheight );

    if (initial_image) {
    
	XtSetArg (args[0], XmNwidth, &mapcanvaswidth);
        XtGetValues(mapcanvas, args, 1);

        XtSetArg (args[0], XmNheight, &mapcanvasheight);
        XtGetValues(mapcanvas, args, 1);

        SaveDpy( XtDisplay(controlform),
	         XtWindow(mapcanvas),
	         mapcanvaswidth,
	         mapcanvasheight );

    }
 
    /*
    * Define all of the events that can occur in the canvas. When one of
    * these events occur it will call event_proc.
    */

    XtAddEventHandler(imagecanvas, StructureNotifyMask, FALSE, 
		       (XtEventHandler) event_proc2, (caddr_t) NULL);
  
    XtAddEventHandler(imagecanvas, VisibilityChangeMask, FALSE, 
		       (XtEventHandler) event_proc2, (caddr_t) NULL);

    XtAddEventHandler(imagecanvas, ButtonPressMask, FALSE, 
		       (XtEventHandler) event_proc2, (caddr_t) NULL);
  
    XtAddEventHandler(imagecanvas, ButtonReleaseMask, FALSE, 
		       (XtEventHandler) event_proc2, (caddr_t) NULL);
  
    XtAddEventHandler(imagecanvas, Button1MotionMask, FALSE, 
		       (XtEventHandler) event_proc2, (caddr_t) NULL);
  
    XtAddEventHandler(imagecanvas, PointerMotionMask, FALSE, 
		       (XtEventHandler) event_proc2, (caddr_t) NULL);
  
    XtAddEventHandler(imagecanvas, FocusChangeMask, FALSE, 
		       (XtEventHandler) event_proc2, (caddr_t) NULL);
  
    XtAddEventHandler(imagecanvas, KeyPressMask, FALSE, 
		       (XtEventHandler) event_proc2, (caddr_t) NULL);

    XtAddEventHandler(imagecanvas, KeyReleaseMask, FALSE, 
		       (XtEventHandler) event_proc2, (caddr_t) NULL);
  

    XtAddEventHandler(imagecanvas, ResizeRedirectMask, FALSE, 
		       (XtEventHandler) event_proc2, (caddr_t) NULL);


    XtAddEventHandler(imagecanvas, ExposureMask, FALSE, 
		       (XtEventHandler) event_proc2, (caddr_t) NULL);

                      /* All above event are equivalent to ones specified
		         in XView appln., except for WIN_ASCII_EVENTS;
			 can't find it in XView manual!
		      */

    XtAddEventHandler(mapcanvas, ButtonPressMask, FALSE, 
		       (XtEventHandler) map_event_proc2, (caddr_t) NULL);
  
    XtAddEventHandler(mapcanvas, ButtonReleaseMask, FALSE, 
		       (XtEventHandler) map_event_proc2, (caddr_t) NULL);
  
    XtAddEventHandler(mapcanvas, Button1MotionMask, FALSE, 
		       (XtEventHandler) map_event_proc2, (caddr_t) NULL);

    XtAddEventHandler(mapcanvas, ExposureMask, FALSE, 
		       (XtEventHandler) map_event_proc2, (caddr_t) NULL);

  

    /* Tools Frame */

    XtSetArg (args[0], XmNheight, 470);
    XtSetArg (args[1], XmNwidth, 521);
    XtSetArg (args[2], XmNx, 500); 
    XtSetArg (args[3], XmNy, 100);
    XtSetArg (args[4], XmNmappedWhenManaged, FALSE);
 
    toolsframe = XtAppCreateShell ("splm tools", "", 
 			    	   applicationShellWidgetClass, 
				   display, args, 5);

    XtSetArg (args[0], XmNheight, 360);
    XtSetArg (args[1], XmNwidth, 400);
 
    toolsform = XtCreateManagedWidget ("toolsform", 
		                       xmFormWidgetClass,
			               toolsframe, args, 2);

    XtRealizeWidget(toolsframe);


    XtSetArg (args[0], XmNlabelString, maglabelstring1);
    XtSetArg (args[1], XmNy, 14);
    XtSetArg (args[2], XmNx, 15);

    maglabel1 = XtCreateManagedWidget ("maglabel1", 
				      xmLabelWidgetClass, 
				      toolsform,
				      args, 3);
    XmStringFree(maglabelstring1);
 
    XtSetArg (args[0], XmNx, 196);
    XtSetArg (args[1], XmNy, 7);
    XtSetArg (args[2], XmNorientation, XmHORIZONTAL);

    radiobox = XmCreateRadioBox(toolsform,
			        "radiobox", 
				args, 3);

        magbutton1 = XtVaCreateManagedWidget ("1", 
			                xmToggleButtonGadgetClass,
                                        radiobox, 
				        XmNindicatorType, XmN_OF_MANY,
					XmNspacing, 1, 
				        NULL);

        magbutton2 = XtVaCreateManagedWidget ("2", 
			                xmToggleButtonGadgetClass,
                                        radiobox, 
				        XmNindicatorType, XmN_OF_MANY, 
					XmNspacing, 1, 
				        NULL);

        magbutton3 = XtVaCreateManagedWidget ("3", 
			                xmToggleButtonGadgetClass,
                                        radiobox, 
				        XmNindicatorType, XmN_OF_MANY, 
					XmNspacing, 1, 
				        NULL);

        magbutton4 = XtVaCreateManagedWidget ("4", 
			                xmToggleButtonGadgetClass,
                                        radiobox, 
				        XmNindicatorType, XmN_OF_MANY, 
					XmNspacing, 1, 
				        NULL);

        magbutton5 = XtVaCreateManagedWidget ("5", 
			                xmToggleButtonGadgetClass,
                                        radiobox, 
				        XmNindicatorType, XmN_OF_MANY, 
					XmNspacing, 1, 
				        NULL);

        magbutton6 = XtVaCreateManagedWidget ("6", 
			                xmToggleButtonGadgetClass,
                                        radiobox, 
				        XmNindicatorType, XmN_OF_MANY, 
					XmNspacing, 1, 
				        NULL);

        XtAddCallback (magbutton1, 
		       XmNvalueChangedCallback, 
		       (XtCallbackProc) SetMagnification2, 
		       (XtPointer) 1);

        XtAddCallback (magbutton2, 
		       XmNvalueChangedCallback, 
		       (XtCallbackProc) SetMagnification2, 
		       (XtPointer) 2);

        XtAddCallback (magbutton3, 
		       XmNvalueChangedCallback, 
		       (XtCallbackProc) SetMagnification2, 
		       (XtPointer) 3);

        XtAddCallback (magbutton4, 
		       XmNvalueChangedCallback, 
		       (XtCallbackProc) SetMagnification2, 
		       (XtPointer) 4);

        XtAddCallback (magbutton5, 
		       XmNvalueChangedCallback, 
		       (XtCallbackProc) SetMagnification2, 
		       (XtPointer) 5);

        XtAddCallback (magbutton6, 
		       XmNvalueChangedCallback, 
		       (XtCallbackProc) SetMagnification2, 
		       (XtPointer) 6);

    XtManageChild(radiobox);


    XtSetArg (args[0], XmNlabelString, imbuttonlabelstring1);
    XtSetArg (args[1], XmNx, 14);
    XtSetArg (args[2], XmNy, 51);
/*
    XtSetArg (args[3], XmNwidth, 175);
*/

    imbuttonlabel1 = XtCreateManagedWidget ("imbuttonlabel1", 
				            xmLabelWidgetClass, 
				            toolsform,
				            args, 3);

    XmStringFree(imbuttonlabelstring1);

    XtSetArg (args[0], XmNx, 200);
    XtSetArg (args[1], XmNy, 47);
    XtSetArg (args[2], XmNsensitive, !ARGVIMAGE ? FALSE : TRUE);
    XtSetArg (args[3], XmNvisibleWhenOff, TRUE);
    XtSetArg (args[4], XmNset, FALSE);
    XtSetArg (args[5], XmNspacing, FALSE);

    imbutton1 = XtCreateManagedWidget (NULL, 
		                       xmToggleButtonWidgetClass,
                                       toolsform, 
				       args, 6);

    XtAddCallback (imbutton1, XmNvalueChangedCallback, (XtCallbackProc) SetImage2, NULL);
		     

    XtSetArg (args[0], XmNmappedWhenManaged, TRUE);
    XtSetValues (imbuttonlabel1, args, 1);

    if (!PREVIOUS_IMAGE) {
        XtSetArg (args[0], XmNsensitive, FALSE);
        XtSetValues (imbutton1, args, 1);
    }
    else {
        XtSetArg (args[0], XmNsensitive, TRUE);
        XtSetValues (imbutton1, args, 1);
    }

    XtSetArg (args[0], XmNlabelString, gamma_label_string);
    XtSetArg (args[1], XmNx, 15);
    XtSetArg (args[2], XmNy, 89);

    gammalabel = XtCreateManagedWidget ("gammalabel", 
				        xmLabelWidgetClass, 
				        toolsform,
				        args, 3);

    XtSetArg (args[0], XmNlabelString, gamma_label_string);
    XtSetArg (args[1], XmNx, 205);
    XtSetArg (args[2], XmNy, 70);
    XtSetArg (args[3], XmNmaximum, 400);
    XtSetArg (args[4], XmNminimum, 0);
    XtSetArg (args[5], XmNvalue, 100);
    XtSetArg (args[6], XmNshowValue, TRUE);
    XtSetArg (args[7], XmNorientation, XmHORIZONTAL);
    XtSetArg (args[8], XmNprocessingDirection, XmMAX_ON_RIGHT);
    XtSetArg (args[9], XmNscaleMultiple, 1);
    XtSetArg (args[10], XmNwidth, 190);
    XtSetArg (args[11], XmNdecimalPoints, 2);

    gammascale = XtCreateManagedWidget ("gammascale",
				   	xmScaleWidgetClass,
					toolsform,
                                        args, 12);

    XmStringFree(gamma_label_string);

    XtAddCallback (gammascale, XmNdragCallback, (XtCallbackProc) setgamma2, NULL);
    
    XtAddCallback (gammascale, XmNvalueChangedCallback, (XtCallbackProc) setgamma2, NULL);


    XtSetArg (args[0], XmNlabelString, resetbuttonstring);
    XtSetArg (args[1], XmNwidth, 175);
    XtSetArg (args[2], XmNx, 430);
    XtSetArg (args[3], XmNy, 88);
    XtSetArg (args[4], XmNwidth, 80);

    resetbuttonlabel = XtCreateManagedWidget ("resetbuttonlabel", 
				            xmLabelWidgetClass, 
				            toolsform,
				            args, 5);
    XmStringFree(resetbuttonstring);

    XtSetArg (args[0], XmNx, 412);
    XtSetArg (args[1], XmNy, 84);
    XtSetArg (args[2], XmNset, FALSE);
    XtSetArg (args[3], XmNspacing, 1);
 
    resetbutton = XtCreateManagedWidget ("", 
				         xmToggleButtonWidgetClass, 
				         toolsform, 
				         args, 4);

    XtAddCallback (resetbutton, XmNvalueChangedCallback, (XtCallbackProc) resetgamma, NULL);
		     

    XtSetArg (args[0], XmNlabelString, threshbuttonstring);
    XtSetArg (args[1], XmNwidth, 175);
    XtSetArg (args[2], XmNx, 395);
    XtSetArg (args[3], XmNy, 128);
    XtSetArg (args[4], XmNwidth, 155);

    threshbuttonlabel = XtCreateManagedWidget ("threshbuttonlabel", 
				            xmLabelWidgetClass, 
				            toolsform,
				            args, 5);
    XmStringFree(threshbuttonstring);

    XtSetArg (args[0], XmNx, 412);
    XtSetArg (args[1], XmNy, 124);
    XtSetArg (args[2], XmNset, FALSE);
    XtSetArg (args[3], XmNspacing, 1);
 
    threshbutton = XtCreateManagedWidget ("", 
				         xmToggleButtonWidgetClass, 
				         toolsform, 
				         args, 4);

    XtAddCallback (threshbutton, XmNvalueChangedCallback, (XtCallbackProc) setthreshbutton, NULL);

    XtSetArg (args[0], XmNlabelString, thresh_label_string);
    XtSetArg (args[1], XmNx, 15);
    XtSetArg (args[2], XmNy, 127);

    threshlabel = XtCreateManagedWidget ("threslabel", 
				        xmLabelWidgetClass, 
				        toolsform,
				        args, 3);

    XtSetArg (args[0], XmNlabelString, thresh_label_string);
    XtSetArg (args[1], XmNx, 205);
    XtSetArg (args[2], XmNy, 110);
    XtSetArg (args[3], XmNmaximum, 255);
    XtSetArg (args[4], XmNminimum, 0);
    XtSetArg (args[5], XmNvalue, 127);
    XtSetArg (args[6], XmNshowValue, TRUE);
    XtSetArg (args[7], XmNorientation, XmHORIZONTAL);
    XtSetArg (args[8], XmNprocessingDirection, XmMAX_ON_RIGHT);
    XtSetArg (args[9], XmNscaleMultiple, 1);
    XtSetArg (args[10], XmNwidth, 190);

    threshscale = XtCreateManagedWidget ("threshscale",
				   	xmScaleWidgetClass,
					toolsform,
                                        args, 11);

    XmStringFree(thresh_label_string);

    XtVaSetValues (threshscale, XmNsensitive, FALSE, NULL);
    

    XtAddCallback (threshscale, XmNdragCallback, (XtCallbackProc) setthresh2, NULL);
    
    XtAddCallback (threshscale, XmNvalueChangedCallback, (XtCallbackProc) setthresh2, NULL);

    XtSetArg (args[0], XmNx, 412);
    XtSetArg (args[1], XmNy, 43);
    XtSetArg (args[2], XmNlabelString, pushbutton_label_string);
    XtSetArg (args[3], XmNwidth, 100);
 
    savebutton = XtCreateManagedWidget ("savebutton", 
				         xmPushButtonWidgetClass, 
				         toolsform, 
				         args, 4);

    XtAddCallback (savebutton, XmNactivateCallback, 
			       (XtCallbackProc) Show_Popup_Frame, NULL);

    XmStringFree(pushbutton_label_string);

    XtSetArg (args[0], XmNx, 412);
    XtSetArg (args[1], XmNy, 13);
    XtSetArg (args[2], XmNlabelString, quitbuttonstring2);
    XtSetArg (args[3], XmNwidth, 100);
 
    quitbutton2 = XtCreateManagedWidget ("quitbutton2", 
				         xmPushButtonWidgetClass, 
				         toolsform, 
				         args, 4);

    XtAddCallback (quitbutton2, XmNactivateCallback, 
		   (XtCallbackProc) quit_tools, NULL);

    XmStringFree(quitbuttonstring2);
		     
    XtSetArg (args[0], XmNx, 5);
    XtSetArg (args[1], XmNy, 155);
    XtSetArg (args[2], XmNwidth, 512);
    XtSetArg (args[3], XmNheight, 150);
    XtSetArg (args[4], XmNcolormap, cmap);
    XtSetArg (args[5], XmNresizePolicy, XmRESIZE_GROW);

    slicecanvas = XtCreateManagedWidget ("slicecanvas", 
				         xmDrawingAreaWidgetClass, 
				         toolsform, 
					 args, 6);

    XtSetArg (args[0], XmNx, 5);
    XtSetArg (args[1], XmNy, 315);
    XtSetArg (args[2], XmNwidth, 512);
    XtSetArg (args[3], XmNheight, 150);
    XtSetArg (args[4], XmNcolormap, cmap);
    XtSetArg (args[5], XmNresizePolicy, XmRESIZE_GROW);

    LUTslicecanvas = XtCreateManagedWidget ("LUTslicecanvas", 
				            xmDrawingAreaWidgetClass, 
				            toolsform, 
					    args, 6);

    XtAddEventHandler(slicecanvas, ExposureMask, FALSE, 
		       (XtEventHandler) event_proc3, (caddr_t) NULL);

    XtAddEventHandler(LUTslicecanvas, ExposureMask, FALSE, 
		       (XtEventHandler) event_proc3, (caddr_t) NULL);

    XtRealizeWidget(topLevel);
    XtAppMainLoop(appContext);
}


void     quit()
{
    XtDestroyWidget(topLevel);
    exit(0);
}

void initial_useropt_quit2 (w, client_data, cbs)
  Widget	w;
  XtPointer	client_data;
  XmToggleButtonCallbackStruct	*cbs;
{
  CopyBytetypeImages(prev_image1, image1);

  COMPLEX_CONVERTED=0;

  XtDestroyWidget(w);

  SplashImage(image1, magnification, 0, 0, 0);
  SplashImage(image1, 1, 1, (mapx_coord*4)*magnification, (mapy_coord*4)*magnification);


  XtVaSetValues (imbutton1, XmNsensitive, TRUE, NULL);
  XtVaSetValues (toolbutton, XmNsensitive, TRUE, NULL);
  XtVaSetValues (imfilename_panel, XmNsensitive, TRUE, NULL);
  XtVaSetValues (imfilename_panel, XmNhighlightOnEnter, TRUE, NULL);
}

void     useropt_quit2(item, value, event)
  Widget item;
  int value;
  XmPushButtonCallbackStruct   *event;
{
  COMPLEX_CONVERTED=0;

  XtDestroyWidget (useroptframe);

  useroptframe=( Widget )NULL;

  XtVaSetValues (imfilename_panel, XmNsensitive, TRUE, NULL);
  XtVaSetValues (imbutton1, XmNvalue, 0, NULL);

  tools_selected=0;

  if (!PREVIOUS_IMAGE) {
      XtVaSetValues (imbutton1, XmNsensitive, FALSE, NULL);
  }
  else {
      XtVaSetValues (imbutton1, XmNsensitive, TRUE, NULL);
  }
  
  return;
}

void     quit_tools()
{
    if (popupdialogexists) {
        if (XtIsRealized(popupdialog)) {
    	    popupdialogexists = 0;
            XtDestroyWidget(popupdialog);
        }
    }

    XtUnmapWidget(toolsframe);

    XtVaSetValues (toolbutton, XmNsensitive, TRUE, NULL);
    XtVaSetValues (imfilename_panel, XmNsensitive, TRUE, NULL);
    XtVaSetValues (savebutton, XmNsensitive, TRUE, NULL);

    tools_selected=0;
    return;
}

/*---------------------------------------------------------------------*/


/* ARGSUSED */
void     event_proc3(window, client_data, event)
  Widget 		window;
  XtPointer		client_data;
  XEvent   		*event;
{
  int      x=0, y=0, x1=0, y1=0;
  int      action=0;

    if (event->type == Expose) {
        action = ACTION_SLICE;
        x = event->xexpose.x;
        y = event->xexpose.y;

        if (y<0) {
            y1 = y*-1;
            y = y1;
        }

        if (x<0) {
            x1 = x*-1;
            x = x1;
        }

        (void) Make_Slice(x, y, action);
    }
   
    action=0;


    return;
}

/* ARGSUSED */
void     event_proc2(window, client_data, event)
  Widget 		window;
  XtPointer		client_data;
  XEvent   		*event;
{
  Arg	   args[15];
  int      x=0, y=0, x1=0, y1=0, value;
  int      action=0;
  int      eflag=0;
  int	    imcanvaswidth;
  int	    imcanvasheight;

/*
        (void) printf("IN EVENT PROC : event->type = %d\n", event->type);
	(void) printf("VisibilityNotify = %d\n", VisibilityNotify);
	(void) printf("ButtonPress = %d\n", ButtonPress);
	(void) printf("ButtonRelease = %d\n", ButtonRelease);
	(void) printf("MotionNotify = %d\n", MotionNotify );
	(void) printf("Expose = %d\n", Expose);
	(void) printf("FocusIn = %d\n",FocusIn);
	(void) printf("FocusOut = %d\n",FocusOut);
	(void) printf("ResizeRequest = %d\n", ResizeRequest);
	(void) printf("\n");
	(void) printf("\n");
*/

    if (event->type == VisibilityNotify) {
	state=2;
        if (firstime<2) {
            initial_splash2();
	}
    }

    if (event->type == KeyPress) {
        event=NULL;
        return;
    }

    if (event->type == KeyRelease) {
        event=NULL;
        return;
    }

    if (event->type == ButtonPress) {

        if (event->xbutton.button == 1) {
            eflag=1;
        }
        x = event->xbutton.x;
        y = event->xbutton.y;
    }

    if (event->type == ButtonRelease) {
        if (event->xbutton.button == 1) {
            eflag=1;
        }

        x = event->xbutton.x;
        y = event->xbutton.y;
    }

    if (event->type == MotionNotify) {
        eflag=1;
        x = event->xmotion.x;
        y = event->xmotion.y;
    }
       
    if (event->type == Expose) {
        eflag=1;
        x = event->xexpose.x;
        y = event->xexpose.y;
    }

    if (event->type == FocusIn) {
        eflag=1;
    }

    if (event->type == FocusOut) {
        eflag=1;
    }

    if ((!eflag)) {
        event=NULL;
        return;
    }

    if (event->type == ButtonPress) {
        if (event->xbutton.button == 1) {
            action = ACTION_SELECT;
        }
        if (event->xbutton.button == 2) {
            action = ACTION_ADJUST;
	}
    }
    else {
        action = 0;
    }

    if (event->type != FocusIn | event->type != FocusOut | event->type != VisibilityNotify) {
            x = event->xbutton.x;
            y = event->xbutton.y;
    }

    if (y<0) {
        y1 = y*-1;
        y = y1;
    }

    if (x<0) {
        x1 = x*-1;
        x = x1;
    }    

    Set_UVInt(x, y);

    if (COMPLEX_IMAGE && !COMPLEX_CONVERTED) {
	return;
    }

    (void) Make_Slice(x, y, action);

    /*
     * pass the display and window value to repaint. This is then used to set
     * the global display and window variables.
     */

        if (event->type == 12) {
	            if (!NO_INITIAL_IMAGE_ARG) {
                    DrawInto2(imagecanvas);

            	    XPutImage(display, win, gc,	
                   	     ximage,
                    	    (mapx_coord*4)*magnification,
                    	    (mapy_coord*4)*magnification,
	            	    0,0,
                    	    ximage->width*magnification, 
		    	    ximage->height*magnification);

    		    
		     set_mag_view(mapx_coord, mapy_coord, magnification, 1);

        			if (!REDRAWN) {
            			    POST_EXPOSE=1;
				}
	 	    }
        }

	switch (event->type) {
	    case ResizeRequest :

    		XtSetArg (args[0], XmNwidth, &imcanvaswidth);
    		XtGetValues(imagecanvas, args, 1);

    		XtSetArg (args[0], XmNheight, &imcanvasheight);
    		XtGetValues(imagecanvas, args, 1);

    	        SaveDpy( XtDisplay(controlform), 
	                 XtWindow(imagecanvas),
                         imcanvaswidth,
	     	         imcanvasheight );

                value = magnification;
                magnification = Bounded(( int ) value, 1, 6);

                if (image1) {
                    DrawInto2(imagecanvas);

                    XPutImage(display, win, gc, ximage,
                                (mapx_coord*4)*magnification,
                                (mapy_coord*4)*magnification,
                                0, 0,
                                tempcols*magnification, temprows*magnification);

                    set_mag_view(mapx_coord, mapy_coord, magnification, 1);
                }

           default :

	        break;
    }
}

/*---------------------------------------------------------------------

Function to handle the digitising of slices


states: 0  - wait for first point
        1  - 1st point digitised - start rubber banding
        2  - 2nd point digitised - display slice


transitions: from 0 - 1 - when left mouse button pressed
             from 1 - 2 - when left mouse button pressed again
             from 2 - 0 - when middle mouse button pressed - clears slice
             from 2 - 1 - when left mouse button pressed - immediately starts new slice

----------------------------------------------------------------------*/



int      Make_Slice(x, y, action)
int      x, y, action;
{
    static int x0, sy0;
    static int x1, sy1;
    static int xlast, ylast;
    int    gmy0, gmy1;

    if (action == ACTION_SLICE) {
	(void) PlotSlice(x0, sy0, x1, sy1);
	return(0);
    }

    if (IM_VALUE) {
      if (prev_image1 && y > 0 && y < prev_image1->rows * magnification && x > 0 && x < prev_image1->cols * magnification) {
	DrawInto2(imagecanvas);

	switch (state) {

	case 0:
	    if (action == ACTION_SELECT) {
	            if (!NO_INITIAL_IMAGE_ARG) {
            	    DrawInto2(imagecanvas);
                    XPutImage(display, win, gc, ximage,
                                (mapx_coord*4)*magnification,
                                (mapy_coord*4)*magnification,
                                0, 0,
            			winwidth, winheight);
		    }
		x0 = xlast = x;
		sy0 = ylast = y;
		state = 1;
	        (void) PlotSlice(x0, sy0, x1, sy1);
	    }
	    break;


	case 1:
	    if (action == ACTION_SELECT) {	/* draw slice */
		x1 = xlast;
		sy1 = ylast;

		(void) PlotSlice(x0, sy0, x1, sy1);
		state = 2;

	    } else {		/* rubber band */
		(void) DrawSliceLine(x0, sy0, xlast, ylast);
		(void) DrawSliceLine(x0, sy0, x, y);
		xlast = x;
		ylast = y;
		state = 1;
	    }
	    break;


	case 2:
	    if (action == ACTION_SELECT) {	/* clear slice and start new
						 * one */
		if (!REDRAWN && !POST_EXPOSE) {
	            if (!NO_INITIAL_IMAGE_ARG) {
            	    DrawInto2(imagecanvas);
                    XPutImage(display, win, gc, ximage,
                                (mapx_coord*4)*magnification,
                                (mapy_coord*4)*magnification,
                                0, 0,
            			winwidth, winheight);
		    }
	
		    (void) SaveRetrieveSlicePts(0, &x0, &gmy0, &x1, &gmy1);	
		}
		
		POST_EXPOSE=0;
		x0 = xlast = x;
		sy0 = ylast = y;
		state = 1;
	    } else if ((action == ACTION_ADJUST)) {	/* clear slice */
		if (!REDRAWN) {
		    (void) DrawSliceLine(x0, sy0, xlast, ylast);
		    XDrawPoint(display, win, gc, x0, sy0);
		}
		state = 0;
	    } 
	    break;


	}			/* switch */
    }
  }
  else {
      if (image1 && y > 0 && y < image1->rows * magnification && x > 0 && x < image1->cols * magnification) {
	DrawInto2(imagecanvas);

	switch (state) {

	case 0:
	    if (action == ACTION_SELECT) {
	            if (!NO_INITIAL_IMAGE_ARG) {
            	    DrawInto2(imagecanvas);
                    XPutImage(display, win, gc, ximage,
                                (mapx_coord*4)*magnification,
                                (mapy_coord*4)*magnification,
                                0, 0,
            			winwidth, winheight);
		    }
		x0 = xlast = x;
		sy0 = ylast = y;
		state = 1;
	    }
	    break;


	case 1:
	    if (action == ACTION_SELECT) {	/* draw slice */
		x1 = xlast;
		sy1 = ylast;

		(void) PlotSlice(x0, sy0, x1, sy1);
		state = 2;

	    } else {		/* rubber band */
		(void) DrawSliceLine(x0, sy0, xlast, ylast);
		(void) DrawSliceLine(x0, sy0, x, y);
		xlast = x;
		ylast = y;
		state = 1;
	    }
	    break;


	case 2:
	    if (action == ACTION_SELECT) {	/* clear slice and start new
						 * one */
		if (!REDRAWN && !POST_EXPOSE) {
	            if (!NO_INITIAL_IMAGE_ARG) {
            	    DrawInto2(imagecanvas);
                    XPutImage(display, win, gc, ximage,
                                (mapx_coord*4)*magnification,
                                (mapy_coord*4)*magnification,
                                0, 0,
            			winwidth, winheight);
		    }
	
		    (void) SaveRetrieveSlicePts(0, &x0, &gmy0, &x1, &gmy1);	
		}
		
		POST_EXPOSE=0;
		x0 = xlast = x;
		sy0 = ylast = y;
		state = 1;
	    } else if ((action == ACTION_ADJUST)) {	/* clear slice */
		if (!REDRAWN) {
		    (void) DrawSliceLine(x0, sy0, xlast, ylast);
		    XDrawPoint(display, win, gc, x0, sy0);
		}
		state = 0;
	    }
	    break;


	}			/* switch */
    }
  }

    return (0);
}

/*- DrawSliceLine-----------------------------------------------------*/

int      DrawSliceLine(x0, ly0, x1, ly1)
int      x0, ly0, x1, ly1;
{
    DrawInto2(imagecanvas);

    XSetForeground(display, gc, colour_table[RED]);
    XSetFunction(display, gc, GXxor);
    XDrawLine(display, win, gc, x0, ly0, x1, ly1);
    REDRAWN = FALSE;
    return (0);
}

/*---------------------------------------------------------------------*/

void     repaint(can, paint_window, dpy, xwin, xrects, event)
Widget   can;			/* Ignored */
Window paint_window;		/* Ignored */
Display *dpy;
Window   xwin;
XRectangle *xrects;		/* Ignored */
XEvent   *event;		/* Ignored */
{
        DrawInto2(imagecanvas);

        XPutImage(display, win, gc,	
            ximage,
            (mapx_coord*4)*magnification,
            (mapy_coord*4)*magnification,
            0, 0,
            winwidth, winheight);

    return;
}


/*----------------------------------------------------------------------*/

void     showtoolsframe()
{
  Arg	args[1];

    XtMapWidget(toolsframe);

    if (prev_image1 == NULL) {
        XtSetArg (args[0], XmNsensitive, FALSE);
        XtSetValues (imbutton1, args, 1);
    } 
    else {
        XtSetArg (args[0], XmNsensitive, TRUE);
        XtSetValues (imbutton1, args, 1);
    } 
 
    tools_selected=1;
    return;
}

/*----------------------------------------------------------------------*/

void     hidetoolsframe()
{
    XtUnmapWidget(toolsframe);
    return;
}


/*----------------------------------------------------------------------*/

void     Show_Popup_Frame()
{
  Arg	args[15];

    XtVaSetValues (imfilename_panel, XmNsensitive, FALSE, NULL);
    XtVaSetValues (toolbutton, XmNsensitive, FALSE, NULL);
    XtVaSetValues (magbutton1, XmNsensitive, FALSE, NULL);
    XtVaSetValues (magbutton2, XmNsensitive, FALSE, NULL);
    XtVaSetValues (magbutton3, XmNsensitive, FALSE, NULL);
    XtVaSetValues (magbutton4, XmNsensitive, FALSE, NULL);
    XtVaSetValues (magbutton5, XmNsensitive, FALSE, NULL);
    XtVaSetValues (magbutton6, XmNsensitive, FALSE, NULL);
    XtVaSetValues (threshbutton, XmNsensitive, FALSE, NULL);
    XtVaSetValues (resetbutton, XmNsensitive, FALSE, NULL);
    XtVaSetValues (gammascale, XmNsensitive, FALSE, NULL);
    XtVaSetValues (threshscale, XmNsensitive, FALSE, NULL);
    XtVaSetValues (savebutton, XmNsensitive, FALSE, NULL);

    popupstring = XmStringCreateSimple (
			"Enter name of image to save : ");

    XtSetArg (args[0], XmNselectionLabelString, popupstring);
    XtSetArg (args[1], XmNautoUnmanage, FALSE);
  
    popupdialog = XmCreatePromptDialog (savebutton, 
				        "save image", 
					args, 2);

    popupdialogexists=1;

    XmStringFree(popupstring);
 
    XtAddCallback (popupdialog, XmNokCallback, 
		   (XtCallbackProc) Write_Modified_Image2, NULL);

    XtAddCallback (popupdialog, XmNcancelCallback, 
		   (XtCallbackProc) Quit_Save, NULL);

    XtUnmanageChild ( XmSelectionBoxGetChild (popupdialog, 
					     XmDIALOG_HELP_BUTTON));

    XmProcessTraversal (popupdialog, XmTRAVERSE_CURRENT);

    XtManageChild (popupdialog); /* dialog widget not yet mapped */
    
    XtPopup(XtParent(popupdialog), XtGrabNone);
}

/*----------------------------------------------------------------------*/


void     SetImage2(item, value, event)
  Widget		 	item;
  caddr_t			value;
  XmToggleButtonCallbackStruct *event;
{
  IM_VALUE = XmToggleButtonGetState(item);

  Set_UVInt(0,0);

  DrawInto2(mapcanvas);

  if (IM_VALUE) {
     SplashImage(prev_image1, magnification, 0, (mapx_coord*4)*magnification, (mapy_coord*4)*magnification);
     SplashImage(prev_image1, 1, 1, (mapx_coord*4)*magnification, (mapy_coord*4)*magnification);
     set_mag_view(mapx_coord, mapy_coord, magnification, 1);
  }
  else {
     SplashImage(image1, magnification, 0, (mapx_coord*4)*magnification, (mapy_coord*4)*magnification);
     SplashImage(image1, 1, 1, (mapx_coord*4)*magnification, (mapy_coord*4)*magnification);
     set_mag_view(mapx_coord, mapy_coord, magnification, 1);
  }

  return;
}

void     SetMagnification2(item, value, tstate)
Widget	   	item;
int		value;
XmToggleButtonCallbackStruct	*tstate;
{
    if (magnification == value) {
        return;
    }
    else {
	magnification = value;
    }

     if (IM_VALUE) {
	        SplashImage(prev_image1, magnification, 0, 
		    (mapx_coord*4)*magnification, (mapy_coord*4)*magnification);
     }
     else {
	        SplashImage(image1, magnification, 0, 
		    (mapx_coord*4)*magnification, (mapy_coord*4)*magnification);
      }

      set_mag_view(mapx_coord, mapy_coord, magnification, 1);

    return;
}

/*----------------------------------------------------------------------*/


/* ARGSUSED */
void     GetFile3(item, label)
Widget   item;
char	 *label;
{
  Arg	        args[15];
  char    	*filename;
  Widget 	badfile_notice;

    XmToggleButtonSetState(imbutton1, FALSE, (Boolean) NULL);
    IM_VALUE=0;

    filename = XmTextFieldGetString(item);

    if (strcmp(filename, "\0")==0) {
        return_val = 0;
        return;
    }

    IMAGE1_SPLASH=1;
    COMPLEX_CONVERTED=0;

    filename = XmTextFieldGetString(item);
   
    if (image_check != NULL) {
        Free_Image(image_check);
        image_check = ( IMAGE * ) NULL;
    }

    image_check = (IMAGE *) Read_Image(filename);

    if (image_check == NULL) {
        if (badfile_notice_exists) {
            return_val = 0;
	    return;
        }

      	firstime=2;

	XtVaSetValues (imbutton1, XmNsensitive, FALSE, NULL);

        setimagedialog = XmStringCreateSimple(
			"Error : file not found or invalid");

        contstring = XmStringCreateSimple("CONTINUE");

        XtSetArg(args[0], XmNmessageString, setimagedialog);
        XtSetArg(args[1], XmNdialogStyle, XmDIALOG_SYSTEM_MODAL);

        badfile_notice = XmCreateMessageDialog (imfilename_panel, 
					        "input error", 
					        args, 2 );

        badfile_notice_exists=1;

        XtVaSetValues (badfile_notice, XmNokLabelString, contstring, NULL);

        XtAddCallback (badfile_notice, XmNokCallback, 
		       (XtCallbackProc) badfile_cont, (XtPointer) 1);

        XmStringFree(setimagedialog);
        XmStringFree(contstring);

        XtUnmanageChild (XmMessageBoxGetChild (badfile_notice, 
					     XmDIALOG_CANCEL_BUTTON));
  
        XtUnmanageChild (XmMessageBoxGetChild (badfile_notice, 
					     XmDIALOG_HELP_BUTTON));

        XtManageChild(badfile_notice);

            return_val = 0;
            return;
    }
    else {
   
    if (image_check != NULL) {
        Free_Image(image_check);
        image_check = ( IMAGE * ) NULL;
    }

    if (prev_image1 != NULL) {
        Free_Image(prev_image1);
        prev_image1 = ( IMAGE * ) NULL;
    }

    if (prev_image2 != NULL) {
        Free_Image(prev_image2);
        prev_image2 = ( IMAGE * ) NULL;
    }

    if (image1 != NULL) {
        CopyBytetypeImage(image1);
        XtSetArg (args[0], XmNsensitive, TRUE);
        XtSetValues (imbutton1, args, 1);
    }
    else {
        XtSetArg (args[0], XmNsensitive, FALSE);
        XtSetValues (imbutton1, args, 1);
    }

    filename = XmTextFieldGetString(item);
   
    if (image1 != NULL) {
        Free_Image(image1);
        image1 = ( IMAGE * ) NULL;
    }
    
    if (image2 != NULL) {
        Free_Image(image2);
        image2 = ( IMAGE * ) NULL;
    }

    image1 = ( IMAGE * ) Read_Image(filename);

    if(image1 == NULL) {
      	firstime=2;

	XtVaSetValues (toolbutton, XmNsensitive, FALSE, NULL);

	XtVaSetValues (imbutton1, XmNsensitive, FALSE, NULL);

        setimagedialog = XmStringCreateSimple(
			 "Error : file not found or invalid");

        contstring = XmStringCreateSimple("CONTINUE");

        XtSetArg(args[0], XmNmessageString, setimagedialog);

        badfile_notice = XmCreateMessageDialog (imbutton1, 
					        "input error", 
					        args, 1 );

        XtVaSetValues (badfile_notice, XmNokLabelString, contstring, NULL);

        XtAddCallback (badfile_notice, XmNokCallback, 
		       (XtCallbackProc) badfile_cont, (XtPointer) 1);

        XmStringFree(setimagedialog);
        XmStringFree(contstring);

        XtUnmanageChild (XmMessageBoxGetChild (badfile_notice, 
					     XmDIALOG_CANCEL_BUTTON));
  
        XtUnmanageChild (XmMessageBoxGetChild (badfile_notice, 
					     XmDIALOG_HELP_BUTTON));

        XtManageChild(badfile_notice);

        if (return_val) {
          return_val = 0;
          Free_Image(image1);
	  Free_Image(image2);
          return;
        }
    }

    if (image1->type != COMPLEXTYPE) {
        COMPLEX_IMAGE=0;
        image2 = ( IMAGE * ) NULL;
    }

    if (image1->type == FLOATTYPE) {
        image1 = ( IMAGE * ) Float2Byte_Image(image1);
    }

    if (image1->type == COMPLEXTYPE) {
            XtVaSetValues (imfilename_panel, XmNsensitive, FALSE, NULL);
            XtVaSetValues (imbutton1, XmNsensitive, FALSE, NULL);
            XtVaSetValues (toolbutton, XmNsensitive, FALSE, NULL);

            IMAGE1_SPLASH=0;
    	    firstime=2;
            setimagedialog = XmStringCreateSimple("Complex type image selected : indicate required byte type image");

            XtSetArg(args[0], XmNmessageString, setimagedialog);

            conv_notice = XmCreateMessageDialog (controlform, 
					            "complex image",
						     args, 1 ); 

            contstring = XmStringCreateSimple("MAGNITUDE");

            XtVaSetValues (conv_notice, XmNhelpLabelString, contstring, NULL);

            contstring = XmStringCreateSimple("PHASE");

            XtUnmanageChild (XmMessageBoxGetChild (conv_notice, 
					     XmDIALOG_OK_BUTTON));

            XtVaSetValues (conv_notice, XmNcancelLabelString, contstring, NULL);

            XtAddCallback (conv_notice, XmNhelpCallback, (XtCallbackProc) set_useropt_choice_and_continue2, 
			   (caddr_t) 1);
            XtAddCallback (conv_notice, XmNcancelCallback, (XtCallbackProc) set_useropt_choice_and_continue2, 
			   (caddr_t) 2);

            XmStringFree(setimagedialog);
            XmStringFree(contstring);

            XtManageChild(conv_notice);
    }

    if (image1) {
        if (IMAGE1_SPLASH) {

	    SplashImage(image1, magnification, 0, 0, 0);
	    if (initial_image) {
                SplashImage(image1, 1, 2, (mapx_coord*4)*magnification, (mapy_coord*4)*magnification);
	    }
    	    set_mag_view(mapx_coord, mapy_coord, magnification, 1);

	    XtVaSetValues (toolbutton, XmNsensitive, TRUE, NULL);

	    XtVaSetValues (imbutton1, XmNsensitive, TRUE, NULL);

            if (NO_INITIAL_IMAGE_ARG) {
                PREVIOUS_IMAGE=0;
                NO_INITIAL_IMAGE_ARG--;
            }
	    else {
                PREVIOUS_IMAGE=1;
            }

            firstime=2;
        }
        else {
	    XtVaSetValues (imbutton1, XmNsensitive, TRUE, NULL);
        }
    }
    } /* end of else!!! */
}

/*--------------------------------------------------------------*/

int      Bounded(v, min, max)
int      v, min, max;

{
    if (v < min)
	return (min);
    else if (v > max)
	return (max);
    else
	return (v);
}


/*--------------------------------------------------*/

void Set_UVInt(x, y)
int      x, y;

{
    char     ustring[30];
    char     vstring[30];
    char     intstring[30];
    char     rstring[30];
    char     cstring[30];
    int      u, v;

    DrawInto2(intcanvas);

    XSetFunction(display, gc, GXcopy);
    XSetBackground(display, gc, colour_table[WHITE]);
    XSetForeground(display, gc, colour_table[WHITE]);
    XFillRectangle(display, win, gc, 0, 0, 165, 45);
    XSetForeground(display, gc, colour_table[BLACK]);

    u = x / magnification;
    v = y / magnification;

    if (!IM_VALUE) {
    if (image1) {
	if (( v+(mapy_coord*4) < image1->rows ) && ( u+(mapx_coord*4) < image1->cols)) {
	    if (( v == 0 ) && ( u == 0)) {
                (void) sprintf(ustring, "%s", "                     ");
                (void) sprintf(vstring, "%s", "                     ");
                (void) sprintf(intstring, "%s", "                     ");
                (void) sprintf(rstring, "%s", "                     ");
                (void) sprintf(cstring, "%s", "                     ");
	    }
	    else {
	        (void) sprintf(ustring, "%3d", u+(mapx_coord*4));
	        (void) sprintf(vstring, "%3d", v+(mapy_coord*4));
		(void) sprintf(intstring, "%3d", LUT[image1->i.c[v+(mapy_coord*4)][u+(mapx_coord*4)]]);
	        (void) sprintf(rstring, "%4d", image1->rows);
	        (void) sprintf(cstring, "%4d", image1->cols);

            }
        }
	else {
            (void) sprintf(ustring, "%s", "                     ");
            (void) sprintf(vstring, "%s", "                     ");
            (void) sprintf(intstring, "%s", "                     ");
            (void) sprintf(rstring, "%s", "                     ");
            (void) sprintf(cstring, "%s", "                     ");
	}
    }
    else {
        (void) sprintf(ustring, "%s", "                     ");
        (void) sprintf(vstring, "%s", "                     ");
        (void) sprintf(intstring, "%s", "                     ");
        (void) sprintf(rstring, "%s", "                     ");
        (void) sprintf(cstring, "%s", "                     ");
    }
    }

    if (IM_VALUE) {
    if (prev_image1) {
	if (( v+(mapy_coord*4) < prev_image1->rows ) && ( u+(mapx_coord*4) < prev_image1->cols)) {
	    if (( v == 0 ) && ( u == 0)) {
                (void) sprintf(ustring, "%s", "                     ");
                (void) sprintf(vstring, "%s", "                     ");
                (void) sprintf(intstring, "%s", "                     ");
                (void) sprintf(rstring, "%s", "                     ");
                (void) sprintf(cstring, "%s", "                     ");
	    }
	    else {
	        (void) sprintf(ustring, "%3d", u+(mapx_coord*4));
	        (void) sprintf(vstring, "%3d", v+(mapy_coord*4));
		(void) sprintf(intstring, "%3d", LUT[prev_image1->i.c[v+(mapy_coord*4)][u+(mapx_coord*4)]]);
	        (void) sprintf(rstring, "%4d", prev_image1->rows);
	        (void) sprintf(cstring, "%4d", prev_image1->cols);

            }
        }
	else {
            (void) sprintf(ustring, "%s", "                     ");
            (void) sprintf(vstring, "%s", "                     ");
            (void) sprintf(intstring, "%s", "                     ");
            (void) sprintf(rstring, "%s", "                     ");
            (void) sprintf(cstring, "%s", "                     ");
	}
    }
    else {
        (void) sprintf(ustring, "%s", "                     ");
        (void) sprintf(vstring, "%s", "                     ");
        (void) sprintf(intstring, "%s", "                     ");
        (void) sprintf(rstring, "%s", "                     ");
        (void) sprintf(cstring, "%s", "                     ");
    }
    }

    DrawInto2(intcanvas);
    XDrawString(display, win, gc, 7, 12,  "  i", 3);
    XDrawString(display, win, gc, 10, 32, intstring, strlen(intstring));
    XDrawString(display, win, gc, 37, 12, "  u", 3);
    XDrawString(display, win, gc, 40, 32, ustring, strlen(ustring));
    XDrawString(display, win, gc, 67, 12, "  v", 3);
    XDrawString(display, win, gc, 70, 32, vstring, strlen(vstring));
    XDrawString(display, win, gc, 97, 12, "  c", 3);
    XDrawString(display, win, gc, 97, 32, cstring, strlen(cstring));
    XDrawString(display, win, gc, 127, 12, "  r", 3);
    XDrawString(display, win, gc, 127, 32, rstring, strlen(rstring));

    return;
}


/*- PlotSlice --------------------------------------------------*/

int      PlotSlice(x0, py0, x1, py1)
int      x0, py0, x1, py1;
{
    int      i, u, v, du, dv, Npixels;
    double  *slice, *LUTslice;
    double   uscale, vscale;

    if (!image1)
	return (0);		/* no image - no slice */

    (void) SaveRetrieveSlicePts(1, &x0, &py0, &x1, &py1);

/* save where the slice came from */

    x0 /= magnification;
    x1 /= magnification;
    py0 /= magnification;
    py1 /= magnification;

    du = x1 - x0;
    dv = py1 - py0;

    if (abs(du) > abs(dv))	/* line being scanned is more horizontal */
	Npixels = abs(du);
    else			/* line is more vertical */
	Npixels = abs(dv);

    if (Npixels == 0)
	Npixels = 1;

    slice = (double *) malloc(Npixels * sizeof(double));	/* allocate buffer */
    LUTslice = (double *) malloc(Npixels * sizeof(double));	/* allocate buffer */

    /* Copy pixels in image into buffer */

    uscale = (double) du / (double) Npixels;
    vscale = (double) dv / (double) Npixels;

    for (i = 0; i < Npixels; i++) {
	u = x0 + (double) i *uscale;
	v = py0 + (double) i *vscale;

        if (IM_VALUE) {
                if (u+(mapx_coord*4)>=prev_image1->cols | v+(mapy_coord*4)>=prev_image1->rows) { 
	            slice[i] = (double) 0;
	            LUTslice[i] = (double) 0;
	        }
	        else {
	            slice[i] = (double) prev_image1->i.c[v+(mapy_coord*4)][u+(mapx_coord*4)];
	            LUTslice[i] = (double) LUT[prev_image1->i.c[v+(mapy_coord*4)][u+(mapx_coord*4)]];
	        }
	}
	else {
            if (u+(mapx_coord*4)>=image1->cols | v+(mapy_coord*4)>=image1->rows) { 
	        slice[i] = (double) 0;
	        LUTslice[i] = (double) 0;
	    }
	    else {
	        slice[i] = (double) image1->i.c[v+(mapy_coord*4)][u+(mapx_coord*4)];
	        LUTslice[i] = (double) LUT[image1->i.c[v+(mapy_coord*4)][u+(mapx_coord*4)]];
	    }
	}
    }

    DrawInto2(slicecanvas);
    XSetFunction(display, gc, GXcopy);
    XSetBackground(display, gc, colour_table[WHITE]);
    XFillRectangle(display, win, gc, 0, 0, 512, 256);	/* clear previous text */
    XSetForeground(display, gc, colour_table[BLACK]);

    Graph(slice, Npixels, 0.0, (double) Npixels, 50.0, 0.0, 255.0, 50.0, "Raw Slice Plot");

    DrawInto2(LUTslicecanvas);
    XSetFunction(display, gc, GXcopy);
    XSetBackground(display, gc, colour_table[WHITE]);
    XFillRectangle(display, win, gc, 0, 0, 512, 256);	/* clear previous text */
    XSetForeground(display, gc, colour_table[BLACK]);

    Graph(LUTslice, Npixels, 0.0, (double) Npixels, 50.0, 0.0, 255.0, 50.0, 
			"Slice values through look up table");

    free(( char * ) slice);
    free(( char * ) LUTslice);

    return (0);
}


/*- SaveRetrieveSlicePts ------------------------------------------------------

Function to store or retrieve the end points of the slice line
If flag is TRUE data is saved
IF flag is FALSE data is stored

-------------------------------------------------------------------------------*/

int      SaveRetrieveSlicePts(flag, x0, ry0, x1, ry1)
int      flag, *x0, *ry0, *x1, *ry1;
{
    static int sx0, sy0, sx1, sy1;

    if (flag) {			/* save */
	sx0 = *x0;
	sy0 = *ry0;
	sx1 = *x1;
	sy1 = *ry1;
    } else {			/* retrieve */
	*x0 = sx0;
	*ry0 = sy0;
	*x1 = sx1;
	*ry1 = sy1;
    }

    return (0);
}

/*- testxyz2uv2 --------------------------------------------------------*/

/* ARGSUSED */
int      testxyz2uv2(item)
Widget item;
{
    int      uv[2];
    double   v[3];
    char    *params;

    XtVaGetValues (item, XmNvalue, &params, NULL);
   
    (void) sscanf(params, "%lf %lf %lf", &v[0], &v[1], &v[2]);
    xyz2uv(&image1->camera, uv, v);
    
    uv[0] *= magnification;
    uv[1] *= magnification;

    DrawInto2(imagecanvas);
    XSetForeground(display, gc, colour_table[RED]);
    XSetFunction(display, gc, GXcopy);

    XDrawLine(display, win, gc, uv[0] - 22, 
				uv[1] - 2, 
				uv[0] + 18,
			 	uv[1] - 2 );

    XDrawLine(display, win, gc, uv[0] - 2, 
			        uv[1] - 22, 
				uv[0] - 2,
				uv[1] + 18);

        if (image1->camera.calib_status == 0 ) {
            (void) sprintf (spl_str, "Warning: uncalibrated image\n");
            splash_error2(spl_str, toolsframe);
        }
    
    return (1);
}


void     setgamma2(item, value, event)
  Widget item;
  int    value;
  XmScaleCallbackStruct *event;
{
    int      ipower;
    int      x0, gmy0, x1, gmy1;
    int val=0;
    XmScaleCallbackStruct *xmscalecallbackstruct = (XmScaleCallbackStruct *) NULL;

    if (event->reason != XmCR_DRAG) {

        if (XmToggleButtonGetState(threshbutton)) {
	    XmScaleGetValue(gammascale, &val);
    	    ipower = val; 
            power = (double) ipower / 100.0;
            Set_Look_Up_Table(LUT, power);

            xmscalecallbackstruct = (XmScaleCallbackStruct *) malloc (1 * sizeof(XmScaleCallbackStruct));
	    XmScaleGetValue(threshscale, &val);
            xmscalecallbackstruct->reason = 999;
					 /* arbitrary no != xmCR_DRAG! */
            xmscalecallbackstruct->value = val; 
	    (void) setthresh2(threshscale, (int) NULL, xmscalecallbackstruct);
	}
	else {
            ipower = event->value;

            power = (double) ipower / 100.0;

            Set_Look_Up_Table(LUT, power);

            if (IM_VALUE) {
                SplashImage(prev_image1, magnification, 0, 
	        	      (mapx_coord*4)*magnification, 
	        	      (mapy_coord*4)*magnification);
            }
            else {
                SplashImage(image1, magnification, 0,
                              (mapx_coord*4)*magnification, 
	  	              (mapy_coord*4)*magnification);
            }

            set_mag_view(mapx_coord, mapy_coord, magnification, 1);
        
            (void) SaveRetrieveSlicePts(0, &x0, &gmy0, &x1, &gmy1);	

            /* retrieve where the slice came from */

            (void) DrawSliceLine(x0, gmy0, x1, gmy1);
            (void) PlotSlice(x0, gmy0, x1, gmy1);
	}
    }


    return;
}

void     setthreshbutton(item, value, event)
  Widget		 	item;
  caddr_t			value;
  XmToggleButtonCallbackStruct *event;
{
  int val=0;
  XmScaleCallbackStruct *xmscalecallbackstruct = (XmScaleCallbackStruct *) NULL;

  xmscalecallbackstruct = (XmScaleCallbackStruct *) malloc (1 * sizeof(XmScaleCallbackStruct));

    xmscalecallbackstruct->reason = 999; /* an arbitrary number (as long as it
					    doesn't equal XmCR_DRAG event!) 
				   	 */

    if (XmToggleButtonGetState(item)) {
        XtVaSetValues (threshscale, XmNsensitive, TRUE, NULL);
	XmScaleGetValue(threshscale, &val);
        xmscalecallbackstruct->value = val; 
	(void) setthresh2(threshscale, (int) NULL, xmscalecallbackstruct);
    }
    else {
        XtVaSetValues (threshscale, XmNsensitive, FALSE, NULL);
	XmScaleGetValue(gammascale, &val);
        xmscalecallbackstruct->value = val; 
	(void) setgamma2(gammascale, (int) NULL, xmscalecallbackstruct);
    }

    return;
}

void     resetgamma(item, value, event)
  Widget		 	item;
  caddr_t			value;
  XmToggleButtonCallbackStruct *event;
{
    int      ipower;
    double   power;
    int      x0, gmy0, x1, gmy1;
    int val=0;
    XmScaleCallbackStruct *xmscalecallbackstruct = (XmScaleCallbackStruct *) NULL;

    ipower = 100;
    power = (double) ipower / 100.0;

    if (XmToggleButtonGetState(threshbutton)) {
        xmscalecallbackstruct = (XmScaleCallbackStruct *) malloc (1 * sizeof(XmScaleCallbackStruct));
        XmToggleButtonSetState(resetbutton, FALSE, (Boolean) NULL);
        XmScaleSetValue(gammascale, 100);

	XmScaleGetValue(threshscale, &val);
        xmscalecallbackstruct->value = val; 
	(void) setthresh2(threshscale, (int) NULL, xmscalecallbackstruct);
    }
    else {
        XmToggleButtonSetState(resetbutton, FALSE, (Boolean) NULL);
        XmScaleSetValue(gammascale, 100);

        Set_Look_Up_Table(LUT, power);

        if (IM_VALUE) {
            SplashImage(prev_image1, magnification, 0, 
		      (mapx_coord*4)*magnification, 
		      (mapy_coord*4)*magnification);
        }
        else {
            SplashImage(image1, magnification, 0,
                      (mapx_coord*4)*magnification, 
		      (mapy_coord*4)*magnification);
        }

        set_mag_view(mapx_coord, mapy_coord, magnification, 1);
        
        (void) SaveRetrieveSlicePts(0, &x0, &gmy0, &x1, &gmy1);	

        /* retrieve where the slice came from */

        (void) DrawSliceLine(x0, gmy0, x1, gmy1);
        (void) PlotSlice(x0, gmy0, x1, gmy1);
    }

    return;
}


void     setthresh2(item, value, event)
  Widget item;
  int    value;
  XmScaleCallbackStruct *event;
{
    int      i, x0, gmy0, x1, gmy1;
  
    if (event->reason != XmCR_DRAG) {
	Set_Look_Up_Table(LUT, power);

        for (i = 0; i < 256; i++) {
            if (LUT[i] >= (event->value)) {
                LUT[i] = WHITE;
	    }
	    else {
                LUT[i] = BLACK;
	    }
        }

        if (IM_VALUE) {
            SplashImage(prev_image1, magnification, 0, 
		        (mapx_coord*4)*magnification, 
		        (mapy_coord*4)*magnification);
        }
        else {
                SplashImage(image1, magnification, 0,
                      (mapx_coord*4)*magnification, 
	      	      (mapy_coord*4)*magnification);
        }
  
        set_mag_view(mapx_coord, mapy_coord, magnification, 1);
        
        (void) SaveRetrieveSlicePts(0, &x0, &gmy0, &x1, &gmy1);	

        /* retrieve where the slice came from */

        (void) DrawSliceLine(x0, gmy0, x1, gmy1);
        (void) PlotSlice(x0, gmy0, x1, gmy1);

    }

          return;
}


/*-----------------------------------------------------------*/

void Quit_Save(item, value, event)
  Widget item;
  int	 value;
  XmSelectionBoxCallbackStruct *event;
{
    XtDestroyWidget(popupdialog);

    XtVaSetValues (imfilename_panel, XmNsensitive, TRUE, NULL);
    XtVaSetValues (toolbutton, XmNsensitive, TRUE, NULL);
    XtVaSetValues (magbutton1, XmNsensitive, TRUE, NULL);
    XtVaSetValues (magbutton2, XmNsensitive, TRUE, NULL);
    XtVaSetValues (magbutton3, XmNsensitive, TRUE, NULL);
    XtVaSetValues (magbutton4, XmNsensitive, TRUE, NULL);
    XtVaSetValues (magbutton5, XmNsensitive, TRUE, NULL);
    XtVaSetValues (magbutton6, XmNsensitive, TRUE, NULL);
    XtVaSetValues (threshbutton, XmNsensitive, TRUE, NULL);
    XtVaSetValues (resetbutton, XmNsensitive, TRUE, NULL);
    XtVaSetValues (gammascale, XmNsensitive, TRUE, NULL);
    XtVaSetValues (threshscale, XmNsensitive, TRUE, NULL);
    XtVaSetValues (savebutton, XmNsensitive, TRUE, NULL);
}


void Write_Modified_Image2(item, value, cbs)
  Widget item;
  int    value;
  XmSelectionBoxCallbackStruct *cbs;
{
  IMAGE *tmpimage;
  int i,j;
  char    *filename;

  XmStringGetLtoR (cbs->value, XmSTRING_DEFAULT_CHARSET, &filename);

  if (strcmp(filename,"")==0) {
      (void) strcpy (spl_str,
		 "Error : target filename not specified\n please try again");
      splash_error2 (spl_str, popupdialog);
      XtFree(filename);
      return;
  }

  if (image1) {
      tmpimage = ( IMAGE * ) Allocate_Image(0, 0,
			     		    (int) image1->rows, 
					    (int) image1->cols,
					    BYTETYPE);
  }
  else {
      (void) strcpy (spl_str,
	 "Error : source image not specified\n please try again");
      splash_error2 (spl_str, topLevel);
      XtFree(filename);
      return;
  }

  for(i = 0; i < image1->rows; i++)
      for(j = 0; j < image1->cols; j++)
          tmpimage->i.c[i][j] = LUT[image1->i.c[i][j]];

  Write_Image(tmpimage,filename);
  Free_Image(tmpimage);
  XtFree(filename);

  XtDestroyWidget(popupdialog);

    XtVaSetValues (imfilename_panel, XmNsensitive, TRUE, NULL);
    XtVaSetValues (toolbutton, XmNsensitive, TRUE, NULL);
    XtVaSetValues (magbutton1, XmNsensitive, TRUE, NULL);
    XtVaSetValues (magbutton2, XmNsensitive, TRUE, NULL);
    XtVaSetValues (magbutton3, XmNsensitive, TRUE, NULL);
    XtVaSetValues (magbutton4, XmNsensitive, TRUE, NULL);
    XtVaSetValues (magbutton5, XmNsensitive, TRUE, NULL);
    XtVaSetValues (magbutton6, XmNsensitive, TRUE, NULL);
    XtVaSetValues (threshbutton, XmNsensitive, TRUE, NULL);
    XtVaSetValues (resetbutton, XmNsensitive, TRUE, NULL);
    XtVaSetValues (gammascale, XmNsensitive, TRUE, NULL);
    XtVaSetValues (threshscale, XmNsensitive, TRUE, NULL);
    XtVaSetValues (savebutton, XmNsensitive, TRUE, NULL);

  return;
}

void     splash_error2(err_str, pframe)
  char	*err_str;
  Widget pframe;
{ 
  Arg	args[15];
  Widget	badfile_notice;

            setimagedialog = XmStringCreateSimple(err_str);

            contstring = XmStringCreateSimple("CONTINUE");

            XtSetArg(args[0], XmNmessageString, setimagedialog);

            badfile_notice = XmCreateMessageDialog (pframe, 
					            "input error", 
					            args, 1 );

            XtVaSetValues (badfile_notice, XmNokLabelString, contstring, NULL);

            XtAddCallback (badfile_notice, XmNokCallback, 
			   (XtCallbackProc) badfile_cont, 
			   (XtPointer) 1);

            XmStringFree(setimagedialog);
            XmStringFree(contstring);

            XtUnmanageChild (XmMessageBoxGetChild (badfile_notice, 
					     XmDIALOG_CANCEL_BUTTON));
  
            XtUnmanageChild (XmMessageBoxGetChild (badfile_notice, 
					     XmDIALOG_HELP_BUTTON));

            XtManageChild(badfile_notice);

            if (return_val) {
	        (void) strcpy(err_str,"\0");
                return_val = 0;
            }
}

void set_mag_view(orig_x, orig_y, mag_factor, event_flag)
  int orig_x, orig_y, mag_factor, event_flag;
{
  Arg	args[15];
  int	    imcanvaswidth;
  int	    imcanvasheight;
  static int old_orig_x=0, old_orig_y=0, old_width=0, old_height=0;

     DrawInto2(mapcanvas);

     if (IM_VALUE) {
        SplashImage(prev_image1, 1, 1, (mapx_coord*4)*magnification, (mapy_coord*4)*magnification);
     }
     else {
        SplashImage(image1, 1, 1, (mapx_coord*4)*magnification, (mapy_coord*4)*magnification);
     }

        XSetFunction(display, gc, GXcopy);
        XSetForeground(display, gc, colour_table[BLACK]);
	
	XtSetArg (args[0], XmNwidth, &imcanvaswidth);
    	XtGetValues(imagecanvas, args, 1);
    	XtSetArg (args[0], XmNheight, &imcanvasheight);
    	XtGetValues(imagecanvas, args, 1);

        XSetForeground(display, gc, colour_table[RED]);

        if (event_flag) {

     if (IM_VALUE) {
        SplashImage(prev_image1, 1, 1, (mapx_coord*4)*magnification, (mapy_coord*4)*magnification);
     }
     else {
        SplashImage(image1, 1, 1, (mapx_coord*4)*magnification, (mapy_coord*4)*magnification);
     }

                XDrawRectangle(display, win, gc, old_orig_x+1, old_orig_y,
	            ((magimagecols/4)/mag_factor)-2,
	            ((magimagerows/4)/mag_factor)-1);

                XDrawRectangle(display, win, gc, old_orig_x+2, old_orig_y+1,
	            ((magimagecols/4)/mag_factor)-4,
	            ((magimagerows/4)/mag_factor)-3);
	    }
	    else {

            XSetFunction(display, gc, GXcopy);
            XSetForeground(display, gc, colour_table[RED]);

    		XtSetArg (args[0], XmNwidth, &imcanvaswidth);
    		XtGetValues(imagecanvas, args, 1);
    		XtSetArg (args[0], XmNheight, &imcanvasheight);
    		XtGetValues(imagecanvas, args, 1);

            XDrawRectangle(display, win, gc, orig_x+1, orig_y,
	            ((magimagecols/4)/mag_factor)-2,
	            ((magimagerows/4)/mag_factor)-1);

            XDrawRectangle(display, win, gc, orig_x+2, orig_y+1,
	        ((magimagecols/4)/mag_factor)-4,
	        ((magimagerows/4)/mag_factor)-3);
	    }

    		XtSetArg (args[0], XmNwidth, &imcanvaswidth);
    		XtGetValues(imagecanvas, args, 1);
    		XtSetArg (args[0], XmNheight, &imcanvasheight);
    		XtGetValues(imagecanvas, args, 1);

	old_orig_x = orig_x;
	old_orig_y = orig_y;
 	old_width = (imcanvaswidth/4)/mag_factor;
 	old_height = (imcanvasheight/4)/mag_factor;
}



/* Called when there is an event in the map canvas ... */

void 	map_event_proc2(window, client_data, event)	
  Widget        window;
  XtPointer     client_data;
  XEvent       *event;
{

    if (COMPLEX_IMAGE && !COMPLEX_CONVERTED) {
	return;
    }

    if (event->type == ButtonPress) {
        if (event->xbutton.button == 1) {
            DrawInto2(mapcanvas);
	}

            set_mag_view(mapx_coord, mapy_coord, magnification, 1);
    }

    if (event->type == ButtonRelease) {
        if (event->xbutton.button == 1) {
            mapx_coord = event->xbutton.x;
            mapy_coord = event->xbutton.y;

	    if (mapx_coord<0) 
	        mapx_coord = 0;

	    if (mapx_coord+(((tempcols)/4)/magnification)>=(((tempcols)/4)))
	        mapx_coord=((tempcols)/4)-(((tempcols)/4)/magnification);

	    if (mapy_coord<0) 
	        mapy_coord = 0;

	    if (mapy_coord+((temprows/4)/magnification)>=(temprows/4))
	        mapy_coord=((temprows)/4)-(((temprows)/4)/magnification);

            DrawInto2(imagecanvas);

	    XClearWindow(display, win);

            if (IM_VALUE) {
                SplashImage(prev_image1, magnification, 0, (mapx_coord*4)*magnification, (mapy_coord*4)*magnification);
	    }
	    else {
                SplashImage(image1, magnification, 0, (mapx_coord*4)*magnification, (mapy_coord*4)*magnification);
	    }

            DrawInto2(mapcanvas);

	    XClearWindow(display, win);

            if (IM_VALUE) {
                SplashImage(prev_image1, 1, 1, (mapx_coord*4)*magnification, (mapy_coord*4)*magnification);
	    }
	    else {
                SplashImage(image1, 1, 1, (mapx_coord*4)*magnification, (mapy_coord*4)*magnification);
	    }

            set_mag_view(mapx_coord, mapy_coord, magnification, 1);

        }   
    }

    if (event->type == MotionNotify) {
        mapx_coord = event->xbutton.x;
        mapy_coord = event->xbutton.y;

        if (mapx_coord<0)
            mapx_coord = 0;

        if (mapx_coord+(((tempcols)/4)/magnification)>=(((tempcols)/4)))
         mapx_coord=((tempcols)/4)-(((tempcols)/4)/magnification);

        if (mapy_coord<0)
            mapy_coord = 0;

        if (mapy_coord+((temprows/4)/magnification)>=(temprows/4))
         mapy_coord=((temprows)/4)-(((temprows)/4)/magnification);

        set_mag_view(mapx_coord, mapy_coord, magnification, 1);
    }

        if (event->type == 12) {
	            if (!NO_INITIAL_IMAGE_ARG) {
                        DrawInto2(mapcanvas);

                        XPutImage(display, win, gc, xmapimage,
                                0,
                                0,
                                0, 0,
		 		magimagecols/4, magimagerows/4);
    		    
		        set_mag_view(mapx_coord, mapy_coord, magnification, 1);
	 	    }
        }
}

void	initial_splash2()
{
  Arg		args[15];

  /* disable timer while button is being setup */

    if (firstime<2) {

    if (ARGVIMAGE[0]) {

        image1 = ( IMAGE * ) Read_Image(ARGVIMAGE);

	if (image1 == NULL) {
            if (return_val) {
                return_val = 0;
	        XWarpPointer(XtDisplay (controlform), 
			     None,
			     XtWindow (controlform),
			     0, 0, 0, 0, 165, 65);
                return;
            }
	}

	if (image1->type == FLOATTYPE) {
            image1 = ( IMAGE * ) Float2Byte_Image(image1);
        }

        if (image1->type == COMPLEXTYPE) {

            XtVaSetValues (imfilename_panel, XmNsensitive, FALSE, NULL);
            XtVaSetValues (imbutton1, XmNsensitive, FALSE, NULL);
            XtVaSetValues (toolbutton, XmNsensitive, FALSE, NULL);

            IMAGE1_SPLASH=0;

    	    firstime=2;

            setimagedialog = XmStringCreateSimple("Complex type image selected : indicate required byte type image");

            XtSetArg(args[0], XmNmessageString, setimagedialog);

            conv_notice = XmCreateMessageDialog (controlform, 
					            "complex image",
						     args, 1 ); 

            contstring = XmStringCreateSimple("MAGNITUDE");

            XtVaSetValues (conv_notice, XmNhelpLabelString, contstring, NULL);

            contstring = XmStringCreateSimple("PHASE");

            XtVaSetValues (conv_notice, XmNcancelLabelString, contstring, NULL);

            XtUnmanageChild (XmMessageBoxGetChild (conv_notice, 
					     XmDIALOG_OK_BUTTON));

            XtAddCallback (conv_notice, XmNokCallback, (XtCallbackProc) initial_useropt_quit2, NULL);
            XtAddCallback (conv_notice, XmNhelpCallback, (XtCallbackProc) set_useropt_choice_and_continue2, (caddr_t) 1);
            XtAddCallback (conv_notice, XmNcancelCallback, (XtCallbackProc) set_useropt_choice_and_continue2, (caddr_t) 2);

            XmStringFree(setimagedialog);
            XmStringFree(contstring);

            XtManageChild(conv_notice);
        }

	if (image1) {
          if (IMAGE1_SPLASH) {
	    SplashImage(image1, magnification, 0, 0, 0);
            XtVaSetValues (toolbutton, XmNsensitive, TRUE, NULL);
            XtVaSetValues (imbutton1, XmNsensitive, FALSE, NULL);
            SplashImage(image1, 1, 1, (mapx_coord*4)*magnification, (mapy_coord*4)*magnification);
	  }
	  else {
            XtVaSetValues (imbutton1, XmNsensitive, FALSE, NULL);
	  }
        }

	(void) strcpy(ARGVIMAGE, "\0");
    }
  }
}


void set_useropt_choice_and_continue2(w, client_data, cbs)
  Widget		w;
  caddr_t		client_data;
  XmToggleButtonCallbackStruct	*cbs;
{
  useropt_chbox_choice = (long) client_data;

  COMPLEX_IMAGE=1;
  IMAGE1_SPLASH=1;

  if (useropt_chbox_choice==1) {
      if ( !COMPLEX_CONVERTED) {
          image1 = ( IMAGE * )Complex2Float_Image(image1); /* mag from complex */
          image1 = ( IMAGE * )Float2Byte_Image(image1);
          COMPLEX_CONVERTED=1;
      }

      SplashImage(image1, magnification, 0, 0, 0);
      SplashImage(image1, 1, 1, (mapx_coord*4)*magnification, (mapy_coord*4)*magnification);
  }
  else {
      if ( !COMPLEX_CONVERTED) {
         image1 = ( IMAGE * )Complex2PhaseFloat_Image(image1); 
         image1 = ( IMAGE * )Float2Byte_Image(image1);
         COMPLEX_CONVERTED=1;
      }

      SplashImage(image1, magnification, 0, 0, 0);
      SplashImage(image1, 1, 1, (mapx_coord*4)*magnification, (mapy_coord*4)*magnification);
  }

  firstime=2;
  set_mag_view(0, 0, magnification, 0);
  XtDestroyWidget(w);

  XtVaSetValues (imbutton1, XmNsensitive, TRUE, NULL);
  XtVaSetValues (toolbutton, XmNsensitive, TRUE, NULL);
  XtVaSetValues (imfilename_panel, XmNsensitive, TRUE, NULL);
  XtVaSetValues (imfilename_panel, XmNhighlightOnEnter, TRUE, NULL);
}

void CopyBytetypeImages(im1, im2)
  IMAGE *im1;
  IMAGE *im2;
{
  int     i, j;

  
  if (im2 != NULL) {
      Free_Image(im2);
      im2 = ( IMAGE * ) NULL;
  }

  im2 = (IMAGE *) Allocate_Image(im1->umin, im1->vmin, im1->rows,
			       im1->cols, BYTETYPE);

  (void) Copy_Header(im1, im2);

  im2->type = BYTETYPE;

 for (i = 0; i < im1->rows; i++) {
     for (j = 0; j < im1->cols; j++) {
         im2->i.c[i][j] = im1->i.c[i][j];
     }
 }
}


void CopyBytetypeImage(im1)
  IMAGE *im1;
{
  int     i, j;

  prev_image1 = (IMAGE *) Allocate_Image(im1->umin, im1->vmin, im1->rows,
					 im1->cols, BYTETYPE);

  (void) Copy_Header(im1, prev_image1);

  prev_image1->type = BYTETYPE;

  for (i = 0; i < im1->rows; i++) {
     for (j = 0; j < im1->cols; j++) {
         prev_image1->i.c[i][j] = im1->i.c[i][j];
     }
  }

  Free_Image(image2);
  Free_Image(prev_image2);
  image2 = ( IMAGE * )NULL;
  prev_image2 = ( IMAGE * )NULL;
}

void     set_previous_useropt_choice_and_continue2(item, value, event)
  Widget item;
  int value;
  XmToggleButtonCallbackStruct   *event;
{
  previous_useropt_chbox_choice = (int) event->set;

  if (previous_useropt_chbox_choice) {
      if (prev_image1->type == COMPLEXTYPE) {
          prev_image1 = ( IMAGE * )Complex2PhaseFloat_Image(prev_image1); 
          prev_image1 = ( IMAGE * )Float2Byte_Image(prev_image1);
      }
      SplashImage(prev_image1, magnification, 0, 
      (mapx_coord*4)*magnification, (mapy_coord*4)*magnification);
      if (initial_image) {
          SplashImage(prev_image1, 1, 1, 
                      (mapx_coord*4)*magnification, (mapy_coord*4)*magnification);
      }
  }
  else {
      if (prev_image2->type == COMPLEXTYPE) {
          prev_image2 = ( IMAGE * )Complex2Float_Image(prev_image2); 
          /* mag from complex */
          prev_image2 = ( IMAGE * )Float2Byte_Image(prev_image2);
      }
      SplashImage(prev_image2, magnification, 0, 
                  (mapx_coord*4)*magnification, (mapy_coord*4)*magnification);
      if (initial_image) {
          SplashImage(prev_image2, 1, 1, 
	 	      (mapx_coord*4)*magnification, (mapy_coord*4)*magnification);
      }
  }

  if (previous_useroptframe) {
     XtDestroyWidget (previous_useroptframe);
     previous_useroptframe = ( Widget ) NULL;
  }

  XtVaSetValues (imbutton1, XmNsensitive, TRUE, NULL);

  XtVaSetValues (imfilename_panel, XmNsensitive, TRUE, NULL);
}


void     set_current_useropt_choice_and_continue2(item, value, event)
  Widget item;
  int value;
  XmToggleButtonCallbackStruct   *event;
{
  previous_useropt_chbox_choice = (int) event->set;

  if (previous_useropt_chbox_choice) {
      if ( prev_image1->type == COMPLEXTYPE) {
          prev_image1 = ( IMAGE * )Complex2PhaseFloat_Image(prev_image1); 
          prev_image1 = ( IMAGE * )Float2Byte_Image(prev_image1);
      }
      SplashImage(image1, magnification, 0, 
      (mapx_coord*4)*magnification, (mapy_coord*4)*magnification);
      if (initial_image) {
          SplashImage(prev_image1, 1, 1, 
                      (mapx_coord*4)*magnification, (mapy_coord*4)*magnification);
      }
  }
  else {
    if (prev_image2 != NULL) {
      if (prev_image2->type == COMPLEXTYPE) {
          prev_image2 = ( IMAGE * )Complex2Float_Image(prev_image2); /* mag from complex */
          prev_image2 = ( IMAGE * )Float2Byte_Image(prev_image2);
      }
      SplashImage(image2, magnification, 0, 
                  (mapx_coord*4)*magnification, (mapy_coord*4)*magnification);
      if (initial_image) {
          SplashImage(prev_image2, 1, 1, 
	 	      (mapx_coord*4)*magnification, (mapy_coord*4)*magnification);
      }
    }
  }

  if (previous_useroptframe) {
     XtDestroyWidget (previous_useroptframe);
     previous_useroptframe = ( Widget ) NULL;
  }

  XtVaSetValues (imbutton1, XmNsensitive, TRUE, NULL);

  XtVaSetValues (imfilename_panel, XmNsensitive, TRUE, NULL);
}

void badfile_cont(w, client_data, cbs)
  Widget	w;
  XtPointer	client_data;
  XmToggleButtonCallbackStruct	*cbs;
{
      if (cbs->set) {

	        XtDestroyWidget (w);

  		XtMapWidget(imbutton1);
	        return_val = 0;
                badfile_notice_exists=0;
      }
}
