/******************************************************************************
*
* University of Western Australia
* Department of Computer Science
* Copyright (c) University of Western Australia
*
* SYSTEM :              VIP
* RELEASE:		3
* SUBSYSTEM:		SPLASH            
* MODULE:		splash.c - Splash image displayer.
* REVISION:             3.4
* AUTHOR:               
* CREATION DATE:        
* REVISION DATE:	4/26/94        
*
********************************************************************************
*
* REVISION LOG
*
* REVISION:		3.4
* REVISION DATE:	26 April 1994
* COMMENT:		General maintenance
* BY:			PK
*
* REVISION:		3.3
* REVISION DATE:	05 June 1993
* COMMENT:		Enhancements -
*			     FLOAT and COMPLEX image handling.
* BY:			CFF
*
* REVISION:		3.2
* REVISION DATE:	08 Sept 1992
* COMMENT:		Added pan map and enhanced display etc.		
* BY:			CFF
*
* REVISION:		3.1
* REVISION DATE:	14 July 1992
* COMMENT:		ANSIfied and SCCS'd
* BY:			CFF
*
*******************************************************************************/

#ifndef lint
static char *sccs_id = "@(#)splash.c	3.4 4/26/94";
#endif


#include <stdio.h>
#include <stdlib.h>
#include <malloc.h>
#include <ctype.h>
#include <math.h>

#include <X11/Xlib.h>

#include <xview/xview.h>
#include <xview/svrimage.h>
#include <xview/frame.h>
#include <xview/panel.h>
#include <xview/canvas.h>
#include <xview/xv_xrect.h>
#include <xview/cms.h>
#include <xview/notice.h>
#include <xview/font.h>
#include <xview/notify.h>

#include "vip.h"
#include "graphics.h"
#include "splashfn.h"

/* ANSI fn. prototypes in splashfn.h - CFF */

/*
void     quit(), event_proc(), repaint(), Read(), GetFile();
void     SetMagnification();
void     RetrieveXImage(), splashImage(), ShowImage();
int      testuv2xyz(), testxyz2uv();
void     showtoolsframe(), hidetoolsframe();
void     setgamma();
void     Show_Popup_Frame(), Write_Modified_Image();
*/

/* timer structure used to trigger canvas_events() */

#define  TICKSPERSEC 10

static struct itimerval newvalue = {
   { 0, 1000000 / TICKSPERSEC },
   { 0, 1000000 / TICKSPERSEC }
   }, oldvalue;

/* GLOBALS  */

Cms      cms;		/* The Colour Map Segment. Used to initialize
	                   the color table. */
Frame    frame, toolsframe, popupframe, useroptframe, previous_useroptframe;

/* The frames. */

Canvas   mapcanvas, imagecanvas, ucanvas, vcanvas, intcanvas, xyzcanvas,
         slicecanvas, LUTslicecanvas, useroptcanvas, previous_useroptcanvas;

Panel    panel, useroptpanel, previous_useroptpanel; 
			/* The defn. of a panel, used for each different panel. */
Panel    imagenamep;		/* panel for collecting image name */
Panel_item	toolbutton;
Panel_item	magbutton;
Panel_item	imbutton1;	/* selects previous image(s) for display */
Panel_item	imbutton_message0; /* blank line */
Panel_item	imbutton_message1; /* to select current image */
Panel_item	imbutton_message2; /* to select previous image */
Panel_item	useropt_qbutton; /* to quit conversion selector for complex images */
Panel_item	previous_useropt_qbutton; /* to quit conversion selector for complex images */
Panel_item	useropt_cbutton; /* to choose type of complex image conversion */
Panel_item	wait_message;
Panel_item 	imfilename_panel;

int	imx_coord=0;	/* Global image dimensions */
int	imy_coord=0;

int	mapx_coord=0;	/* Global map dimensions */
int	mapy_coord=0;
int	magimagecols=0;
int	magimagerows=0;
  
int	tools_selected=0;
int 	firstime=0;
int 	firstmap=1;
int	temprows=0, tempcols=0;
int     initial_image=1;
static  int magnification=1;

XImage  *xmapimage = NULL;		/* the X image format  */
XImage  *ximage;			/* the X image format  */
XImage  *xblankimage;			/* the X image format  */
IMAGE   *image_check = NULL;
IMAGE   *image1 = NULL;
IMAGE   *image2 = NULL;
IMAGE   *prev_image1 = NULL;
IMAGE   *prev_image2 = NULL;
IMAGE   *tempimage = NULL;
IMAGE   *check_image = NULL;

SENSOR   sensor;
int      LUT[256];
int      STATE = 0;
int      REDRAWN = FALSE;
char     ARGVIMAGE[40];
char     spl_str[250];

int	 	useropt_chbox_choice=0;
Panel_item	useropt_chbox;
int	 	previous_useropt_chbox_choice=0;
Panel_item	previous_useropt_chbox;
int		IMAGE1_SPLASH=1;
int		COMPLEX_CONVERTED=0;
int		COMPLEX_IMAGE=0;
int		IM_VALUE=-1;
int		PREVIOUS_IMAGE=0;
int		CURR_COMPLEX=0;
int		NO_INITIAL_IMAGE_ARG=0;

#define  CALCXYZ 1

/*------------------------------------------------------------------------*/


void main(argc, argv)
int      argc;
char    *argv[];
{
    VIP_STD_ERR = NULL;		/* suppress messages to screen - use alert
				 * boxes */
    (void) xv_init(XV_INIT_ARGC_PTR_ARGV, &argc, argv, XV_NULL);	/* Initialize xview. */
    InitWindows(argc, argv);	/* Initialize the windows. */
    return;
}

/*-  ShowImage  ---------------------------------------------------------

This function draws the image to the screen. It is a slow draw, using the
basic pixel drawing capabilities of X through routine DrawPoint

------------------------------------------------------------------------*/

void     ShowImage(image)
IMAGE   *image;
{
    int      i, j, col;

    DrawInto(imagecanvas);

    if (image == NULL)
	return;
    XClearWindow(display, win);	/* Clear the window in case some thing is
				 * alredy there. */
    for (i = 0; i < image->rows; i++)	/* Loop through the number of rows
					 * columns. */
	for (j = 0; j < image->cols; j++) {
	    if (image->i.c[i][j]) {	/* If colour value 0 then don't draw
					 * as the background is alredy that
					 * colour. */
		col = (int) image->i.c[i][j] / 4;	/* Get the colour value
							 * from the image. */
		XSetForeground(display, gc,
			       colour_table[col]);	/* Set the drawing
							 * colour. */
		XDrawPoint(display, win, gc, j, i);	/* Draw the point at vv							 *
							 * j,i. */
	    }
	}
}


/** SplashImage  ----------------------------------------------------------

James Trevelyan  September 1991

Function to quickly draw an image on the screen.  We clear the window, then
retrieve a small section to get the format right and check it for
consistency.  Then, we create a temporary holding area for the image data
and create it using assumed layout of the X colour table.  When the image
has been put into the window, the temporary holding areas are released.

This routine exploits the X image format to speed up the process and may not
be compatible with other hardware platforms.


To find out about X images, I wrote a test function to: (a) create a test
image (in the vision format) and (b) to display it using ShowImage(), (c)
to retrieve it using XGetImage, (d) to print out the header and data. This
showed that the X colour table values consist of the following when the
program is running: 0 - white 1 - black 2,3,4 - frame colours (normal,
rlight, dark) 5 - background colour 6 - grey frame colour (for scrollbars)
7....  colours generated for image display (from our client) Initially, my
colour(0) was black, so X saves space in its colour table by using a
reference to its colour(1) above.  This would complicate the image
generation, so I arranged for my darkest image shade to be not quite
black.

This done, the routine worked fine by assuming the first 7 colours were not
to be used. Until..........

Well, I put the PROPERTIES display up with all its colour palettes.  And
found that I had a problem. X had placed the palette colours where I
expected mine to be, so I produced a pseudo-colour image.  To get round
this, I decided to generate the 64 shades in my small test image, retrieve
them with the XGetImage call and use the resulting pixel array as a
look-up table.

------------------------------------------------------------------------------*/

#define NBYTE 4			/* number of bytes per word on this machine */
#define NXCOLOR 7		/* number of colours used by Xview for frame,
				 * background etc. */

void     SplashImage(image, sscale, map, x_orig, y_orig)
IMAGE   *image;			/* our image format */
int      sscale;
int	 map;
int 	 x_orig, y_orig;
{
    register char    *data, *data1, *save;
    register int      i, j, saved_bytes, ii, jj, im, nbl, nxc, nyc, imi, imj;

    if (map) {
	magimagecols=image->cols;
	magimagerows=image->rows;

        DrawInto(mapcanvas);
    }
    else {
        DrawInto(imagecanvas);
    }

    nxc = image->cols * sscale;
    nyc = image->rows * sscale;

    XClearWindow(display, win);	/* Clear the window */

    if (map) {
       if (xmapimage != NULL) {
	  XDestroyImage(xmapimage);
	  xmapimage = (XImage *) NULL;	
       }

       xmapimage = (XImage *) XCreateImage(display, DefaultVisual(display, DefaultScreen(display)),
				     (unsigned int) 8, (int) ZPixmap, (int) 0, (char *) NULL, 
				     (unsigned int) winwidth, (unsigned int) 10, (int) 8, (int) 640);
    }
    else {
	if (ximage != NULL) {
                XDestroyImage(ximage);
	        ximage = (XImage *) NULL;	
        }

        ximage = (XImage *) XCreateImage(display, DefaultVisual(display, DefaultScreen(display)),
			     (unsigned int) 8, (int) ZPixmap, (int) 0, (char *) NULL, 
			     (unsigned int) 128, (unsigned int) 10, (int) 8, (int) 640);
    }

#ifdef CUTOUT
    if (!(			/* check image format */
	  (ximage->byte_order == MSBFirst) &&
	  (ximage->bitmap_bit_order == MSBFirst) &&
	  (ximage->bitmap_unit == NBYTE * 8) &&
	  (ximage->depth == 8) &&
	  (ximage->bits_per_pixel == 8) &&
	  (ximage->xoffset == 0))) {

	(void) printf("SplashImage: Incompatible X image format\n");
	(void) printf("X image data\n");
	if (ximage->byte_order == LSBFirst)
	    (void) printf("LSBFirst\n");
	if (ximage->byte_order == MSBFirst)
	    (void) printf("MSBFirst\n");
	if (ximage->bitmap_bit_order == LSBFirst)
	    (void) printf("bits: LSBFirst\n");
	if (ximage->bitmap_bit_order == MSBFirst)
	    (void) printf("bits: MSBFirst\n");
	(void) printf("bitmap_unit: %d\n", ximage->bitmap_unit);
	(void) printf("depth: %d\n", ximage->depth);
	(void) printf("bytes_per_line: %d\n", ximage->bytes_per_line);
	(void) printf("bits_per_pixel: %d\n", ximage->bits_per_pixel);
	(void) printf("width %d\n", ximage->width);
	(void) printf("height %d\n", ximage->height);
	(void) printf("xoffset %d\n", ximage->xoffset);
    } else 
#endif
{
	if (map) { 
	    save = xmapimage->data;	/* retain original saved data pointer */
	    if (xmapimage->data != NULL) {
	        (void) free((char *) xmapimage->data);
	    }
	}
   	else {
	    save = ximage->data;	/* retain original saved data pointer */
	    if (ximage->data != NULL) {
	        (void) free((char *) ximage->data);
	    }
	}

	nbl = (((nxc - 1) / NBYTE + 1) * NBYTE);	/* bytes per line */

/*
	if (xblankimage == NULL) {

            xblankimage = (XImage *) XCreateImage(display, DefaultVisual(display,
						  DefaultScreen(display)), (unsigned int) 8,
				 		  (int) ZPixmap, (int) 0, (char *) NULL, 
				     		  (unsigned int) winwidth, (unsigned int) 10,
						  (int) 8, (int) 640);

            xblankimage->data = (char *) malloc(nbl * nyc * sizeof(char));
            if (xblankimage->data == NULL) {
                VIP_Error_Msg("SplashImage: Unable to allocate memory for map image");
                return;
	    }

	    xblankimage->bytes_per_line = nbl;

            for (j = 0, imj = 0; imj < image->rows, j < nyc; j += sscale, imj += 4 ) {
 	       if (imj >= image->rows) {
                   break;
               }

               data = xblankimage->data + j * xblankimage->bytes_per_line;
               for (i = 0, imi = 0; i < nxc; i += sscale, imi += 4 ) {
		   im = *data = colour_table[LUT[0] / 2];
                    data++;
                    for (ii = 1;  ii < sscale; ii++, data++)
                       *data = im;
               }
               for (jj = 1; (jj < sscale) && (j + jj < image->rows ); jj++) {
                    data1 = xblankimage->data + j * xblankimage->bytes_per_line;
                    data = data1 + jj * xblankimage->bytes_per_line;
                    for (i = 0; i < image->cols ; i++, data++, data1++)
                        *data = *data1;
               }
            }

	    xblankimage->width = nxc;
	    xblankimage->height = nyc;
	}
*/

	if (map) {
            xmapimage->data = (char *) malloc(nbl * nyc * sizeof(char));
	    if (xmapimage->data == NULL) {
                VIP_Error_Msg("SplashImage: Unable to allocate memory for map image");
                return;
            }
	}
	else {
            ximage->data = (char *) malloc(nbl * nyc * sizeof(char));
            if (ximage->data == NULL) {
                VIP_Error_Msg("SplashImage: Unable to allocate memory for image");
                return;
	    }
	}

        if (map) {
	        saved_bytes = xmapimage->bytes_per_line;
        }
        else {
          saved_bytes = ximage->bytes_per_line;
        }

        if (map) {
	     xmapimage->bytes_per_line = nbl;
	}
	else {
	   ximage->bytes_per_line = nbl;
	}

        if (!map) {
	    for (j = 0, imj = 0; j < nyc; j += sscale, imj++) {
		data = ximage->data + j * ximage->bytes_per_line;
		for (i = 0, imi = 0; i < nxc; i += sscale, imi++) {
		    im = *data = colour_table[LUT[image->i.c[imj][imi]] / 2];
	                  /* use colour_table as the lookup table */
		    data++;
		    for (ii = 1; ii < sscale; ii++, data++)
			*data = im;
		}
		for (jj = 1; (jj < sscale) && (j + jj < nyc); jj++) {
		    data1 = ximage->data + j * ximage->bytes_per_line;
		    data = data1 + jj * ximage->bytes_per_line;
		    for (i = 0; i < nxc; i++, data++, data1++)
			*data = *data1;
		}
	    }
	}

        if (map) {
           for (j = 0, imj = 0; imj < image->rows, j < nyc; j += sscale, imj += 4 ) {
 	       if (imj >= image->rows) {
                   break;
               }

               data = xmapimage->data + j * xmapimage->bytes_per_line;
               for (i = 0, imi = 0; i < nxc; i += sscale, imi += 4 ) {
		   im = *data = colour_table[LUT[image->i.c[imj][imi]] / 2];
                   /* use colour_table as the lookup * table */
                    data++;
                    for (ii = 1;  ii < sscale; ii++, data++)
                       *data = im;
               }
               for (jj = 1; (jj < sscale) && (j + jj < image->rows ); jj++) {
                    data1 = xmapimage->data + j * xmapimage->bytes_per_line;
                    data = data1 + jj * xmapimage->bytes_per_line;
                    for (i = 0; i < image->cols ; i++, data++, data1++)
                        *data = *data1;
               }
           }
       }


	    if (map) {
	        xmapimage->width = nxc;
	        xmapimage->height = nyc;
	    }
            else {
	        ximage->width = nxc;
	        ximage->height = nyc;
	    }


	    /* now plonk the image into the window */

	    XPutImage(display, win, gc,	
	         map ? xmapimage : ximage,
		 map ? 0 : x_orig, map ? 0 : y_orig,
	         0, 0,
                 map ? image->cols/4 : winwidth, map ? image->rows/4 : winheight);

	    if (!map) {/*
	        free((char *) ximage->data);*/	/* free up the temporary area */
/*
	        ximage->width = 128;
	        ximage->height = 10;
	        ximage->bytes_per_line = saved_bytes;*/	/* restore original
							 * ximage */
/*
	        ximage->data = save; *//* structure */

/* 		XDestroyImage(ximage); */	/* free up that memory too */
	    }
    }

    REDRAWN = TRUE;

    return;
}

/*- InitWindows  ----------------------------------------------------------*/

void InitWindows(argc, argv)
int      argc;
char    *argv[];
{
    static Xv_singlecolor colour[231];	/* The colour table. */


    if (argc == 2) {
        strcpy(ARGVIMAGE, argv[1]);
        initial_image=1;
    }
    else {
        strcpy(ARGVIMAGE, "\0");
	NO_INITIAL_IMAGE_ARG=1;
    }

    Set_Look_Up_Table(LUT, 1.0);

    SetUpColours(colour);

    tempimage = ( IMAGE * ) Read_Image(ARGVIMAGE);

    if (tempimage) {
        temprows = tempimage->rows;
	tempcols = tempimage->cols;
        Free_Image(tempimage);
    }
    else {
        temprows = 299;
        tempcols = 284;
    }

    /* Create the colour map segment. */
    cms = (Cms) xv_create(XV_NULL, CMS,
			  CMS_SIZE, 231,
			  CMS_COLORS, colour,
			  XV_NULL);

    /* Create the link to the global colour_table. */
    colour_table = (unsigned long *) xv_get(cms, CMS_INDEX_TABLE);



    /* Create a frame setting the label, width and height. */

    frame = (Frame) xv_create(XV_NULL, FRAME,
			      FRAME_LABEL, "SPLASH",
			      FRAME_MIN_SIZE, tempcols < 285 ? 480 : tempcols+1, 
					      (temprows/4)+10,
			      XV_X, -50,
			      XV_Y, -50,
                              XV_WIDTH, tempcols/4 < 120 ? 480 : tempcols+2,
			      XV_HEIGHT, temprows < 300 ? 294 : temprows,
			      XV_NULL);

    /* Create a panel. */
    panel = (Panel) xv_create(frame, PANEL,
			      XV_WIDTH, tempcols/4 < 120 ? 480 : tempcols+2,
			      XV_HEIGHT, temprows < 300 ? 294+(temprows/4) : temprows+(temprows/4),
			      XV_NULL);

    (void) xv_create(panel, PANEL_BUTTON,
		     XV_X, 5, 
		     XV_Y, 35,
		     PANEL_LABEL_STRING, "Quit ",
		     PANEL_NOTIFY_PROC, quit,
		     XV_NULL);

		     
    toolbutton = xv_create(panel, PANEL_BUTTON,
		     XV_X, 5,
		     XV_Y, 60,
		     PANEL_LABEL_STRING, "Tools",
		     PANEL_INACTIVE, !image1,
		     PANEL_NOTIFY_PROC, showtoolsframe,
		     XV_NULL);

    imfilename_panel = xv_create(panel, PANEL_TEXT,
		     XV_X, 5,
		     XV_Y, 12,
		     PANEL_LABEL_STRING, "Image ",
		     PANEL_VALUE, ARGVIMAGE,
		     PANEL_VALUE_DISPLAY_LENGTH, 19,
		     PANEL_NOTIFY_PROC, GetFile,
		     PANEL_NOTIFY_STRING, "\n\r",
		     XV_NULL);

    /*
     * Create a canvas thats parent is the frame. Give it a width and height.
     * Tell it what CMS to use.
     */

    ucanvas = (Canvas) xv_create(frame, CANVAS,
				     XV_X, 58,
				     XV_Y, 35,
				     XV_WIDTH, 50,
				     XV_HEIGHT, 45,
				     CANVAS_WIDTH, 50,
				     CANVAS_HEIGHT, 35,
				     CANVAS_AUTO_SHRINK, FALSE,
				     CANVAS_AUTO_EXPAND, TRUE,
				     WIN_CMS, cms,
				     XV_NULL);

    vcanvas = (Canvas) xv_create(frame, CANVAS,
				     XV_X, 110,
				     XV_Y, 35,
				     XV_WIDTH, 50,
				     XV_HEIGHT, 45,
				     CANVAS_WIDTH, 50,
				     CANVAS_HEIGHT, 35,
				     CANVAS_AUTO_SHRINK, FALSE,
				     CANVAS_AUTO_EXPAND, TRUE,
				     WIN_CMS, cms,
				     XV_NULL);

    intcanvas = (Canvas) xv_create(frame, CANVAS,
				     XV_X, 162,
				     XV_Y, 35,
				     XV_WIDTH, 50,
				     XV_HEIGHT, 45,
				     CANVAS_WIDTH, 50,
				     CANVAS_HEIGHT, 35,
				     CANVAS_AUTO_SHRINK, FALSE,
				     CANVAS_AUTO_EXPAND, TRUE,
				     WIN_CMS, cms,
				     XV_NULL);

    imagecanvas = (Canvas) xv_create(frame, CANVAS,
				     XV_X, 0,
                                     XV_Y, (temprows/4)+10 > 84 ? (temprows/4)+10 : 85,
			             XV_WIDTH, tempcols/4 < 120 ? 480 : (tempcols+2),
			             XV_HEIGHT, tempcols < 300 ? 294: (temprows+1),
				     CANVAS_AUTO_SHRINK, FALSE,
				     CANVAS_AUTO_EXPAND, TRUE,
				     CANVAS_X_PAINT_WINDOW, TRUE,
				     WIN_CMS, cms,
				     XV_NULL);
/*
    xv_set(canvas_paint_window(imagecanvas),CANVAS_REPAINT_PROC,repaint,XV_NULL);
*/

    if (initial_image) {
        mapcanvas = (Canvas) xv_create(frame, CANVAS,
                                     XV_X, tempcols < 285 ? 359 : tempcols-(tempcols/4),
                                     XV_Y, 5,
                                     XV_WIDTH, tempcols/4 < 120 ? 120 : (tempcols/4),
                                     XV_HEIGHT, tempcols < 300 ? 74 : temprows/4,
                                     CANVAS_AUTO_SHRINK, FALSE,
                                     CANVAS_AUTO_EXPAND, TRUE,
                                     WIN_CMS, cms,
                                     XV_NULL);
    }

    SaveDpy( xv_get (frame, XV_DISPLAY ),
		xv_get(canvas_paint_window(imagecanvas),XV_XID),
		xv_get( imagecanvas, XV_WIDTH),
		xv_get( imagecanvas, XV_HEIGHT));

    if (initial_image) {
         SaveDpy( xv_get (frame, XV_DISPLAY ),
                xv_get(canvas_paint_window(mapcanvas),XV_XID),
                xv_get( mapcanvas, XV_WIDTH),
                xv_get( mapcanvas, XV_HEIGHT));
    }


 
     /*
     * Define all of the events that can occur in the canvas. When one of
     * these events occur it will call event_proc.
     */

        xv_set(canvas_paint_window(imagecanvas),
	   WIN_CONSUME_EVENTS,
	   WIN_RESIZE,
	   WIN_VISIBILITY_NOTIFY,
	   WIN_MOUSE_BUTTONS, WIN_ASCII_EVENTS, LOC_MOVE,
	   KBD_USE, KBD_DONE,
	   XV_NULL,
	   WIN_EVENT_PROC, event_proc,
	   XV_NULL);

        xv_set(canvas_paint_window(mapcanvas),
	   WIN_CONSUME_EVENTS,
	   WIN_VISIBILITY_NOTIFY,
	   LOC_DRAG,
	   XV_NULL,
	   WIN_EVENT_PROC, map_event_proc,
	   XV_NULL);

    window_fit(frame);



    /* Tools Frame */

    toolsframe = (Frame) xv_create(XV_NULL, FRAME,
				   FRAME_LABEL, "TOOLS",
				   XV_X, 500,
				   XV_Y, 100,
				   XV_WIDTH, 400,
				   XV_HEIGHT, 100,
				   XV_SHOW, FALSE,
				   XV_NULL);


    panel = (Panel) xv_create(toolsframe, PANEL, PANEL_LAYOUT, PANEL_VERTICAL, NULL);

/*
    (void) xv_create(panel, PANEL_BUTTON,
		     PANEL_LABEL_STRING, "Close",
		     PANEL_NOTIFY_PROC, hidetoolsframe,
		     XV_NULL);
*/

    magbutton = xv_create(panel, PANEL_CHOICE,
		     XV_X, 5,
		     XV_Y, 10,
		     PANEL_LABEL_STRING, "Mag   ",
		     PANEL_INACTIVE, !image1,
		     PANEL_CHOICE_STRINGS,
		     "1", "2", "3", "4", "5", "6", XV_NULL,
		     PANEL_VALUE, 0,	/* the first item */
		     PANEL_NOTIFY_PROC, SetMagnification,
		     XV_NULL);

    imbutton1 = xv_create(panel, PANEL_CHOICE,
		     XV_X, 320,
		     XV_Y, 10,
		     PANEL_CHOOSE_NONE, TRUE,
		     PANEL_LABEL_STRING, "",
		     PANEL_INACTIVE, !image1,
		     PANEL_CHOICE_STRINGS, " ", XV_NULL,
		     PANEL_VALUE, -1,	/* the first item */
		     PANEL_NOTIFY_PROC, SetImage,
		     XV_NULL);

/*
    imbutton_message0 = xv_create(panel, PANEL_MESSAGE,
		     PANEL_LABEL_STRING, "                         ",
		     XV_X, 215,
		     XV_Y, 15,
		     XV_NULL);
*/

    imbutton_message1 = xv_create(panel, PANEL_MESSAGE,
		     PANEL_LABEL_STRING, "Previous/Current",
		     XV_X, 205,
		     XV_Y, 9,
		     XV_NULL);


    imbutton_message2 = xv_create(panel, PANEL_MESSAGE,
		     PANEL_LABEL_STRING, "Image Display",
		     XV_X, 205,
		     XV_Y, 22,
		     XV_NULL);

    xv_set(imbutton_message1, XV_SHOW, TRUE, XV_NULL);
    xv_set(imbutton_message2, XV_SHOW, TRUE, XV_NULL);

    if (!PREVIOUS_IMAGE) {
        xv_set(imbutton1, PANEL_INACTIVE, TRUE, XV_NULL);
    }
    else {
        xv_set(imbutton1, PANEL_INACTIVE, FALSE, XV_NULL);
    }
  

/*
    else {
    if (IM_VALUE==-1) {
        xv_set(imbutton1, XV_SHOW, TRUE, XV_NULL);
    }
    }
*/

    (void) xv_create(panel, PANEL_MESSAGE,
		     PANEL_LABEL_STRING, "xyz to uv conversion:",
		     XV_X, 5,
		     XV_Y, 50,
		     XV_NULL);

    (void) xv_create(panel, PANEL_TEXT,
		     PANEL_LABEL_STRING, "Enter  x y z                                    ",
		     PANEL_VALUE_DISPLAY_LENGTH, 15,
		     PANEL_NOTIFY_PROC, testxyz2uv,
		     PANEL_NOTIFY_STRING, "\n\r",
		     XV_X, 155,
		     XV_Y, 50,
		     XV_NULL);

    (void) xv_create(panel, PANEL_MESSAGE,
		     PANEL_LABEL_STRING, "uv to xyz conversion:",
		     XV_X, 5,
		     XV_Y, 75,
		     XV_NULL);

    (void) xv_create(panel, PANEL_TEXT,
		     PANEL_LABEL_STRING, "Enter  plane file and plane No   ",
		     PANEL_VALUE_DISPLAY_LENGTH, 15,
		     PANEL_NOTIFY_PROC, testuv2xyz,
		     PANEL_NOTIFY_STRING, "\n\r",
		     XV_X, 155,
		     XV_Y, 75,
		     XV_NULL);

    (void) xv_create(panel, PANEL_MESSAGE,
		     PANEL_LABEL_STRING, "gamma X 100:",
		     XV_X, 5,
		     XV_Y, 100,
		     XV_NULL);

    (void) xv_create(panel, PANEL_SLIDER,
		     PANEL_VALUE, 100,
		     PANEL_MIN_VALUE, 0,
		     PANEL_MAX_VALUE, 400,
		     PANEL_SLIDER_WIDTH, 250,
		     PANEL_NOTIFY_PROC, setgamma,
		     XV_X, 150,
		     XV_Y, 100,
		     XV_NULL);


    (void) xv_create(panel, PANEL_MESSAGE,
		     PANEL_LABEL_STRING, "modified image:",
		     XV_X, 5,
		     XV_Y, 125,
		     XV_NULL);

    (void) xv_create(panel, PANEL_BUTTON,
		     PANEL_LABEL_STRING, "Save",
		     PANEL_NOTIFY_PROC, Show_Popup_Frame,
		     XV_X, 150,
		     XV_Y, 122,
		     XV_NULL);

    (void) xv_create(panel, PANEL_MESSAGE,
		     PANEL_LABEL_STRING, "Tools:",
		     XV_X, 250,
		     XV_Y, 125,
		     XV_NULL);

    (void) xv_create(panel, PANEL_BUTTON,
		     XV_X, 345, 
		     XV_Y, 122,
		     PANEL_LABEL_STRING, "Quit ",
		     PANEL_NOTIFY_PROC, quit_tools,
		     XV_NULL);

    slicecanvas = (Canvas) xv_create(toolsframe, CANVAS,
				     XV_X, 0,
				     XV_Y, 150,
				     XV_WIDTH, 512,
				     XV_HEIGHT, 150,
				     WIN_CMS, cms,
				     XV_NULL);

    LUTslicecanvas = (Canvas) xv_create(toolsframe, CANVAS,
					XV_X, 0,
					XV_Y, 310,
					XV_WIDTH, 512,
					XV_HEIGHT, 150,
					WIN_CMS, cms,
					XV_NULL);

    xyzcanvas = (Canvas) xv_create(toolsframe, CANVAS,
				   XV_X, 350,
				   XV_Y, 5,
				   XV_WIDTH, 150,
				   XV_HEIGHT, 40,
				   CANVAS_WIDTH, 150,
				   CANVAS_HEIGHT, 30,
				   CANVAS_AUTO_SHRINK, FALSE,
				   CANVAS_AUTO_EXPAND, TRUE,
				   WIN_CMS, cms,
				   XV_NULL);

    window_fit(toolsframe);

    popupframe = (Frame)xv_create(toolsframe, FRAME_CMD,
           XV_WIDTH, 300,
           XV_HEIGHT, 50,
           FRAME_LABEL, "Save Modified Image",
           XV_NULL);

    panel = (Panel)xv_get(popupframe, FRAME_CMD_PANEL);
    (void) xv_create(panel, PANEL_TEXT,
		     PANEL_LABEL_STRING, "Enter image name ",
		     PANEL_VALUE_DISPLAY_LENGTH, 15,
		     PANEL_NOTIFY_PROC, Write_Modified_Image,
		     PANEL_NOTIFY_STRING, "\n\r",
		     XV_NULL); 

    xv_main_loop(frame);
}


void     quit()
{
    xv_destroy_safe(toolsframe);
    xv_destroy_safe(frame);
}

void initial_useropt_quit(item, value, event)
Panel_item item;
int value;
Event   *event;
{
  Frame	  this_frame;

  COMPLEX_CONVERTED=0;

  this_frame = (Frame) xv_get(xv_get(item, PANEL_PARENT_PANEL), XV_OWNER);

  useroptframe=( Frame )NULL;

  xv_destroy_safe(this_frame);
  xv_set(imfilename_panel, PANEL_INACTIVE, FALSE, XV_NULL);
  PREVIOUS_IMAGE=0;
  return;
}

void     useropt_quit(item, value, event)
Panel_item item;
int value;
Event   *event;
{
  Frame	  this_frame;

  COMPLEX_CONVERTED=0;

  this_frame = (Frame) xv_get(xv_get(item, PANEL_PARENT_PANEL), XV_OWNER);

  useroptframe=( Frame )NULL;

  xv_destroy_safe(this_frame);
  
  xv_set(imfilename_panel, PANEL_INACTIVE, FALSE, XV_NULL);
  xv_set(imbutton1, PANEL_VALUE, -1, XV_NULL);
  xv_set(imbutton_message1, XV_SHOW, TRUE, XV_NULL);
  xv_set(imbutton_message2, XV_SHOW, TRUE, XV_NULL);

 if (!PREVIOUS_IMAGE) {
   xv_set(imbutton1, PANEL_INACTIVE, TRUE, XV_NULL);
   xv_set(imbutton1, XV_SHOW, FALSE, XV_NULL);
 }
 else {
   xv_set(imbutton1, PANEL_INACTIVE, FALSE, XV_NULL);
   xv_set(imbutton1, XV_SHOW, TRUE, XV_NULL);
 }
  
 return;
}

void     quit_tools()
{
    xv_set(toolsframe, XV_SHOW, FALSE, XV_NULL);
    tools_selected=0;
    return;
}

void     DisplayNotice(message, event, parent)
char     message[60];
Event   *event;
Panel    parent;
{
    int      answer;

    answer = notice_prompt(parent, NULL,
			   NOTICE_FOCUS_XY, event_x(event), event_y(event),
			   NOTICE_MESSAGE_STRINGS, message,
			   NULL,
			   NOTICE_BUTTON_YES, "OK",
			   NULL);
    if (answer == NOTICE_YES)
	return;
}

/*---------------------------------------------------------------------*/

void     event_proc(window, event)	/* Called when there is an event in
					 * the canvas. */
Xv_Window window;
Event   *event;
{
    int      x=0, y=0, x1=0, y1=0, value;
    int      action;
    int      eflag=0;

    if (((event_action(event)) >0) && ((event_action(event)) < 260)) {
        event=NULL;
        return;
    }

    if ((event_action(event)) == 31799) {
        eflag=1;
    }

    if ((event_action(event)) == 32512) {
        eflag=1;
    }

    if ((event_action(event)) == 32516) {
        eflag=1;
    }

    if ((event_action(event)) == 32526) {
        eflag=1;
    }

    if ((event_action(event)) == 32520) {
        eflag=1;
    }

    if ((event_action(event)) == 32521) {
        eflag=1;
    }

    if ((!eflag)) {
        event=NULL;
        return;
    }

    if (event_action(event) == WIN_VISIBILITY_NOTIFY) {
        notify_set_itimer_func(imagecanvas, initial_splash, ITIMER_REAL, &newvalue, &oldvalue);
    }

    if (event_is_ascii(event))
        quit();

    if (event_is_down(event) && event_action(event) == ACTION_SELECT) {
        action = ACTION_SELECT;
    } else if (event_is_down(event) && event_action(event) == ACTION_ADJUST)
 {
        action = ACTION_ADJUST;
    } else {
        action = 0;
    }


    x = event_x(event);
    y = event_y(event);

    if (y<0) {
        y1 = y*-1;
        y=y1;
    }

    if (x<0) {
        x1 = x*-1;
        x=x1;
    }

    Set_UVInt(x, y);

    (void) Make_Slice(x, y, action);

    if (STATE == CALCXYZ)
        (void) showxyz(x, y);

    /*
     * pass the display and window value to repaint. This is then used to se
t
     * the global display and window variables.
     */

/*
           repaint((Canvas) NULL, window,
                display,
                (Window) xv_get(canvas_paint_window(imagecanvas), XV_XID),
                (Xv_xrectlist *) NULL, event );
*/

        switch (event_action(event)) {
            case WIN_RESIZE:
                SaveDpy( xv_get (frame, XV_DISPLAY ),
                xv_get(canvas_paint_window(imagecanvas),XV_XID),
                xv_get( imagecanvas, XV_WIDTH),
                xv_get( imagecanvas, XV_HEIGHT));

                value = magnification;
                magnification = Bounded(( int ) value, 1, 6);

                if (image1) {
                    DrawInto(imagecanvas);
                    XClearWindow(display, win);
                    XPutImage(display, win, gc, ximage,
                                (mapx_coord*4)*magnification,
                                (mapy_coord*4)*magnification,
                                0, 0,
                                tempcols*magnification, temprows*magnification);

                    set_mag_view(mapx_coord, mapy_coord, magnification, 0);
                }
            default:
                 break;
        }
}

/*---------------------------------------------------------------------

Function to handle the digitising of slices


states: 0  - wait for first point
        1  - 1st point digitised - start rubber banding
        2  - 2nd point digitised - display slice


transitions: from 0 - 1 - when left mouse button pressed
             from 1 - 2 - when left mouse button pressed again
             from 2 - 0 - when middle mouse button pressed - clears slice
             from 2 - 1 - when left mouse button pressed - immediately starts new slice

----------------------------------------------------------------------*/



int      Make_Slice(x, y, action)
int      x, y, action;
{
    static int state = 0;
    static int x0, sy0;
    static int x1, sy1;
    static int xlast, ylast;

    if (image1 && y > 0 && y < image1->rows * magnification && x > 0 && x < image1->cols * magnification) {

	DrawInto(imagecanvas);

	XSetForeground(display, gc, colour_table[XORDRAW]);

	switch (state) {

	case 0:
	    if (action == ACTION_SELECT) {
		x0 = xlast = x;
		sy0 = ylast = y;
		state = 1;
	    }
	    break;


	case 1:
	    if (action == ACTION_SELECT) {	/* draw slice */
		x1 = xlast;
		sy1 = ylast;

		(void) PlotSlice(x0, sy0, x1, sy1);
		state = 2;

	    } else {		/* rubber band */
		(void) DrawSliceLine(x0, sy0, xlast, ylast);
		(void) DrawSliceLine(x0, sy0, x, y);
		xlast = x;
		ylast = y;
		state = 1;
	    }
	    break;


	case 2:
	    if (action == ACTION_SELECT) {	/* clear slice and start new
						 * one */
		if (!REDRAWN) {
		    (void) DrawSliceLine(x0, sy0, x1, sy1);
		    XDrawPoint(display, win, gc, x0, sy0);
		}
		x0 = xlast = x;
		sy0 = ylast = y;
		state = 1;
	    } else if ((action == ACTION_ADJUST)) {	/* clear slice */
		if (!REDRAWN) {
		    (void) DrawSliceLine(x0, sy0, xlast, ylast);
		    XDrawPoint(display, win, gc, x0, sy0);
		}
		state = 0;
	    }
	    break;


	}			/* switch */
    }
    return (0);
}

/*- DrawSliceLine-----------------------------------------------------*/

int      DrawSliceLine(x0, ly0, x1, ly1)
int      x0, ly0, x1, ly1;
{
    DrawInto(imagecanvas);
    XSetForeground(display, gc, colour_table[XORDRAW]);
    XSetFunction(display, gc, GXxor);
    XDrawLine(display, win, gc, x0, ly0, x1, ly1);
    REDRAWN = FALSE;
    return (0);
}

/*---------------------------------------------------------------------*/

void     repaint(can, paint_window, dpy, xwin, xrects, event)
Canvas   can;			/* Ignored */
Xv_Window paint_window;		/* Ignored */
Display *dpy;
Window   xwin;
Xv_xrectlist *xrects;		/* Ignored */
Event   *event;			/* Ignored */
{

/*
    if (event_action(event) == WIN_REPAINT && image1)
*/
/*
	SplashImage(image1, magnification, 0, 0, 0);
*/
        DrawInto(imagecanvas);

	XClearWindow(display, win);
        XPutImage(display, win, gc,	
            ximage,
            (mapx_coord*4)*magnification,
            (mapy_coord*4)*magnification,
            0, 0,
/*
            ximage->width*magnification, ximage->height*magnification);
*/
            winwidth, winheight);

    return;
}


/*----------------------------------------------------------------------*/

void     showtoolsframe()
{
    xv_set(toolsframe, XV_SHOW, TRUE, XV_NULL);
    tools_selected=1;
    return;
}

/*----------------------------------------------------------------------*/

void     hidetoolsframe()
{
    xv_set(toolsframe, XV_SHOW, FALSE, XV_NULL);
    return;
}


/*----------------------------------------------------------------------*/

void     Show_Popup_Frame()
{
    xv_set(popupframe, XV_SHOW, TRUE, XV_NULL);
    return;
}

/*----------------------------------------------------------------------*/




void     SetImage(item, value, event)
Panel_item item;
unsigned int value;
Event   *event;
{
  Xv_notice	badfile_notice;
  int 	res_stat=0;

/*
  xv_set(imbutton1, XV_SHOW, FALSE, XV_NULL);
*/

  if (previous_useroptframe) {
     xv_destroy_safe(previous_useroptframe);
     previous_useroptframe = ( Frame ) NULL;
  }

  if (!PREVIOUS_IMAGE) {
      badfile_notice = xv_create (frame,
		    NOTICE,
    		    NOTICE_FOCUS_XY, 60, 60,
		    NOTICE_MESSAGE_STRING,"Error : No Previous Image to Display",
		    NOTICE_BUTTON_YES, "Continue",
		    NOTICE_STATUS, &res_stat,
		    XV_SHOW, TRUE,
		    XV_NULL);
	
      switch (res_stat) {
            case NOTICE_YES:
	        xv_destroy_safe(badfile_notice);
	        res_stat = 0;
                xv_set(imbutton1, PANEL_VALUE, -1, XV_NULL);
                xv_set(imbutton1, XV_SHOW, TRUE, XV_NULL);
                xv_set(imfilename_panel, PANEL_INACTIVE, FALSE, XV_NULL);
                return;
      }
  }
  else {
      if (useroptframe) {
         xv_destroy_safe(useroptframe);
         useroptframe = ( Frame ) NULL;
      }
  }


  IM_VALUE=(int) value;

  (void) printf("VALUE = %d\n", value);

  if (prev_image1!=NULL) {
      (void) printf("PREV_IMAGE1 != NULL\n");
  }
  else {
      (void) printf("PREV_IMAGE1 = NULL\n");
  }

  if (prev_image2!=NULL) {
      (void) printf("PREV_IMAGE2 != NULL\n");
  }
  else {
      (void) printf("PREV_IMAGE2 = NULL\n");
  }


  if (IM_VALUE == 0) {

      if (prev_image1!=NULL && prev_image2!=NULL ) {
/*
          xv_set(imbutton1, XV_SHOW, FALSE, XV_NULL);
          xv_set(imbutton1, PANEL_INACTIVE, TRUE, XV_NULL);
*/
          xv_set(imfilename_panel, PANEL_INACTIVE, TRUE, XV_NULL);
          xv_set(imbutton1, PANEL_INACTIVE, TRUE, XV_NULL);
          previous_useroptframe = (Frame) xv_create(frame, 
		    FRAME,
                    XV_X, 0,
                    XV_Y, 492,
                    XV_WIDTH, 513,
                    XV_HEIGHT, 154,
                    XV_SHOW, TRUE,
                    FRAME_LABEL, "PREVIOUS COMPLEX IMAGE REQUESTED FOR DISPLAY",
                    XV_NULL);

            previous_useroptpanel = (Panel) xv_create(previous_useroptframe,
                                 PANEL,
                                 XV_HEIGHT, 210,
                                 XV_NULL);

            previous_useroptcanvas = (Canvas) xv_create(previous_useroptframe, 
				     CANVAS,
                                     XV_X, 53,
                                     XV_Y, 5,
                                     XV_WIDTH, 460,
                                     XV_HEIGHT, 45,
                                     CANVAS_AUTO_SHRINK, FALSE,
                                     CANVAS_AUTO_EXPAND, TRUE,
                                     CANVAS_X_PAINT_WINDOW, TRUE,
                                     WIN_CMS, cms,
                                     XV_NULL);

            DrawInto(previous_useroptcanvas);
            XSetForeground(display, gc, colour_table[110]);
            XFillRectangle(display, win, gc, 0, 0, 513, 50);
            XSetForeground(display, gc, colour_table[BLACK]);

            XDrawString(display, win, gc, 10, 16, "select previous complex type image for display;", 46);
            XDrawString(display, win, gc, 10, 36, "please indicate if a magnitude or a phase byte type image is required", 69);

            previous_useropt_chbox_choice = 0;

            previous_useropt_chbox = xv_create(previous_useroptpanel, PANEL_CHECK_BOX,
                     PANEL_CHOOSE_ONE, TRUE,
                     PANEL_LAYOUT, PANEL_VERTICAL,
                     PANEL_CHOICE_STRINGS, "     magnitude image",
					   "     phase image",
                                           XV_NULL,
                     PANEL_NOTIFY_PROC, set_previous_useropt_choice_and_continue,
                     PANEL_VALUE, 0,
                     XV_X, 55,
                     XV_Y, 75,
                     XV_NULL);
/*
                     previous_useropt_qbutton = xv_create(previous_useroptpanel, PANEL_BUTTON,
		     XV_X, 5, 
		     XV_Y, 5,
		     PANEL_LABEL_STRING, "Quit",
		     PANEL_NOTIFY_PROC, useropt_quit,
		     XV_NULL);
*/
      }
      else {
        if (prev_image1 != NULL) {
          SplashImage(prev_image1, magnification, 0, 
	              (mapx_coord*4)*magnification, (mapy_coord*4)*magnification);
          if (initial_image) {
              SplashImage(prev_image1, magnification, 1, 
	       	          (mapx_coord*4)*magnification, (mapy_coord*4)*magnification);
          }
        }
         /* DISPLAY THE PREVIOUS IMAGE */
      xv_set(imbutton1, XV_SHOW, TRUE, XV_NULL);
      }
  }
  else {
      if (image1!=NULL && image2!=NULL) {
/*
          xv_set(imbutton1, XV_SHOW, FALSE, XV_NULL);
          xv_set(imbutton1, PANEL_INACTIVE, TRUE, XV_NULL);
*/
          xv_set(imfilename_panel, PANEL_INACTIVE, TRUE, XV_NULL);
          xv_set(imbutton1, PANEL_INACTIVE, TRUE, XV_NULL);
          previous_useroptframe = (Frame) xv_create(frame, 
		    FRAME,
                    XV_X, 0,
                    XV_Y, 492,
                    XV_WIDTH, 513,
                    XV_HEIGHT, 154,
                    XV_SHOW, TRUE,
                    FRAME_LABEL, "CURRENT COMPLEX IMAGE REQUESTED FOR DISPLAY",
                    XV_NULL);

          previous_useroptpanel = (Panel) xv_create(previous_useroptframe,
                                 PANEL,
                                 XV_HEIGHT, 210,
                                 XV_NULL);

          previous_useroptcanvas = (Canvas) xv_create(previous_useroptframe, 
				     CANVAS,
                                     XV_X, 53,
                                     XV_Y, 5,
                                     XV_WIDTH, 460,
                                     XV_HEIGHT, 45,
                                     CANVAS_AUTO_SHRINK, FALSE,
                                     CANVAS_AUTO_EXPAND, TRUE,
                                     CANVAS_X_PAINT_WINDOW, TRUE,
                                     WIN_CMS, cms,
                                     XV_NULL);

          DrawInto(previous_useroptcanvas);
          XSetForeground(display, gc, colour_table[110]);
          XFillRectangle(display, win, gc, 0, 0, 513, 50);
          XSetForeground(display, gc, colour_table[BLACK]);

          XDrawString(display, win, gc, 10, 16, "select current complex type image for display;", 47);
          XDrawString(display, win, gc, 10, 36, "please indicate if a magnitude or a phase byte type image is required", 69);

          previous_useropt_chbox_choice = 0;

          previous_useropt_chbox = xv_create(previous_useroptpanel, PANEL_CHECK_BOX,
                     PANEL_CHOOSE_ONE, TRUE,
                     PANEL_LAYOUT, PANEL_VERTICAL,
                     PANEL_CHOICE_STRINGS, "     magnitude image",
					   "     phase image",
                                           XV_NULL,
                     PANEL_NOTIFY_PROC, set_current_useropt_choice_and_continue,
                     PANEL_VALUE, 0,
                     XV_X, 55,
                     XV_Y, 75,
                     XV_NULL);
         /* DISPLAY THE CURRENT IMAGE & DISPLAY THE MAG/PHASE OPTION CARD */

/*
                     previous_useropt_qbutton = xv_create(previous_useroptpanel, PANEL_BUTTON,
		     XV_X, 5, 
		     XV_Y, 5,
		     PANEL_LABEL_STRING, "Quit",
		     PANEL_NOTIFY_PROC, useropt_quit,
		     XV_NULL);
*/
      }
      else {
         /* DISPLAY THE CURRENT IMAGE */
        if (prev_image1 != NULL) {
          SplashImage(image1, magnification, 0, 
	              (mapx_coord*4)*magnification, (mapy_coord*4)*magnification);
          if (initial_image) {
              SplashImage(image1, magnification, 1, 
	       	          (mapx_coord*4)*magnification, (mapy_coord*4)*magnification);
          }
        }
      }
      xv_set(imbutton1, XV_SHOW, TRUE, XV_NULL);
  }

  return;
}

void     SetMagnification(item, value, event)
Panel_item item;
unsigned int value;
Event   *event;
{

    magnification = Bounded(( int ) value + 1, 1, 6);

      if (COMPLEX_IMAGE) {
            if (useropt_chbox_choice) {
	        SplashImage(image1, magnification, 0, 
		    (mapx_coord*4)*magnification, (mapy_coord*4)*magnification);
            }
            else {
	        SplashImage(image2, magnification, 0, 
		    (mapx_coord*4)*magnification, (mapy_coord*4)*magnification);
            }
      }
      else {
                SplashImage(image1, magnification, 0,
                    (mapx_coord*4)*magnification, (mapy_coord*4)*magnification);
      }
/*
        if (image1->type == COMPLEXTYPE) {
            if (useropt_chbox_choice) {
	        SplashImage(image1, magnification, 0, 
		    (mapx_coord*4)*magnification, (mapy_coord*4)*magnification);
            }
            else {
	        SplashImage(image2, magnification, 0,
                    (mapx_coord*4)*magnification, (mapy_coord*4)*magnification);
            }
	}
	else {
            SplashImage(image1, magnification, 0,
                    (mapx_coord*4)*magnification, (mapy_coord*4)*magnification);
 	}
*/
  
      set_mag_view(mapx_coord, mapy_coord, magnification, 1);
/*
    mapx_coord = 0;
    mapy_coord = 0;
*/

    return;
}

/*----------------------------------------------------------------------*/


void     GetFile(item, event)
Panel_item item;
Event   *event;
{
  char    	*filename;
  Xv_notice	badfile_notice;

    IMAGE1_SPLASH=1;
    COMPLEX_CONVERTED=0;

    xv_set(imbutton1, PANEL_VALUE, -1, XV_NULL);

    if (useroptframe) {
        xv_destroy_safe(useroptframe);
	useroptframe = ( Frame ) NULL;
    }

    if (previous_useroptframe) {
        xv_destroy_safe(previous_useroptframe);
	previous_useroptframe = ( Frame ) NULL;
    }

    filename = (char *) xv_get(item, PANEL_VALUE);
   
    if (image_check != NULL) {
        Free_Image(image_check);
        image_check = ( IMAGE * ) NULL;
    }

    image_check = ( IMAGE * ) Read_Image(filename);

    if(image_check == NULL) {
        int 	res_stat;
      	firstime=2;
        xv_set(toolbutton, PANEL_INACTIVE, TRUE, XV_NULL);
        xv_set(magbutton, PANEL_INACTIVE, TRUE, XV_NULL);
        xv_set(imbutton1, PANEL_INACTIVE, TRUE, XV_NULL);
	    badfile_notice = xv_create (frame,
			    NOTICE,
	    		    NOTICE_FOCUS_XY, 60, 60,
			    NOTICE_MESSAGE_STRING,"Error : file not found or invalid",
			    NOTICE_BUTTON_YES, "Continue",
			    NOTICE_STATUS, &res_stat,
			    XV_SHOW, TRUE,
			    XV_NULL);
	
	    switch (res_stat) {
                case NOTICE_YES:
	            xv_destroy_safe(badfile_notice);
	            res_stat = 0;
/*
		    Free_Image(image1);
		    Free_Image(image2);
*/
        	    xv_set(imbutton1, PANEL_INACTIVE, FALSE, XV_NULL);
                    return;
	    }
    }



    if (prev_image1 != NULL) {
        Free_Image(prev_image1);
    }

    if (prev_image2 != NULL) {
        Free_Image(prev_image2);
    }

    if (image1 != NULL && image2 != NULL) {
        CopyBytetypeImages(image1, image2);
    }
    else {
      if (image1 != NULL) {
        CopyBytetypeImage(image1);
      }
    }

    filename = (char *) xv_get(item, PANEL_VALUE);
   
    if (image1 != NULL) {
        Free_Image(image1);
        image1 = ( IMAGE * ) NULL;
    }
    
    if (image2 != NULL) {
        Free_Image(image2);
        image2 = ( IMAGE * ) NULL;
    }
    
    image1 = ( IMAGE * ) Read_Image(filename);

    if(image1 == NULL) {
        int 	res_stat;
      	firstime=2;
        xv_set(toolbutton, PANEL_INACTIVE, TRUE, XV_NULL);
        xv_set(magbutton, PANEL_INACTIVE, TRUE, XV_NULL);
        xv_set(imbutton1, PANEL_INACTIVE, TRUE, XV_NULL);

	    badfile_notice = xv_create (frame,
			    NOTICE,
	    		    NOTICE_FOCUS_XY, 60, 60,
			    NOTICE_MESSAGE_STRING,"Error : file not found or invalid",
			    NOTICE_BUTTON_YES, "Continue",
			    NOTICE_STATUS, &res_stat,
			    XV_SHOW, TRUE,
			    XV_NULL);
	
	    switch (res_stat) {
                case NOTICE_YES:
	            xv_destroy_safe(badfile_notice);
	            res_stat = 0;
		    Free_Image(image1);
		    Free_Image(image2);
        	    xv_set(imbutton1, PANEL_INACTIVE, FALSE, XV_NULL);
                    return;
	    }
    }

    if (image1->type != COMPLEXTYPE) {
        COMPLEX_IMAGE=0;
        image2 = ( IMAGE * ) NULL;
	(void) printf ("IMAGE2 NULLED\n");
    }

    if (image1->type == FLOATTYPE) {
        image1 = ( IMAGE * ) Float2Byte_Image(image1);
    }

    if (image1->type == COMPLEXTYPE) {
        xv_set(imfilename_panel, PANEL_INACTIVE, TRUE, XV_NULL);
        xv_set(imbutton1, PANEL_INACTIVE, TRUE, XV_NULL);
        xv_set(imbutton1, XV_SHOW, FALSE, XV_NULL);
/*
        CURR_COMPLEX=1;
*/
              if (NO_INITIAL_IMAGE_ARG) {
              PREVIOUS_IMAGE=0;
              NO_INITIAL_IMAGE_ARG--;
              }
	      else {
              PREVIOUS_IMAGE=1;
              }

/*
              PREVIOUS_IMAGE=1;
*/

        if(image2 != NULL) {
            Free_Image(image2);
        }

        image2 = ( IMAGE * ) Read_Image(filename);
	IMAGE1_SPLASH=0;

        useroptframe = (Frame) xv_create(frame, 
		    FRAME,
                    XV_X, 0,
                    XV_Y, 492,
                    XV_WIDTH, 513,
                    XV_HEIGHT, 154,
                    XV_SHOW, TRUE,
                    FRAME_LABEL, "COMPLEX IMAGE REQUESTED FOR DISPLAY",
                    XV_NULL);

        useroptpanel = (Panel) xv_create(useroptframe,
                                 PANEL,
                                 XV_HEIGHT, 210,
                                 XV_NULL);

        useroptcanvas = (Canvas) xv_create(useroptframe, 
				     CANVAS,
                                     XV_X, 53,
                                     XV_Y, 5,
                                     XV_WIDTH, 460,
                                     XV_HEIGHT, 45,
                                     CANVAS_AUTO_SHRINK, FALSE,
                                     CANVAS_AUTO_EXPAND, TRUE,
                                     CANVAS_X_PAINT_WINDOW, TRUE,
                                     WIN_CMS, cms,
                                     XV_NULL);

        DrawInto(useroptcanvas);
        XSetForeground(display, gc, colour_table[110]);
        XFillRectangle(display, win, gc, 0, 0, 513, 50);
        XSetForeground(display, gc, colour_table[BLACK]);

        XDrawString(display, win, gc, 10, 16, "complex type image requires conversion to byte type image for display;", 71);
        XDrawString(display, win, gc, 10, 36, "please indicate if a magnitude or a phase byte type image is required", 69);

        useropt_chbox_choice = 0;

        useropt_chbox = xv_create(useroptpanel, PANEL_CHECK_BOX,
                     PANEL_CHOOSE_ONE, TRUE,
                     PANEL_LAYOUT, PANEL_VERTICAL,
                     PANEL_CHOICE_STRINGS, "     magnitude image",
					   "     phase image", 
					   XV_NULL,
                     PANEL_NOTIFY_PROC, set_useropt_choice_and_continue,
                     PANEL_VALUE, 0,
                     XV_X, 55,
                     XV_Y, 75,
                     XV_NULL);

        useropt_qbutton = xv_create(useroptpanel, PANEL_BUTTON,
		     XV_X, 5, 
		     XV_Y, 5,
		     PANEL_LABEL_STRING, "Quit",
		     PANEL_NOTIFY_PROC, useropt_quit,
		     XV_NULL);
    }

    if (image1) {
       if (IMAGE1_SPLASH) {

	SplashImage(image1, magnification, 0, 0, 0);
	if (initial_image) {
	    SplashImage(image1, 1, 1, 0, 0);
	}
        xv_set(toolbutton, PANEL_INACTIVE, FALSE, XV_NULL);
        xv_set(magbutton, PANEL_INACTIVE, FALSE, XV_NULL);
        xv_set(imbutton1, PANEL_INACTIVE, FALSE, XV_NULL);
     
              if (NO_INITIAL_IMAGE_ARG) {
              PREVIOUS_IMAGE=0;
              NO_INITIAL_IMAGE_ARG--;
              }
	      else {
              PREVIOUS_IMAGE=1;
              }

/*
              PREVIOUS_IMAGE=1;
*/

        firstime=2;
        set_mag_view(0, 0, magnification, 0);
      }
      else {
        xv_set(imbutton1, PANEL_INACTIVE, FALSE, XV_NULL);
     }
    }
}

/*--------------------------------------------------------------*/

int      Bounded(v, min, max)
int      v, min, max;

{
    if (v < min)
	return (min);
    else if (v > max)
	return (max);
    else
	return (v);
}


/*--------------------------------------------------*/

void Set_UVInt(x, y)
int      x, y;

{
    char     ustring[30];
    char     vstring[30];
    char     intstring[30];
    int      u, v;

    DrawInto(ucanvas);

    XSetFunction(display, gc, GXcopy);	/* normal line drawing */
    XSetForeground(display, gc, colour_table[WHITE]);
    XFillRectangle(display, win, gc, 0, 0, 50, 45);	/* clear previous text */

    XSetForeground(display, gc, colour_table[BLACK]);

    DrawInto(vcanvas);

    XSetFunction(display, gc, GXcopy);	/* normal line drawing */
    XSetForeground(display, gc, colour_table[WHITE]);
    XFillRectangle(display, win, gc, 0, 0, 50, 45);	/* clear previous text */

    XSetForeground(display, gc, colour_table[BLACK]);

    DrawInto(intcanvas);

    XSetFunction(display, gc, GXcopy);	/* normal line drawing */
    XSetForeground(display, gc, colour_table[WHITE]);
    XFillRectangle(display, win, gc, 0, 0, 50, 45);	/* clear previous text */

    XSetForeground(display, gc, colour_table[BLACK]);

    u = x / magnification;
    v = y / magnification;

    if (image1 ) {
	if (( v+(mapy_coord*4) < image1->rows ) && ( u+(mapx_coord*4) < image1->cols)) {
	    if (( v == 0 ) && ( u == 0)) {
                (void) sprintf(ustring, "%s", "                     ");
                (void) sprintf(vstring, "%s", "                     ");
                (void) sprintf(intstring, "%s", "                     ");
	    }
	    else {
	        (void) sprintf(ustring, "%3d", u+(mapx_coord*4));
	        (void) sprintf(vstring, "%3d", v+(mapy_coord*4));
		(void) sprintf(intstring, "%3d", image1->i.c[v+(mapy_coord*4)][u+(mapx_coord*4)]);
            }
        }
	else {
            (void) sprintf(ustring, "%s", "                     ");
            (void) sprintf(vstring, "%s", "                     ");
            (void) sprintf(intstring, "%s", "                     ");
	}
    }
    else {
        (void) sprintf(ustring, "%s", "                     ");
        (void) sprintf(vstring, "%s", "                     ");
        (void) sprintf(intstring, "%s", "                     ");
    }
    
    DrawInto(ucanvas);
    XDrawString(display, win, gc, 10, 12, "  u", 3);
    XDrawString(display, win, gc, 10, 32, ustring, strlen(ustring));
    
    DrawInto(vcanvas);
    XDrawString(display, win, gc, 10, 12, "  v", 3);
    XDrawString(display, win, gc, 10, 32, vstring, strlen(vstring));
     
    DrawInto(intcanvas);
    XDrawString(display, win, gc, 10, 12, " int", 4);
    XDrawString(display, win, gc, 10, 32, intstring, strlen(intstring));

    return;
}


/*- PlotSlice --------------------------------------------------*/

int      PlotSlice(x0, py0, x1, py1)
int      x0, py0, x1, py1;
{
    int      i, u, v, du, dv, Npixels;
    double  *slice, *LUTslice;
    double   uscale, vscale;

    if (!image1)
	return (0);		/* no image - no slice */

    DrawInto(slicecanvas);
    XSetFunction(display, gc, GXcopy);
    XSetForeground(display, gc, colour_table[WHITE]);
    XFillRectangle(display, win, gc, 0, 0, 512, 256);	/* clear previous text */
    XSetForeground(display, gc, colour_table[BLACK]);


    (void) SaveRetrieveSlicePts(1, &x0, &py0, &x1, &py1);	

/* save where the slice came from */

    x0 /= magnification;
    x1 /= magnification;
    py0 /= magnification;
    py1 /= magnification;

    du = x1 - x0;
    dv = py1 - py0;

    if (abs(du) > abs(dv))	/* line being scanned is more horizontal */
	Npixels = abs(du);
    else			/* line is more vertical */
	Npixels = abs(dv);

    if (Npixels == 0)
	Npixels = 1;

    slice = (double *) malloc(Npixels * sizeof(double));	/* allocate buffer */
    LUTslice = (double *) malloc(Npixels * sizeof(double));	/* allocate buffer */

    /* Copy pixels in image into buffer */

    uscale = (double) du / (double) Npixels;
    vscale = (double) dv / (double) Npixels;

    for (i = 0; i < Npixels; i++) {
	u = x0 + (double) i *uscale;
	v = py0 + (double) i *vscale;

        if (COMPLEX_IMAGE) {
	    if (useropt_chbox_choice) {
                if (u+(mapx_coord*4)>=image1->cols | v+(mapy_coord*4)>=image1->rows) { 
	            slice[i] = 0;
	            LUTslice[i] = 0;
	        }
	        else {
	            slice[i] = image1->i.c[v+(mapy_coord*4)][u+(mapx_coord*4)];
	            LUTslice[i] = LUT[image1->i.c[v+(mapy_coord*4)][u+(mapx_coord*4)]];
	        }
	    }
	    else {
                if (u+(mapx_coord*4)>=image2->cols | v+(mapy_coord*4)>=image2->rows) {
                    slice[i] = 0;
                    LUTslice[i] = 0;
                }
                else {
                    slice[i] = image2->i.c[v+(mapy_coord*4)][u+(mapx_coord*4)];
                    LUTslice[i] = LUT[image2->i.c[v+(mapy_coord*4)][u+(mapx_coord*
4)]];
                }
            }
	}
	else {
            if (u+(mapx_coord*4)>=image1->cols | v+(mapy_coord*4)>=image1->rows) { 
	        slice[i] = 0;
	        LUTslice[i] = 0;
	    }
	    else {
	        slice[i] = image1->i.c[v+(mapy_coord*4)][u+(mapx_coord*4)];
	        LUTslice[i] = LUT[image1->i.c[v+(mapy_coord*4)][u+(mapx_coord*4)]];
	    }
	}
    }

    Graph(slice, Npixels, 0.0, (double) Npixels, 50.0, 0.0, 255.0, 50.0, "Raw Slice Plot");

    DrawInto(LUTslicecanvas);
    XSetFunction(display, gc, GXcopy);
    XSetForeground(display, gc, colour_table[WHITE]);
    XFillRectangle(display, win, gc, 0, 0, 512, 256);	/* clear previous text */
    XSetForeground(display, gc, colour_table[BLACK]);

    Graph(LUTslice, Npixels, 0.0, (double) Npixels, 50.0, 0.0, 255.0, 50.0,
	  "Slice values through look up table");

    free(( char * ) slice);
    free(( char * ) LUTslice);
    return (0);
}


/*- SaveRetrieveSlicePts ------------------------------------------------------

Function to store or retrieve the end points of the slice line
If flag is TRUE data is saved
IF flag is FALSE data is stored

-------------------------------------------------------------------------------*/

int      SaveRetrieveSlicePts(flag, x0, ry0, x1, ry1)
int      flag, *x0, *ry0, *x1, *ry1;
{
    static int sx0, sy0, sx1, sy1;

    if (flag) {			/* save */
	sx0 = *x0;
	sy0 = *ry0;
	sx1 = *x1;
	sy1 = *ry1;
    } else {			/* retrieve */
	*x0 = sx0;
	*ry0 = sy0;
	*x1 = sx1;
	*ry1 = sy1;
    }

    return (0);
}

/*- testxyz2uv --------------------------------------------------------*/

int      testxyz2uv(item)
Panel_item item;
{
    int      uv[2];
    double   v[3];
    char    *params;

    params = (char *) xv_get(item, PANEL_VALUE);
    (void) sscanf(params, "%lf %lf %lf", &v[0], &v[1], &v[2]);
    xyz2uv(&image1->camera, uv, v);
    
    uv[0] *= magnification;
    uv[1] *= magnification;

    DrawInto(imagecanvas);
    XSetForeground(display, gc, colour_table[RED]);
    XSetFunction(display, gc, GXcopy);

    XDrawLine(display, win, gc, uv[0] - 22, 
				uv[1] - 2, 
				uv[0] + 18,
			 	uv[1] - 2 );

    XDrawLine(display, win, gc, uv[0] - 2, 
			        uv[1] - 22, 
				uv[0] - 2,
				uv[1] + 18);

        if (image1->camera.calib_status == 0 ) {
            (void) sprintf (spl_str, "Warning: uncalibrated image\n");
            splash_error(spl_str, toolsframe);
        }
    
    return (1);
}

/*- testuv2xyz --------------------------------------------------------*/

int      testuv2xyz(item, event)
Panel_item item;
Event	*event;
{
    char     file[40];
    static char     prev_file[40];
    int      planeNo;
    int      res_rd = 0;
    char    *params;
    extern long	PLANEBYTE;

    params = (char *) xv_get(item, PANEL_VALUE);
    (void) sscanf(params, "%s %d", file, &planeNo);

    if (strcmp(prev_file, file)!=0) {
        /*
         PLANEBYTE = 0;
        */
  
    }

    (void) strcpy (prev_file,file);

    if (planeNo < FILEPLANEMIN || planeNo > FILEPLANEMAX) {
        (void) strcpy(spl_str, "Error : plane number out of range\n 1 <= plane number <= 39\n please try again\n");
	splash_error(spl_str, toolsframe);
        return (1);
    } 
    
    res_rd = Read_Plane_List(file, planeNo);
    
    if (res_rd==9) {
        (void) strcpy (spl_str, "Error : invalid file name specified\n please try again\n");
        splash_error(spl_str, toolsframe);
	return (1);
    } 

    if (res_rd==8) {
        (void) strcpy (spl_str, "Error : plane number requested not specified in plane file\n please try again \n");
        splash_error(spl_str, toolsframe);
        return (1);
    } 

    if (res_rd==5) {
        (void) strcpy (spl_str, "Error : plane number in plane file out of range\n
			     1 <= plane number <= 39\n please edit file and try again\n");
	splash_error(spl_str, toolsframe);
        return (1);
    } 


    Calc_Sensor(image1->camera, PLANE[planeNo], &sensor);


    if (image1->camera.calib_status  == 0) {
       (void) sprintf (spl_str, "Warning: uncalibrated image\n");
       splash_error(spl_str, toolsframe);
    }

    STATE = CALCXYZ;

    return (1);
}

/*- showxyz  --------------------------------------------------------*/

int      showxyz(u, v)
int      u, v;
{
    int      uv[2];
    double   xyz[3];
    char     xyzstring[30];


    uv[0] = u / magnification;
    uv[1] = v / magnification;

    if (image1 && uv[0] < image1->rows && uv[1] < image1->cols
	&& uv[0] > 0 && uv[1] > 0) {

	uv2xyz(uv, xyz, sensor);

	DrawInto(xyzcanvas);


	XSetFunction(display, gc, GXcopy);	/* normal line drawing */
	XSetForeground(display, gc, colour_table[WHITE]);
	XFillRectangle(display, win, gc, 0, 0, 150, 40);	/* clear previous text */

	XSetForeground(display, gc, colour_table[BLACK]);


	(void) sprintf(xyzstring, "%6.3f %6.3f %6.3f", xyz[0], xyz[1], xyz[2]);


	XDrawString(display, win, gc, 10, 12, "    x      y      z", 19);
	XDrawString(display, win, gc, 10, 32, xyzstring, strlen(xyzstring));

    }
    return (1);
}

/*- gamma --------------------------------------------------------------*/

void     setgamma(item, event)
Panel_item item;
Event   *event;
{
    int      ipower;
    double   power;
    int      x0, gmy0, x1, gmy1;

    ipower = (int) xv_get(item, PANEL_VALUE);
    power = (double) ipower / 100.0;

    Set_Look_Up_Table(LUT, power);
    if (image1) {
      if (COMPLEX_IMAGE) {
            if (useropt_chbox_choice) {
	        SplashImage(image1, magnification, 0, 
		    (mapx_coord*4)*magnification, (mapy_coord*4)*magnification);
            }
            else {
	        SplashImage(image2, magnification, 0, 
		    (mapx_coord*4)*magnification, (mapy_coord*4)*magnification);
            }
      }
      else {
                SplashImage(image1, magnification, 0,
                    (mapx_coord*4)*magnification, (mapy_coord*4)*magnification);
      }
  
	set_mag_view(mapx_coord, mapy_coord, magnification, 1);
        
	(void) SaveRetrieveSlicePts(0, &x0, &gmy0, &x1, &gmy1);	/* retrieve where the
							 * slice came from */
	(void) DrawSliceLine(x0, gmy0, x1, gmy1);
	(void) PlotSlice(x0, gmy0, x1, gmy1);
    }

    return;
}


/*-----------------------------------------------------------*/

void Write_Modified_Image(item, event)
  Panel_item item;
  Event   *event;
{
  IMAGE *tmpimage;
  int i,j;
  char    *filename;

  filename = (char *) xv_get(item, PANEL_VALUE);

  if (strcmp(filename,"")==0) {
      (void) strcpy (spl_str,
		 "Error : target filename not specified\n please try again");
      splash_error (spl_str, popupframe);
      return;
  }

  if (image1) {
      tmpimage = ( IMAGE * ) Allocate_Image(0,0,image1->rows,image1->cols,BYTETYPE);
  }
  else {
      (void) strcpy (spl_str,
	 "Error : source image not specified\n please try again");
      splash_error (spl_str, frame);
      return;
  }

  for(i = 0; i < image1->rows; i++)
      for(j = 0; j < image1->cols; j++)
          tmpimage->i.c[i][j] = LUT[image1->i.c[i][j]];

  Write_Image(tmpimage,filename);
  Free_Image(tmpimage);

  xv_set(popupframe, XV_SHOW, FALSE, NULL);
  return;
}

void     splash_error(err_str, pframe)
  char	*err_str;
  Frame	pframe;
{ 
  Xv_notice	badfile_notice;
  int 	res_stat;

	badfile_notice = xv_create (pframe,
			    NOTICE,
			    NOTICE_FOCUS_XY, 30, 30,
			    NOTICE_MESSAGE_STRING, err_str,
			    NOTICE_BUTTON_YES, "Continue",
			    NOTICE_STATUS, &res_stat,
			    XV_SHOW, TRUE,
			    XV_NULL);
	
	switch (res_stat) {
            case NOTICE_YES:
		xv_destroy_safe(badfile_notice);
	        res_stat = 0;
	        (void) strcpy(err_str,"\0");
	}
}

void set_mag_view(orig_x, orig_y, mag_factor, event_flag)
  int orig_x, orig_y, mag_factor, event_flag;
{
  static int old_orig_x=0, old_orig_y=0, old_width=0, old_height=0;

        DrawInto(mapcanvas);

	XPutImage(display, win, gc,	
	         xmapimage,
		 0, 0,
		 0, 0,
		 magimagecols/4, magimagerows/4);

            XSetForeground(display, gc, colour_table[BLACK]);
            XSetFunction(display, gc, GXcopy);
	
	    XDrawRectangle(display, win, gc, old_orig_x, old_orig_y,
	        ((xv_get( imagecanvas, XV_WIDTH ))/4)/mag_factor,
	        ((xv_get( imagecanvas, XV_HEIGHT ))/4)/mag_factor);

            if (event_flag) {
	        XPutImage(display, win, gc,	
	        xmapimage,
	 	0, 0,
	 	0, 0,
	 	tempcols/4, temprows/4);
	    }

            XSetForeground(display, gc, colour_table[RED]);
            XSetFunction(display, gc, GXcopy);

            XDrawRectangle(display, win, gc, orig_x, orig_y,
	        ((xv_get( imagecanvas, XV_WIDTH ))/4)/mag_factor,
	        ((xv_get( imagecanvas, XV_HEIGHT ))/4)/mag_factor);

	old_orig_x = orig_x;
	old_orig_y = orig_y;
 	old_width = ((xv_get( imagecanvas, XV_WIDTH ))/4)/mag_factor;
 	old_height = ((xv_get( imagecanvas, XV_HEIGHT ))/4)/mag_factor;
	    
}



/* Called when there is an event in the map canvas ... */

void 	map_event_proc(window, event)	
  Xv_Window window;
  Event   *event;
{

    if (event_is_ascii(event))
	quit();

    if (event_is_down(event) && event_action(event) == ACTION_SELECT) {
        DrawInto(mapcanvas);

	XPutImage(display, win, gc,	
	         xmapimage,
		 0, 0,
		 0, 0,
		 magimagecols/4, magimagerows/4);
    }

    if (event_is_up(event) && event_action(event) == ACTION_SELECT) {

        mapx_coord = event_x(event);
        mapy_coord = event_y(event);

	if (mapx_coord<0) 
	    mapx_coord = 0;

	if (mapx_coord+(((tempcols)/4)/magnification)>=(((tempcols)/4)))
	 mapx_coord=((tempcols)/4)-(((tempcols)/4)/magnification);

	if (mapy_coord<0) 
	    mapy_coord = 0;

	if (mapy_coord+((temprows/4)/magnification)>=(temprows/4))
	 mapy_coord=((temprows)/4)-(((temprows)/4)/magnification);

	XClearWindow(display, win);

        set_mag_view(mapx_coord, mapy_coord, magnification, 1);

        DrawInto(imagecanvas);

	XClearWindow(display, win);
        XPutImage(display, win, gc,	
            ximage,
            (mapx_coord*4)*magnification,
            (mapy_coord*4)*magnification,
	    0,0,
/*
            ximage->width*magnification, ximage->height*magnification);
*/
            ximage->width*magnification, ximage->height*magnification);
    }

    if (event_is_down(event) && event_action(event) == LOC_DRAG) {

	mapx_coord = event_x(event);
        mapy_coord = event_y(event);

        if (mapx_coord<0)
            mapx_coord = 0;

        if (mapx_coord+(((tempcols)/4)/magnification)>=(((tempcols)/4)))
         mapx_coord=((tempcols)/4)-(((tempcols)/4)/magnification);

        if (mapy_coord<0)
            mapy_coord = 0;

        if (mapy_coord+((temprows/4)/magnification)>=(temprows/4))
         mapy_coord=((temprows)/4)-(((temprows)/4)/magnification);

        set_mag_view(mapx_coord, mapy_coord, magnification, 0);

    }
}

Notify_error canvas_events() 
{
    /* disable timer while button is being setup */
    notify_set_itimer_func(imagecanvas, NOTIFY_FUNC_NULL, ITIMER_REAL, NULL, NULL);

        xv_set(canvas_paint_window(imagecanvas),
	   WIN_CONSUME_EVENTS,
	   WIN_RESIZE,
	   WIN_VISIBILITY_NOTIFY,
	   WIN_MOUSE_BUTTONS, WIN_ASCII_EVENTS, LOC_MOVE,
	   KBD_USE, KBD_DONE,
	   XV_NULL,
	   WIN_EVENT_PROC, event_proc,
	   XV_NULL);

        xv_set(canvas_paint_window(mapcanvas),
	   WIN_CONSUME_EVENTS,
	   WIN_VISIBILITY_NOTIFY,
	   LOC_DRAG,
	   XV_NULL,
	   WIN_EVENT_PROC, map_event_proc,
	   XV_NULL);

        notify_set_itimer_func(imagecanvas, canvas_events, ITIMER_REAL,
                          &newvalue, &oldvalue);
}

Notify_error initial_splash()
{
  Xv_notice	badfile_notice;

    /* disable timer while button is being setup */
    notify_set_itimer_func(imagecanvas, NOTIFY_FUNC_NULL, ITIMER_REAL, NULL, NULL);

  if (firstime<2) {
    if (ARGVIMAGE[0]) {
        if (image1 != NULL) {
            Free_Image(image1);
            image1 = ( IMAGE * ) NULL;
	}

	image1 = ( IMAGE * ) Read_Image(ARGVIMAGE);

	if (image1 == NULL) {
            int 	res_stat;
    	    firstime=2;

	    badfile_notice = xv_create (frame,
	    		    NOTICE,
	    		    NOTICE_FOCUS_XY, 60, 60, 
	    		    NOTICE_MESSAGE_STRING, "Error : file not found or invalid ",
	    		    NOTICE_BUTTON_YES, "Continue",
			    NOTICE_STATUS, &res_stat,
			    XV_SHOW, TRUE,
			    XV_NULL);
	
	    switch (res_stat) {
                case NOTICE_YES:
	          xv_destroy_safe(badfile_notice);
		  res_stat = 0;
                
		  XWarpPointer(( Display * )xv_get(frame, XV_DISPLAY), None, 
			       xv_get(frame, XV_XID), 0, 0, 0, 0, 165, 65);

		  return;
	    }
	}

	 if (image1->type == FLOATTYPE) {
             image1 = ( IMAGE * ) Float2Byte_Image(image1);
         }

         if (image1->type == COMPLEXTYPE) {
             xv_set(imfilename_panel, PANEL_INACTIVE, TRUE, XV_NULL);
             xv_set(imbutton1, PANEL_INACTIVE, TRUE, XV_NULL);
	     image2 = ( IMAGE * ) Read_Image(ARGVIMAGE);
             IMAGE1_SPLASH=0;
             useroptframe = (Frame) xv_create(frame,
                    FRAME,
                    XV_X, 0,
                    XV_Y, 492,
                    XV_WIDTH, 513,
                    XV_HEIGHT, 154,
                    XV_SHOW, TRUE,
                    FRAME_LABEL, "COMPLEX IMAGE REQUESTED FOR DISPLAY",
                    XV_NULL);

             useroptpanel = (Panel) xv_create(useroptframe,
                                 PANEL,
                                 XV_HEIGHT, 210,
                                 XV_NULL);

             useroptcanvas = (Canvas) xv_create(useroptframe,
                                     CANVAS,
                                     XV_X, 53,
                                     XV_Y, 5,
                                     XV_WIDTH, 460,
                                     XV_HEIGHT, 45,
                                     CANVAS_AUTO_SHRINK, FALSE,
                                     CANVAS_AUTO_EXPAND, TRUE,
                                     CANVAS_X_PAINT_WINDOW, TRUE,
                                     WIN_CMS, cms,
                                     XV_NULL);

             DrawInto(useroptcanvas);
             XSetForeground(display, gc, colour_table[110]);
             XFillRectangle(display, win, gc, 0, 0, 513, 50);
             XSetForeground(display, gc, colour_table[BLACK]);

        XDrawString(display, win, gc, 10, 16, "complex type image requires conversion to byte type image for display;", 71);
        XDrawString(display, win, gc, 10, 36, "please indicate if a magnitude or a phase byte type image is required", 69);

             useropt_chbox_choice = 0;

             useropt_chbox = xv_create(useroptpanel, PANEL_CHECK_BOX,
                     PANEL_CHOOSE_ONE, TRUE,
                     PANEL_LAYOUT, PANEL_VERTICAL,
                     PANEL_CHOICE_STRINGS, "     magnitude image",
                                           "     phase image",
                                           XV_NULL,
                     PANEL_NOTIFY_PROC, set_useropt_choice_and_continue,
                     PANEL_VALUE, 0,
                     XV_X, 55,
                     XV_Y, 75,
                     XV_NULL);

/*
            wait_message = xv_create(useroptpanel, PANEL_MESSAGE,
		     PANEL_LABEL_STRING, "please wait .....",
		     XV_X, 55,
		     XV_Y, 125,
		     XV_NULL);

	    xv_set(wait_message, XV_SHOW, FALSE, XV_NULL);
*/

             useropt_qbutton = xv_create(useroptpanel, PANEL_BUTTON,
                     XV_X, 5,
                     XV_Y, 5,
                     PANEL_LABEL_STRING, "Quit",
                     PANEL_NOTIFY_PROC, initial_useropt_quit,
                     XV_NULL);

/*
             useropt_cbutton = xv_create(useroptpanel, PANEL_BUTTON,
                     XV_X, 5,
                     XV_Y, 30,
                     PANEL_LABEL_STRING, "Cont",
                     PANEL_NOTIFY_PROC, useropt_continue,
                     XV_NULL);
*/

/*
             window_fit(useroptframe);
*/
         }

	if (image1) {
          if (IMAGE1_SPLASH) {
	    SplashImage(image1, magnification, 0, 0, 0);
            xv_set(toolbutton, PANEL_INACTIVE, FALSE, XV_NULL);
            xv_set(magbutton, PANEL_INACTIVE, FALSE, XV_NULL);
            xv_set(imbutton1, PANEL_INACTIVE, TRUE, XV_NULL);
	    SplashImage(image1, magnification, 1, 0, 0 );
	  }
	  else {
            xv_set(imbutton1, PANEL_INACTIVE, TRUE, XV_NULL);
	  }
        }

	(void) strcpy(ARGVIMAGE, "\0");
    }
  }
return;
}


void 	set_useropt_choice(item, value, event)
  Panel_item    item;
  int           value;
  Event         *event;
{
  useropt_chbox_choice = (int) xv_get(item, PANEL_VALUE);
/*
  xv_set(useroptframe, XV_SHOW, FALSE, XV_NULL);
*/
  return;
}

void     useropt_continue(item, value, event)
Panel_item item;
int value;
Event   *event;
{
  Frame	  frame;

  frame = (Frame) xv_get(xv_get(item, PANEL_PARENT_PANEL), XV_OWNER);

  COMPLEX_IMAGE=1;
/*
  if (useropt_chbox_choice) {
*/
 			/* phase from complex */
      if ( !COMPLEX_CONVERTED) {
          image1 = ( IMAGE * )Complex2PhaseFloat_Image(image1); 
          image1 = ( IMAGE * )Float2Byte_Image(image1);
    
          image2 = ( IMAGE * )Complex2Float_Image(image2); /* mag from complex */
          image2 = ( IMAGE * )Float2Byte_Image(image2);
      }
/*
  }
*/

/*
  else {
      if ( !COMPLEX_CONVERTED) {
          image1 = ( IMAGE * )Complex2Float_Image(image1); 
          image1 = ( IMAGE * )Float2Byte_Image(image1);
							   
          image2 = ( IMAGE * )Complex2PhaseFloat_Image(image2);
          image2 = ( IMAGE * )Float2Byte_Image(image2);
      }
  }
*/

    COMPLEX_CONVERTED=1;

    IMAGE1_SPLASH=1;

    if (image1) {
        if (useropt_chbox_choice) {
	    SplashImage(image1, magnification, 0, 0, 0);
	    if (initial_image) {
	        SplashImage(image1, 1, 1, 0, 0);
	    }
	}
	else {
            SplashImage(image2, magnification, 0, 0, 0);
            if (initial_image) {
                SplashImage(image2, 1, 1, 0, 0);
            }
        }

        xv_set(toolbutton, PANEL_INACTIVE, FALSE, XV_NULL);
        xv_set(magbutton, PANEL_INACTIVE, FALSE, XV_NULL);
        xv_set(imbutton1, PANEL_INACTIVE, FALSE, XV_NULL);
        firstime=2;
        set_mag_view(0, 0, magnification, 0);
    }

/*
    xv_destroy_safe(frame);
    useroptframe=( Frame )NULL;
*/
    return;
}

void     set_useropt_choice_and_continue(item, value, event)
  Panel_item item;
  int value;
  Event   *event;
{
  Frame	  this_frame;

  useropt_chbox_choice = (int) xv_get(item, PANEL_VALUE);

  this_frame = (Frame) xv_get(xv_get(item, PANEL_PARENT_PANEL), XV_OWNER);
   

  COMPLEX_IMAGE=1;
 			/* phase from complex */
      if ( !COMPLEX_CONVERTED) {
          image1 = ( IMAGE * )Complex2PhaseFloat_Image(image1); 
          image1 = ( IMAGE * )Float2Byte_Image(image1);
    
          image2 = ( IMAGE * )Complex2Float_Image(image2); /* mag from complex */
          image2 = ( IMAGE * )Float2Byte_Image(image2);
      }

    COMPLEX_CONVERTED=1;

    IMAGE1_SPLASH=1;

    if (image1) {
        if (useropt_chbox_choice) {
	    SplashImage(image1, magnification, 0, 0, 0);
	    if (initial_image) {
	        SplashImage(image1, 1, 1, 0, 0);
	    }
	}
	else {
            SplashImage(image2, magnification, 0, 0, 0);
            if (initial_image) {
                SplashImage(image2, 1, 1, 0, 0);
            }
        }

        xv_set(toolbutton, PANEL_INACTIVE, FALSE, XV_NULL);
        xv_set(magbutton, PANEL_INACTIVE, FALSE, XV_NULL);
        firstime=2;
        set_mag_view(0, 0, magnification, 0);
    }
/*
    xv_destroy_safe(this_frame);
    useroptframe=( Frame )NULL;
*/
    return;
}

void CopyBytetypeImages(im1, im2)
  IMAGE *im1;
  IMAGE *im2;
{
  int     i, j;

  prev_image1 = (IMAGE *) Allocate_Image(im1->umin, im1->vmin, im1->rows,
			       im1->cols, BYTETYPE);

  prev_image2 = (IMAGE *) Allocate_Image(im2->umin, im2->vmin, im2->rows,
			       im2->cols, BYTETYPE);

  (void) Copy_Header(im1, prev_image1);
  (void) Copy_Header(im2, prev_image2);

  prev_image1->type = BYTETYPE;
  prev_image2->type = BYTETYPE;

 for (i = 0; i < im1->rows; i++) {
     for (j = 0; j < im1->cols; j++) {
         prev_image1->i.c[i][j] = im1->i.c[i][j];
         prev_image2->i.c[i][j] = im2->i.c[i][j];
     }
 }
}


void CopyBytetypeImage(im1)
  IMAGE *im1;
{
  int     i, j;

  prev_image1 = (IMAGE *) Allocate_Image(im1->umin, im1->vmin, im1->rows,
					 im1->cols, BYTETYPE);

  (void) Copy_Header(im1, prev_image1);

  prev_image1->type = BYTETYPE;

  for (i = 0; i < im1->rows; i++) {
     for (j = 0; j < im1->cols; j++) {
         prev_image1->i.c[i][j] = im1->i.c[i][j];
     }
  }

  Free_Image(image2);
  Free_Image(prev_image2);
  image2 = ( IMAGE * )NULL;
  prev_image2 = ( IMAGE * )NULL;
}

void     set_previous_useropt_choice_and_continue(item, value, event)
  Panel_item item;
  int value;
  Event   *event;
{
  Frame	  this_frame;

  previous_useropt_chbox_choice = (int) xv_get(item, PANEL_VALUE);

  if (previous_useropt_chbox_choice) {
      if (prev_image1->type == COMPLEXTYPE) {
          prev_image1 = ( IMAGE * )Complex2PhaseFloat_Image(prev_image1); 
          prev_image1 = ( IMAGE * )Float2Byte_Image(prev_image1);
      }
      SplashImage(prev_image1, magnification, 0, 
      (mapx_coord*4)*magnification, (mapy_coord*4)*magnification);
      if (initial_image) {
          SplashImage(prev_image1, magnification, 1, 
                      (mapx_coord*4)*magnification, (mapy_coord*4)*magnification);
      }
  }
  else {
      if (prev_image2->type == COMPLEXTYPE) {
          prev_image2 = ( IMAGE * )Complex2Float_Image(prev_image2); /* mag from complex */
          prev_image2 = ( IMAGE * )Float2Byte_Image(prev_image2);
      }
      SplashImage(prev_image2, magnification, 0, 
                  (mapx_coord*4)*magnification, (mapy_coord*4)*magnification);
      if (initial_image) {
          SplashImage(prev_image2, magnification, 1, 
	 	      (mapx_coord*4)*magnification, (mapy_coord*4)*magnification);
      }
  }

/*
  xv_set(toolbutton, PANEL_INACTIVE, FALSE, XV_NULL);
  xv_set(magbutton, PANEL_INACTIVE, FALSE, XV_NULL);
  firstime=2;
  set_mag_view(0, 0, magnification, 0);

  xv_set(imbutton1, XV_SHOW, TRUE, XV_NULL);
  xv_set(imbutton1, PANEL_VALUE, -1, XV_NULL);
*/
  
  if (previous_useroptframe) {
     xv_destroy_safe(previous_useroptframe);
     previous_useroptframe = ( Frame ) NULL;
  }

  xv_set(imfilename_panel, PANEL_INACTIVE, FALSE, XV_NULL);
  xv_set(imbutton1, PANEL_INACTIVE, FALSE, XV_NULL);
}
void     set_current_useropt_choice_and_continue(item, value, event)
  Panel_item item;
  int value;
  Event   *event;
{
  Frame	  this_frame;

  previous_useropt_chbox_choice = (int) xv_get(item, PANEL_VALUE);

  if (previous_useropt_chbox_choice) {
      if ( prev_image1->type == COMPLEXTYPE) {
          prev_image1 = ( IMAGE * )Complex2PhaseFloat_Image(prev_image1); 
          prev_image1 = ( IMAGE * )Float2Byte_Image(prev_image1);
      }
      SplashImage(image1, magnification, 0, 
      (mapx_coord*4)*magnification, (mapy_coord*4)*magnification);
      if (initial_image) {
          SplashImage(prev_image1, magnification, 1, 
                      (mapx_coord*4)*magnification, (mapy_coord*4)*magnification);
      }
  }
  else {
    if (prev_image2 != NULL) {
      if (prev_image2->type == COMPLEXTYPE) {
          prev_image2 = ( IMAGE * )Complex2Float_Image(prev_image2); /* mag from complex */
          prev_image2 = ( IMAGE * )Float2Byte_Image(prev_image2);
      }
      SplashImage(image2, magnification, 0, 
                  (mapx_coord*4)*magnification, (mapy_coord*4)*magnification);
      if (initial_image) {
          SplashImage(prev_image2, magnification, 1, 
	 	      (mapx_coord*4)*magnification, (mapy_coord*4)*magnification);
      }
    }
  }

/*
  xv_set(toolbutton, PANEL_INACTIVE, FALSE, XV_NULL);
  xv_set(magbutton, PANEL_INACTIVE, FALSE, XV_NULL);
  firstime=2;
  set_mag_view(0, 0, magnification, 0);

  xv_set(imbutton1, XV_SHOW, TRUE, XV_NULL);
  xv_set(imbutton1, PANEL_VALUE, -1, XV_NULL);
*/
  
  if (previous_useroptframe) {
     xv_destroy_safe(previous_useroptframe);
     previous_useroptframe = ( Frame ) NULL;
  }

  xv_set(imfilename_panel, PANEL_INACTIVE, FALSE, XV_NULL);
  xv_set(imbutton1, PANEL_INACTIVE, FALSE, XV_NULL);
/*
  xv_set(imbutton1, XV_SHOW, TRUE, XV_NULL);
*/
}

