/*******************************************************************************
*
* University of Western Australia
* Department of Computer Science
* Copyright 1988 University of Western Australia
*
* SYSTEM :              VIP
* RELEASE:		3
* SUBSYSTEM:            LIB
* MODULE:	        math.c - Contains some mathematics routines.		
* REVISION:             3.1
* AUTHOR:               Du Huynh
* CREATION DATE:        19 Nov 1991
* REVISION DATE:        7/10/92
*
********************************************************************************
*
* REVISION LOG
*
* REVISION NO:		3.1
* REVISION DATE:	9 July 1992
* COMMENT:		ANSIfied and SCCS'd
* BY:			CFF
*
*******************************************************************************/

#ifndef lint
static char *sccs_id = "@(#)math.c	3.1 7/10/92";
#endif

#include <stdio.h>
#include <math.h>
#include <stdlib.h>
#include "vip.h"
#include "mathfn.h"

#define TWO_PI      6.283185307179586

#ifdef DOS
#define MAX         32768.0
#else
#define MAX         2147483648.0
#endif

/*- Rand_Gauss ------------------------------------------------------

Generate random number from the Gaussian Distribution
with mean=0 and S.D.=1.

--------------------------------------------------------------------*/

static double  Rand_Gauss()
{
    static int sw = 1;
    static double rand1, rand2, delta, phi;
    static int k;

    if (sw) {
	do
	    k = rand();
	while (!k);
	rand1 = k / MAX;
if (k > MAX) {
 (void) fprintf(stderr, "k=%d, MAX=%f\n", k, MAX);
 (void) getchar();
}
	do
	    k = rand();
	while (!k);
	rand2 = k / MAX;
	phi = TWO_PI * rand2;
	delta = sqrt(-2 * log(rand1));
	sw = 0;
	return (delta * cos(phi));
    }
    else
	sw = 1;
    return (delta * sin(phi));
}


/*- Gnoise ----------------------------------------------------------

Add Gaussian noise to an image.  'sd' is the standard deviation
of the Gaussian Distribution.

--------------------------------------------------------------------*/

void Gnoise(im, sd)
IMAGE  *im;
double  sd;
{
    int     r, c;
    double  temp;

    if (!im) {
	VIP_Error_Msg("Gnoise: input image is NULL");
	return;
    }
    switch (im->type) {
    case BYTETYPE:
	for (r = im->rows - 1; r >= 0; r--)
	    for (c = im->cols - 1; c >= 0; c--) {
		temp = im->i.c[r][c] + Rand_Gauss() * sd;
		if (temp < 0)
		    temp = 0;
		else if (temp >= 256)
		    temp = 255;
		im->i.c[r][c] = temp;
	    }
	break;
    default:
	VIP_Error_Msg("Gnoise: can only process images of BYTETYPE");
    }
}

