/*******************************************************************************
*
* University of Western Australia
* Department of Computer Science
* Copyright (c) University of Western Australia
*
* SYSTEM :              VIP
* RELEASE:		%R%
* SUBSYSTEM:            INCLUDE
* MODULE:		vipiofn.h - ANSI Fn. Prototypes for vipio.c
* REVISION:             %I%
* AUTHOR:               CFF
* CREATION DATE:        10 July 1992
* REVISION DATE:	%G%
*
********************************************************************************
*
* REVISION LOG
*
* REVISION:             3.9
* CREATION DATE:        29 March 1994
* COMMENT:		Added Construct_Complex_Image, Extract_Real,
                        Extract_Imaginary declarations
* BY:			PK
*
* REVISION:             3.8
* CREATION DATE:        29 March 1994
* COMMENT:		Added Image_OK declaration
* BY:			PK
*
* REVISION:             3.7
* CREATION DATE:        03 March 1994
* COMMENT:		Added __vip_h
* BY:			CFF
*
* REVISION:             3.6
* CREATION DATE:        08 Nov 1993
* COMMENT:		Fixed Write_Header prototype.
* BY:			CFF
*
* REVISION:             3.5
* CREATION DATE:        15 August 1993
* COMMENT:		Fixed up for DEC build.
* BY:			CFF
*
* REVISION:             3.4
* CREATION DATE:        28 July 1993
* COMMENT:		Fixed up for DOS build.
* BY:			CFF
*
* REVISION:             3.3
* CREATION DATE:        28 June 1993
* COMMENT:		Added fn. prototype for new fns - 
*			  Complex2MagFloat_Image
*			  Convert2Byte_Image
*			  Convert2Short_Image
*			  Convert2Float_Image
*			  Convert2Complex_Image
*			  Convert2Double_Image
* BY:			CFF
*
* REVISION:             3.2
* CREATION DATE:        05 May 1993
* COMMENT:		Added fn. prototype for new fns - 
*			  Complex2PhaseFloat_Image
*			  Complex_Phase		
* BY:			CFF
*
* REVISION:             3.1
* CREATION DATE:        10 July 1992
* COMMENT:		ANSIfied and SCCS'd
* BY:			CFF
*
* "%W% %G%"
*
*******************************************************************************/

#ifndef __vip_h

struct struct_vip_IMAGE  *Allocate_Header( 
				int32, int32, int32, int32, int32 );
struct struct_vip_IMAGE  *Allocate_Image( 
				int32, int32, int32, int32, int32 );

int     Free_Image( struct struct_vip_IMAGE * );
int     Set_Image( struct struct_vip_IMAGE *, double );
struct struct_vip_IMAGE  *Read_Image( char * );
void    Read_Header( struct struct_vip_IMAGE *, FILE *);
int     Write_Image( struct struct_vip_IMAGE *, char * );
void    Write_Header( struct struct_vip_IMAGE *, FILE * );
int     Not_An_Image( struct struct_vip_IMAGE *);
int     Copy_Header( struct struct_vip_IMAGE *,
	 struct struct_vip_IMAGE * );

struct struct_vip_IMAGE  *Copy_Image( struct struct_vip_IMAGE * );
struct struct_vip_IMAGE  *Byte2Short_Image( 
				      struct struct_vip_IMAGE * );
struct struct_vip_IMAGE  *Byte2Float_Image( 
				      struct struct_vip_IMAGE * ); 
struct struct_vip_IMAGE  *Byte2Complex_Image( 
				      struct struct_vip_IMAGE * );
struct struct_vip_IMAGE  *Float2Byte_Image( 
				      struct struct_vip_IMAGE * );
struct struct_vip_IMAGE  *Float2Short_Image( 
				      struct struct_vip_IMAGE * );
struct struct_vip_IMAGE  *Complex2Float_Image( 
				      struct struct_vip_IMAGE * );
struct struct_vip_IMAGE  *Convert2Short_Image( 
				      struct struct_vip_IMAGE * );
struct struct_vip_IMAGE  *Convert2Long_Image( 
				      struct struct_vip_IMAGE * );
struct struct_vip_IMAGE  *Convert2Float_Image( 
				      struct struct_vip_IMAGE * );
struct struct_vip_IMAGE  *Convert2Byte_Image( 
				      struct struct_vip_IMAGE * );
struct struct_vip_IMAGE  *Convert2Complex_Image( 
				      struct struct_vip_IMAGE * );
struct struct_vip_IMAGE  *Convert2Double_Image( 
				      struct struct_vip_IMAGE * );
int     Write_VFFImage( struct struct_vip_IMAGE *, char *);

int     Common_Window( struct struct_vip_IMAGE *, 
		       struct struct_vip_IMAGE *, 
		       int32 *, int32 *, int32 *, int32 * );

int     Pixel_In_Image( struct struct_vip_IMAGE *, int32, int32 );

int     Image_OK(  struct struct_vip_IMAGE * );
void    VIP_Error_Msg( char * );
float   Complex_Magnitude_2( struct struct_vip_COMPLEX *);

float   ComplexPhase(struct struct_vip_COMPLEX *);
struct struct_vip_IMAGE  *Complex2PhaseFloat_Image( struct struct_vip_IMAGE * );
struct struct_vip_IMAGE  *Complex2MagFloat_Image( struct struct_vip_IMAGE * );
struct struct_vip_IMAGE *Construct_Complex_Image(struct struct_vip_IMAGE * Re, struct struct_vip_IMAGE * Im);
struct struct_vip_IMAGE  *Extract_Real(struct struct_vip_IMAGE * image);
struct struct_vip_IMAGE  *Extract_Imaginary(struct struct_vip_IMAGE * image);


#endif /* !__vip_h */

