/*******************************************************************************
*
* University of Western Australia
* Department of Computer Science
* Copyright (c) University of Western Australia
*
* SYSTEM :              VIP
* RELEASE:		3
* SUBSYSTEM:            INCLUDE
* MODULE:		pcvip.h - Header file for V.I.P. images		
* REVISION:             3.1
* AUTHOR:               PK
* CREATION DATE:        9 March 1988
* REVISION DATE:	7/14/92        
*
********************************************************************************
*
* REVISION LOG
*
* REVISION:             3.1
* REVISION DATE:	10 July 1992
* COMMENT:		ANSIfied and SCCS'd
* BY:			CFF
*
* REVISION:             
* REVISION DATE:	Sept 1991
* COMMENT:		
* BY:			Sam/DU
*
* @(#)pcvip.h	3.1 7/14/92
*
*******************************************************************************/




#include <stdio.h>

#define VERSION "2.0"		/* Software version No for file stamping */
#define VIP_MESSAGE_LENGTH 256

/*- ID codes for data structures -------------------------------------*/

#define IMAGE_ID   9191
#define CAMERA_ID  2000
#define INT_MASK_ID   3000
#define PIPSTATUS_ID 4000

/*- Macros  --------------------------------------------------------*/

/* Macro to return the intensity of a point in a BYTE image with *absolute coords u and v */
#define PIXEL_B(image,u,v) (long)(image->i.c[(u)-image->umin][(v)-image->vmin])

/*-  Data types used to build IMAGE structure  ---------------------*/

#define BYTETYPE    1
#define SHORTTYPE   2
#define LONGTYPE    3
#define FLOATTYPE   4
#define DOUBLETYPE  5
#define COMPLEXTYPE 6
#define RGBTYPE     7
#define HSITYPE     8


/*- Data structures  -----------------------------------------------*/

typedef struct {		/* complex number */
    float   r;
    float   i;
}       COMPLEX;

typedef unsigned char RGB[4];	/* Red, Green Blue stored in an array of four
				 * bytes for convenience and efficiency */
typedef unsigned char HSI[4];

typedef unsigned char *c_array;
typedef short *s_array;
typedef long *l_array;
typedef float *f_array;
typedef double *d_array;
typedef COMPLEX *cx_array;
typedef RGB *rgb_array;
typedef HSI *hsi_array;

typedef union anytype {
    char    c;
    short   s;
    long    l;
    float   f;
    double  d;
    COMPLEX cx;
    RGB     rgb;
    HSI     hsi;
}       anytype;

typedef union imagedata {
    c_array *c;
    s_array *s;
    l_array *l;
    f_array *f;
    d_array *d;
    cx_array *cx;
    rgb_array *rgb;
    hsi_array *hsi;
}       imagedata;



/*-  CAMERA structure  --------------------------------------------*/

typedef struct {
    long     idcode;
    char    version[8];
    long     channel;		/* Channel on PIP board */
    long     gain, offset;	/* Gain and offset for the channel */
    long     uvoffset;		/* UV offset in using calibration matrix and
				 * compensation data
				 */
    long     not_used;		/* to avoid null paddings */
    double  gamma[5];		/* For grey scale correction if needed */
    double  calib_matrix[3][4];	/* Calibration matrix */
    double  Ucomp[18];		/* Coeffs of lens compensation polynomial */
    double  Vcomp[18];		/* Coeffs of lens compensation polynomial */
}       CAMERA;


/*- IMAGE Data Structure --------------------------------------------*/

typedef struct {
    long     idcode;		/* Code to allow automatic identification */
    char    version[8];		/* software version No */
    long     type;		/* Data type - char, rgb colour etc */
    long     umin;		/* Image origin coords */
    long     vmin;
    long     rows;
    long     cols;
    double  resolution;
    char    info[80];		/* Space for comments */
    CAMERA  camera;
    long   reserved[3];
    void   *pntr[2];
    union imagedata i;
}       IMAGE;


/*--------------------------------------------------------------------*/


typedef struct {
    long     idcode;
    char    version[8];
    long     rows;
    long     cols;
    long     rescale;
    l_array *m;			/* mask data */
}       INT_MASK;


/*- Global variables  ----------------------------------------------*/


extern FILE *VIP_STD_ERR;
extern FILE *VIP_LOG_FILE;
extern int VIP_LOG;		/* flag to turn data logging on or off */
extern int VIP_VERBOSE;		/* flag to turn on or off extra printing of
				 * data */
extern char VIP_MESSAGE[VIP_MESSAGE_LENGTH];	/* Global message string for
						 * use by X view alert boxes */
extern int VIP_DISPLAY;		/* flag for turning image display on or off */

/*-------------------------------------------------------------------

Function declarations

--------------------------------------------------------------------*/

/* Functions in oldvip.c */
IMAGE *Convert_Image();
IMAGE *Convert_Matrix();
IMAGE *Convert_Complex_Image();


/* Functions in vipio.c */

IMAGE  *Allocate_Image();
int     Free_Image();
IMAGE  *Read_Image();
int     Write_Image();
int     NotAnImage();
int     Copy_Header();
IMAGE  *Byte2Short_Image();
IMAGE  *Byte2Float_Image();
IMAGE  *Byte2Complex_Image();
IMAGE  *Float2Byte_Image();
IMAGE  *Complex2Float_Image();
IMAGE  *Read_PCImage();
int     Write_VFFImage();
int     Common_Window();
int     PixelInImage();
void    VIP_Error_Msg();


/* Functions in vipspat.c */

int     Histogram_Image();
IMAGE  *Thresh_Image();
IMAGE  *Convolve_Image();
IMAGE  *Average_Image();
IMAGE  *Diff_Image();
IMAGE  *Subtract_Image();
IMAGE  *Scale_Image();
IMAGE  *DeRes_Image();
int     Find_Spot();
int     Wind_Int();
INT_MASK *Allocate_Int_Mask();
void    Free_Int_Mask();
INT_MASK *Read_Int_Mask();
int     Write_Int_Mask();
IMAGE  *Erode_Image();
IMAGE  *Dilate_Image();


/* Functions in revbyte.c */
long ntohl();
long htonl();
float ntohf();
float htonf();
double ntohd();
double htond();

