/********************************************************************
*                            other.c                                *
*                                                                   *
*  Copyright (C) 1995 by Heikki Tienari. See tis.doc for more info. *
*                                                                   *
*  This module contains some "other" TIS functions.                *
*                                                                 *
*  090495 -HT- CopyFirstToMaster() was clipped from main.c.      *
*  160495 -HT- Swapping and copying between images works.        *
*  170495 -HT- First version of ShowImageInfo().                 *
*  190495 -HT- ShowImageInfo() is now using L_Mesg().            *
*  200495 -HT- Very first version of SetImageSize().             *
*  210495 -HT- Scretched?, relativ to window?.                   *
*  220495 -HT- SetImageSize() and SetImageOffset() works.        *
*  250495 -HT- AutoSetImageSize() SEEMS to work. Cannot promise  *
*              anything because code is very complicated.        *
*  030595 -HT- We are now using Super_Refresh() in CopyImageXTo- *
*              ImageY().                                         *
*  080595 -HT- Little bug in SetImageOffset() fixed.             *
*  110595 -HT- Little bugs in SetImageOffset() and SetImageSize()*
*              fixed.                                            *
*  160595 -HT- Makefile support.                                 *
*****************************************************************/

#include <math.h>
#include <X11/Xlib.h>
#include "image.h"
#include "externs.h"

CopyImageXToImageY( ImageX, ImageY, possibleXImageNro )
struct Image_Struct *ImageX, *ImageY;
char possibleXImageNro;
{
  int Width, Height;
  int x, y, i;

  Width = ImageX->width;
  Height= ImageX->height;

  for( y=0; y<ImageY->height; y++ )     /* Check if ImageY exists */
    free( ImageY->data.map_lines[y] );
  free( ImageY->data.map_lines );
  free( ImageY->Colour_Map );

  Make_Empty_Image( ImageY, Width, Height ); /* Make new empty one */

  if( possibleXImageNro )
    MakeImage( possibleXImageNro ); /* Prepare ximage */

  /* We will copy First_Image to Master_Image: */
  for( y=0; y<Height; y++ )
    for( x=0; x<Width; x++ )
      {
      ImageY->data.map_lines[y][x] = ImageX->data.map_lines[y][x];
      if( possibleXImageNro )
        {
        if( ImageY->Colour_Map_Size>0 )
          XPutPixel(image_xi[possibleXImageNro],x,y,colormap[ImageY->data.map_lines[y][x]]);
        else      
          XPutPixel(image_xi[3],x,y,colormap[
            (int)(One_Image[3].data.rgb_lines[y].red[x]/42.5)*36
            +(int)(One_Image[3].data.rgb_lines[y].green[x]/42.5)*6
            +(int)(One_Image[3].data.rgb_lines[y].blue[x]/42.5)]);
        }
      }

  if( Cur_Image==possibleXImageNro )
    Super_Refresh( possibleXImageNro );
  printf("Ready.\n");
 }  

SwapImages( img1, img2 )
unsigned char img1, img2;
{
  MoveImageResponsibility( &One_Image[img2], &Fake_Image );
  MoveImageResponsibility( &One_Image[img1], &One_Image[img2] );
  MoveImageResponsibility( &Fake_Image, &One_Image[img1] );

  MakeImage( img1 );
  MakeImage( img2 );

  if( Cur_Image==img1 || Cur_Image==img2 )
    Refresh( Cur_Image );
  printf("%d and %d swapped.\n", img1, img2 );
}

MoveImageResponsibility( ImageX, ImageY )
struct Image_Struct *ImageX, *ImageY;
{
  printf("mir %d,%d ->", ImageY->width, ImageY->height );
  ImageY->width = ImageX->width;
  ImageY->height = ImageX->height;
  ImageY->Colour_Map_Size = ImageX->Colour_Map_Size;
  ImageY->Colour_Map = ImageX->Colour_Map;
  ImageY->data.rgb_lines = ImageX->data.rgb_lines;
  ImageY->data.map_lines = ImageX->data.map_lines;
  printf(" %d,%d\n", ImageY->width, ImageY->height );
}

ShowImageInfo()
{
  unsigned char result;
  char InfoLine1[50]={"Image:    size  : "};
  char InfoLine2[50]={"          offset: "};
  char InfoLine4[50]={"Window:   size  : "};
  char size_w[6], size_h[6], off_x[6], off_y[6], win_w[6], win_h[6];
  short wx, wy;

  ConvertNroToString( One_Image[Cur_Image].width, &size_w, 0 );
  ConvertNroToString( One_Image[Cur_Image].height, &size_h, 0 );
  ConvertNroToString( offs_X[Cur_Image], &off_x, 0 );
  ConvertNroToString( offs_Y[Cur_Image], &off_y, 0 );
  GetWindowSize( &wx, &wy );
  ConvertNroToString( wx, &win_w, 0 );
  ConvertNroToString( wy, &win_h, 0 );
  
  AddToString( &InfoLine1, &size_w );
  AddToString( &InfoLine1, " x " );
  AddToString( &InfoLine1, &size_h );
  AddToString( &InfoLine2, &off_x );
  AddToString( &InfoLine2, " x " );
  AddToString( &InfoLine2, &off_y );
  AddToString( &InfoLine4, &win_w );
  AddToString( &InfoLine4, " x " );
  AddToString( &InfoLine4, &win_h );

  result = L_Mesg( InfoLine1, InfoLine2, "", InfoLine4, "", "", "[The Image Studio, v0.5  by Hessu]", "OK" );
  if( result&1 )
    printf("Too small window!!!!!!!!!\n");
  if( result&2 )
    {
    Refresh( Cur_Image );
    DrawPanel();
    }
}

SetImageSize()
{
  unsigned char result;
  char size[30]={""}, o_w[6], o_h[6], n_w[10], n_h[10];
  char guide[30]={"Current size : "};
  short n=0, i=0, width, height, x, y;
  float nx=0, ny=0, stepx, stepy;

  ConvertNroToString( One_Image[Cur_Image].width, &o_w, 0 );
  ConvertNroToString( One_Image[Cur_Image].height, &o_h, 0 );
  AddToString( &guide, &o_w );
  AddToString( &guide, " x " );
  AddToString( &guide, &o_h );

  result = Get_String( &size, guide );
  if( result&2 )
    {
    Refresh( Cur_Image );
    DrawPanel();
    }
  if( result&1 )
    return;

  while( size[n]!='x' && size[n]!=0 )
    n_w[n] = size[n++];
  n++;
  while( size[n]!=0 )
    n_h[i++] = size[n++];
  width = atoi( n_w );
  height = atoi( n_h );
  printf("New size: %dx%d  (%s %s)\n", width, height, n_w, n_h );

  if( width<1 || height<1 || width>5000 || height>5000 )
    {
    printf("Illegal image size %dx%d\n", width, height );
    return;
    }

  result = Question("Change image size:","Do you want the image stretched",
                    "to fit page?","Yes, of course.","No, never.");
  if( !(result&1) )
    {
    Make_Empty_Image( &Fake_Image, width, height );
    stepx = ((float)One_Image[Cur_Image].width/(float)width);
    stepy = ((float)One_Image[Cur_Image].height/(float)height);
    /*printf("dbj 2 %f %f\n", stepx, stepy);*/
    for( y=0; y<height; y++ )
      {
      for( x=0; x<width; x++ )
        {
        Fake_Image.data.map_lines[y][x] =
          One_Image[Cur_Image].data.map_lines[(int)rint(ny)][(int)rint(nx)];
        nx+=stepx;
        }
      ny+=stepy;
      nx=0;
      }
    }
  else
    {
    result = Question("Do you want clip relative to", "top left corner of the window",
            "instead of top left corner of image?", "Yes, of course.",
            "No, never.");
    Make_Empty_Image( &Fake_Image, width, height );
    if( !(result&1) )
      {
      for( y=0; y<height; y++ )
        for( x=0; x<width; x++ )
          if( y-offs_Y[Cur_Image]<0 || y-offs_Y[Cur_Image]>=One_Image[Cur_Image].height ||
              x-offs_X[Cur_Image]<0 || x-offs_X[Cur_Image]>=One_Image[Cur_Image].width )
            Fake_Image.data.map_lines[y][x] = 0;
          else
            Fake_Image.data.map_lines[y][x] = One_Image[Cur_Image].data.map_lines[y-offs_Y[Cur_Image]][x-offs_X[Cur_Image]];
      if( offs_X[Cur_Image]<0 ) offs_X[Cur_Image] = 0; 
      if( offs_Y[Cur_Image]<0 ) offs_Y[Cur_Image] = 0; 
      }
    else
      for( y=0; y<height; y++ )
        for( x=0; x<width; x++ )
          if( y>=One_Image[Cur_Image].height || x>=One_Image[Cur_Image].width )
            Fake_Image.data.map_lines[y][x] = 0;
          else
            Fake_Image.data.map_lines[y][x] = One_Image[Cur_Image].data.map_lines[y][x]; 
  }

  if( -offs_X[Cur_Image]>width-20 )
    offs_X[Cur_Image] = 0;
  if( -offs_Y[Cur_Image]>height-20 )
    offs_Y[Cur_Image] = 0;
  free( One_Image[Cur_Image].Colour_Map );
  for( y=0; y<One_Image[Cur_Image].height; y++ )
    free( One_Image[Cur_Image].data.map_lines[y] );
  free( One_Image[Cur_Image].data.map_lines );
  MoveImageResponsibility( &Fake_Image, &One_Image[Cur_Image] );
  MakeImage( Cur_Image );

  Super_Refresh( Cur_Image );
}

SetImageOffset()
{
  unsigned char result;
  char offs[30]={""}, o_x[6], o_y[6], n_x[10], n_y[10];
  char guide[30]={"Current offset : "};
  short n=0, i=0, xx, yy;

  ConvertNroToString( offs_X[Cur_Image], &o_x, 0 );
  ConvertNroToString( offs_Y[Cur_Image], &o_y, 0 );
  AddToString( &guide, &o_x );
  AddToString( &guide, " x " );
  AddToString( &guide, &o_y );

  result = Get_String( &offs, guide );
  if( result&2 )
    {
    Refresh( Cur_Image );
    DrawPanel();
    }
  if( result&1 )
    return;

  while( offs[n]!='x' && offs[n]!=0 )
    n_x[n] = offs[n++];
  n++;
  while( offs[n]!=0 )
    n_y[i++] = offs[n++];
  xx = atoi( n_x );
  yy = atoi( n_y );
  printf("New offset: %dx%d  (%s %s)\n", xx, yy, n_x, n_y );

  if( -xx>One_Image[Cur_Image].width || -yy>One_Image[Cur_Image].height )
    {
    printf("ERROR!!!!: Illegal offset!\n");
    return;
    }

  offs_X[Cur_Image] = xx;
  offs_Y[Cur_Image] = yy;
  Refresh( Cur_Image );
}

GetWindowSize( w_width, w_height )
short *w_width, *w_height;
{
  XWindowAttributes theAttributes;

  XGetWindowAttributes( theDisplay, theWindow, &theAttributes );
  *w_width = theAttributes.width;
  *w_height = theAttributes.height;
}

AutoSetImageSize()
{
  short width, height, dx, dy, wx, hy, xx, yy, sx, sy;
  unsigned char result;

  GetWindowSize( &width, &height );
  height-=MARGIN;

  if( offs_X[Cur_Image]<0 || offs_Y[Cur_Image]<0 ||
      offs_X[Cur_Image]+One_Image[Cur_Image].width>width ||
      offs_Y[Cur_Image]+One_Image[Cur_Image].height>height )
    {
    result = Question( "Are you sure want to auto set",
                       "image size? Some parts of", "image will disappear!", 
                       "Yes, of course", "No, I'm not" );
    if( (result&1) )
      {
      if( (result&2) )
        {
        Refresh( Cur_Image );
        DrawPanel();
        }
      return;
      }
    }

  Make_Empty_Image( &Fake_Image, width, height );

  if( width-offs_X[Cur_Image]>0 && height-offs_Y[Cur_Image]>0 )
    { 
    if( offs_X[Cur_Image]>0 ) {
      dx = offs_X[Cur_Image];
      sx = 0;
      }
    else {
      dx = 0;
      sx = -offs_X[Cur_Image];
      }
    if( offs_Y[Cur_Image]>0 ) {
      dy = offs_Y[Cur_Image];
      sy = 0;
      }
    else {
      dy = 0;
      sy = -offs_Y[Cur_Image];
      }
    if( offs_X[Cur_Image]+One_Image[Cur_Image].width>width )
      wx = width-dx;
    else
      wx = One_Image[Cur_Image].width-sx;
    if( offs_Y[Cur_Image]+One_Image[Cur_Image].height>height )
      hy = height-dy;
    else
      hy = One_Image[Cur_Image].height-sy;
    printf("autosetimagesize: sx,sy    dx,dy    wx,hy\n");
    printf("                 %d,%d   %d,%d   %d,%d\n",sx,sy,dx,dy,wx,hy);
    for( yy=0; yy<hy; yy++ )
      for( xx=0; xx<wx; xx++ )
        Fake_Image.data.map_lines[dy+yy][dx+xx] =
                        One_Image[Cur_Image].data.map_lines[sy+yy][sx+xx];
    }

  free( One_Image[Cur_Image].Colour_Map );
  for( yy=0; yy<One_Image[Cur_Image].height; yy++ )
    free( One_Image[Cur_Image].data.map_lines[yy] );
  free( One_Image[Cur_Image].data.map_lines );

  MoveImageResponsibility( &Fake_Image, &One_Image[Cur_Image] );
  offs_X[Cur_Image] = 0;
  offs_Y[Cur_Image] = 0;
  MakeImage( Cur_Image );
  Super_Refresh( Cur_Image );
}
