/**********************************************************************
*                 mesg.c                                              *
*                                                                     *
*  Copyright (C) 1995 by Heikki Tienari. See tis.doc for more info.   *
*                                                                     *
*  This module contains code to view simple text messages             *
*  in the window.                                                     *
*                                                                     *
*  290395 -HT- Seems to work.                                         *
*  160595 -HT- Makefile support.                                      *
**********************************************************************/

#include <math.h>
#include <X11/Xlib.h>
#include "image.h"
#include "externs.h"

Mesg( msg1, msg2, msg3 )
char *msg1, *msg2, *msg3;
{
  XWindowAttributes theAttributes;
  short offx, offy;
  char fresh=0;

  XGetWindowAttributes( theDisplay, theWindow, &theAttributes );
  if( theAttributes.width<210 || theAttributes.height<110 )
    return(1);

  offx = (int)((float)theAttributes.width/2.0)-100;
  offy = (int)((float)theAttributes.height/2.0)-50;

  storage_block_xi = XGetImage(theDisplay, theWindow, offx, offy,
                               200+1, 100+1, 255, ZPixmap);

  XClearArea( theDisplay, theWindow, offx, offy, 200, 100, False );
  XFlush(theDisplay);

  Draw_Message( msg1, msg2, msg3, offx, offy );

  while(1)
    {
    XNextEvent( theDisplay, &theEvent );

    switch( theEvent.type )
      {
      case Expose:
        Draw_Message( msg1, msg2, msg3, offx, offy );
        fresh=2;
        break;
      case ConfigureNotify:
        XGetWindowAttributes( theDisplay, theWindow, &theAttributes );
        if( theAttributes.width<210 || theAttributes.height<110 )
          {
          XPutImage(theDisplay, theWindow, theGC, storage_block_xi,
                    0, 0, offx, offy, 200+1, 100+1 );
          return( 1|fresh );
          }
        break;
      case KeyPress:
        if( theEvent.xkey.keycode==36 )
          {
          printf("OK\n");
          XPutImage(theDisplay, theWindow, theGC, storage_block_xi,
                    0, 0, offx, offy, 200+1, 100+1 );
          return( 0|fresh );
          }
        break;
      case ButtonPress:
        if( theEvent.xbutton.x>offx+20 && theEvent.xbutton.x<offx+180 &&
            theEvent.xbutton.y>offy+65 && theEvent.xbutton.y<offy+85 )
          {
          printf("OK\n");
          XPutImage(theDisplay, theWindow, theGC, storage_block_xi,
                    0, 0, offx, offy, 200+1, 100+1 );
          return( 0|fresh );
          }
        break;
      }
    }
}

Draw_Message( msg1, msg2, msg3, offx, offy )
char *msg1, *msg2, *msg3;
short offx, offy;
{
  short btx;

  XSetForeground( theDisplay, theGC, theBlackPixel );
  XDrawRectangle( theDisplay, theWindow, theGC, offx, offy, 200, 100 );
  XDrawRectangle( theDisplay, theWindow, theGC, offx+20, offy+65, 160, 20 );
  XDrawString( theDisplay, theWindow, theGC, offx+20, offy+20, msg1, strlen(msg1) );  
  XDrawString( theDisplay, theWindow, theGC, offx+20, offy+40, msg2, strlen(msg2) );
  btx = offx+100-(int)((float)strlen(msg3)/2.0)*7;
  XDrawString( theDisplay, theWindow, theGC, btx, offy+80, msg3, strlen(msg3) );
  XFlush(theDisplay);
}

