/*********************************************************************
*                  get_string.c                                      *
*                                                                    *
*  Copyright (C) 1995 by Heikki Tienari. See tis.doc for more info.  *
*                                                                    *
*  This module contains code to handle Get_String() widget/gadget    *
*  or what ever.                                                     *
*                                                                    *
*  260395 -HT- Works.                                                *
*  270395 -HT- Something new.                                        *
*  290395 -HT- A few new things.                                     *
*  200495 -HT- Text moved to left.                                   *
*  160595 -HT- Makefile support.                                     *
*********************************************************************/

#include <math.h>
#include <X11/Xlib.h>
#include "image.h"
#include "externs.h"

/*
* result = Get_String( &string, &mesg_string );
*
*  result:  first byte:  0 = OK
*                        1 = Cancel or error
*           second byte: 0 = no need to refresh
*                        1 = need to refresh
*/   

#define LENGTH 30

Get_String( name, mesg )
char *name, *mesg;
{
  XWindowAttributes theAttributes;
  short offx, offy, tpos=-1;
  char letter, fresh=0, vpos=0, i;

  XGetWindowAttributes( theDisplay, theWindow, &theAttributes );
  if( theAttributes.width<210 || theAttributes.height<110 )
    return(1);

  offx = (int)((float)theAttributes.width/2.0)-100;
  offy = (int)((float)theAttributes.height/2.0)-50;

  storage_block_xi = XGetImage(theDisplay, theWindow, offx, offy,
                               200+1, 100+1, 255, ZPixmap);

  XClearArea( theDisplay, theWindow, offx, offy, 200, 100, False );
  XFlush(theDisplay);

  Draw_GetString( name, mesg, offx, offy );

  XDrawLine( theDisplay, theWindow, theGC, offx+25, offy+35, offx+25, offy+45 );

  while(1)
    {
    XNextEvent( theDisplay, &theEvent );

    switch( theEvent.type )
      {
      case Expose:
        Draw_GetString( name, mesg, offx, offy );
        fresh=2;
        break;
      case ConfigureNotify:
        XGetWindowAttributes( theDisplay, theWindow, &theAttributes );
        if( theAttributes.width<210 || theAttributes.height<110 )
          {
          XPutImage(theDisplay, theWindow, theGC, storage_block_xi,
                    0, 0, offx, offy, 200+1, 100+1 );
          return( 1|fresh );
          }
        break;
      case KeyPress:
        letter = XKeycodeToKeysym(theDisplay, theEvent.xkey.keycode
                                  ,theEvent.xkey.state);
        /*printf("key: %d\n", theEvent.xkey.keycode );*/
        if( theEvent.xkey.keycode==22 && tpos>=0 )
          {
          name[tpos]=0;
          tpos--;
          if( vpos>0 )
            {
            vpos--;
            XClearArea( theDisplay, theWindow, offx+25+7*vpos, offy+31, 8, 18, False );
            XFlush(theDisplay);
            XDrawLine( theDisplay, theWindow, theGC, offx+25+7*vpos, 
                       offy+35, offx+25+7*vpos, offy+45 );
            }
          else
            {
            XClearArea( theDisplay, theWindow, offx+21, offy+31, 155, 18, False );
            vpos=15;
            for( i=0; i<15; i++ )
            XDrawString( theDisplay, theWindow, theGC, offx+25+7*i, offy+44, &name[tpos-14+i], 1 );
            XDrawLine( theDisplay, theWindow, theGC, offx+25+7*vpos, 
                       offy+35, offx+25+7*vpos, offy+45 );
            }
          }
        if( letter>31 && letter<127 && tpos<LENGTH )
          {
          /*printf("letter: %c\n",letter);*/
          tpos++;
          name[tpos]=letter;
          if( vpos>20 )
            {
            XSetForeground( theDisplay, theGC, theBlackPixel );
            XClearArea( theDisplay, theWindow, offx+21, offy+31, 155, 18, False );
            XFlush(theDisplay);
            vpos=5;
            for( i=0; i<5; i++ )
            XDrawString( theDisplay, theWindow, theGC, offx+25+7*i, offy+44, &name[tpos-5+i], 1 );
            }
          else
            {
          XSetForeground( theDisplay, theGC, theWhitePixel );
          XDrawLine( theDisplay, theWindow, theGC, offx+25+7*vpos, 
                     offy+35, offx+25+7*vpos, offy+45 );
            }
          XSetForeground( theDisplay, theGC, theBlackPixel );
          XDrawString( theDisplay, theWindow, theGC, offx+25+7*vpos, offy+44, &letter, 1 );
          vpos+=1;
          XDrawLine( theDisplay, theWindow, theGC, offx+25+7*vpos, offy+35, 
                    offx+25+7*vpos, offy+45 );
          }
        if( theEvent.xkey.keycode==36 )
          {
          printf("OK\n");
          XPutImage(theDisplay, theWindow, theGC, storage_block_xi,
                    0, 0, offx, offy, 200+1, 100+1 );
          return( 0|fresh );
          }
        if( theEvent.xkey.keycode==9 )
          {
          printf("Cancel\n");
          XPutImage(theDisplay, theWindow, theGC, storage_block_xi,
                    0, 0, offx, offy, 200+1, 100+1 );
          return( 1|fresh );
          }
        break;
      case ButtonPress:
        if( theEvent.xbutton.x>offx+20 && theEvent.xbutton.x<offx+90 &&
            theEvent.xbutton.y>offy+65 && theEvent.xbutton.y<offy+85 )
          {
          printf("OK\n");
          XPutImage(theDisplay, theWindow, theGC, storage_block_xi,
                    0, 0, offx, offy, 200+1, 100+1 );
          return( 0|fresh );
          }
        if( theEvent.xbutton.x>offx+110 && theEvent.xbutton.x<offx+180 &&
            theEvent.xbutton.y>offy+65 && theEvent.xbutton.y<offy+85 )
          {
          printf("Cancel\n");
          XPutImage(theDisplay, theWindow, theGC, storage_block_xi,
                    0, 0, offx, offy, 200+1, 100+1 );
          return( 1|fresh );
          }
        break;
      }
    }
}

Draw_GetString( name, mesg, offx, offy )
char *name, *mesg;
short offx, offy;
{
  XSetForeground( theDisplay, theGC, theBlackPixel );
  XDrawRectangle( theDisplay, theWindow, theGC, offx, offy, 200, 100 );
  XDrawRectangle( theDisplay, theWindow, theGC, offx+20, offy+30, 160, 20 );
  XDrawRectangle( theDisplay, theWindow, theGC, offx+20, offy+65, 70, 20 );
  XDrawRectangle( theDisplay, theWindow, theGC, offx+110, offy+65, 70, 20 );
  XDrawString( theDisplay, theWindow, theGC, offx+20, offy+18, mesg, strlen(mesg) );
  XDrawString( theDisplay, theWindow, theGC, offx+50, offy+80, "OK", 2 );
  XDrawString( theDisplay, theWindow, theGC, offx+130, offy+80, "Cancel", 6 );
  XFlush(theDisplay);
}
