#import "aGroup-inter.h"
#import "aGroup.h"
#import "pmg.h"

@implementation pmg
- resizeGenerator
{
  latticesize.height = 4.0* bounds.size.height;
  latticesize.width = bounds.size.width;
  upx = 0;
  upy = latticesize.height;
  overx = latticesize.width;
  gravy = upy/2;
  gravx = (upx+overx)/2;
  return self;
}

- makeLatticeUnitAt: (NXPoint *) point fromImage: srcimg 
{
  id imgrep;
  NXPoint pt;
  
  pt.x = - point->x ;
  pt.y = - point->y ;
  imgrep = [srcimg bestRepresentation];
  PSgsave(); // bottom
  [self clip:0.0:0.0];[imgrep drawAt: &pt];
  PSgrestore();
  PSgsave(); // bottom middle
  reflect(0.0);
  PStranslate(0,-2*bounds.size.height);
  [self clip:0.0:0.0]; [imgrep drawAt: &pt];
  PSgrestore();
  PSgsave(); // top top
  PSrotate(180);
  PStranslate(-overx,-upy);
  [self clip:0.0:0.0]; [imgrep drawAt: &pt];
  PSgrestore();
  PSgsave();// top mid
  reflect(0.0);
  PSrotate(180);
  PStranslate(-bounds.size.width,2*bounds.size.height);
  [self clip:0.0:0.0]; [imgrep drawAt: &pt];
  PSgrestore();
  return self;
}
@end
