#import "aGroup-inter.h"
#import "aGroup.h"
#import "cmm.h"

@implementation cmm
- resizeGenerator
{
  latticesize.height = frame.size.height;
  latticesize.width = 2.0 * frame.size.width;
  upx = frame.size.width;
  upy = latticesize.height ;
  overx = latticesize.width;
  gravy = 0.0;
  gravx = frame.size.width;
  return self;
}

- clip: (NXCoord) x: (NXCoord) y 
{ 
  PSmoveto(x,y);
  PSrlineto(0,bounds.size.height);
  PSrlineto(bounds.size.width,-bounds.size.height);
  PSclosepath();
  PSclip();
  return self;
}

- makeLatticeUnitAt: (NXPoint *) point fromImage: srcimg 
{
  id imgrep;
  NXPoint pt;
  
  pt.x = - point->x ;
  pt.y = - point->y ;
  imgrep = [srcimg bestRepresentation];
  PSgsave();
  [self clip:0.0:0.0];
  [imgrep drawAt: &pt];
  PSgrestore();
  PSgsave();
  reflect(0.0);
  [self clip:0.0:0.0];
  [imgrep drawAt: &pt];
  PSgrestore();
  PSgsave();
  reflect(90.0);
  [self clip:0.0:0.0];
  [imgrep drawAt: &pt];
  PSgrestore();
  PSgsave();
  PSrotate(180.0);
  [self clip:0.0:0.0];
  [imgrep drawAt: &pt];
  PSgrestore();
  return self;
}
@end
