/**
 ** sipp - SImple Polygon Processor
 **
 **  A general 3d graphic package
 **
 **  Copyright Jonas Yngvesson  (jonas-y@isy.liu.se) 1988/89/90/91
 **            Inge Wallin      (ingwa@isy.liu.se)         1990/91
 **
 ** This program is free software; you can redistribute it and/or modify
 ** it under the terms of the GNU General Public License as published by
 ** the Free Software Foundation; either version 1, or any later version.
 ** This program is distributed in the hope that it will be useful,
 ** but WITHOUT ANY WARRANTY; without even the implied warranty of
 ** MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 ** GNU General Public License for more details.
 ** You can receive a copy of the GNU General Public License from the
 ** Free Software Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 **/

/**
 ** bumpy.c - Bumpy shader: simulates an bumpy surfaces using noise and Dnoise
 **/

#include <math.h>
#include <stdio.h>

#include <sipp.h>
#include <geometric.h>
#include <noise.h>
#include <shaders.h>


extern bool noise_ready;


void
bumpy_shader(nx, ny, nz, u, v, w, view_vec, lights, bd, color)
    double        nx, ny, nz;
    double        u, v, w;
    Vector        view_vec;
    Lightsource  *lights;
    Bumpy_desc   *bd;
    Color        *color;
{
    Vector     tmp;
    double     len;
    double     no;

    if (!noise_ready) {
        noise_init();
    }

    tmp.x = u * bd->scale;
    tmp.y = v * bd->scale;
    tmp.z = w * bd->scale;

    if ((bd->bumpflag && bd->holeflag)
          || ((no = noise(&tmp)) < 0.0 && bd->bumpflag)
          || (no > 0.0 && bd->holeflag)) {
        tmp = Dnoise(&tmp);
        len = sqrt(nx * nx + ny * ny + nz * nz);
        nx = nx / len + tmp.x;
        ny = ny / len + tmp.y;
        nz = nz / len + tmp.z;
    }

    bd->shader(nx, ny, nz, u, v, w, view_vec, lights, bd->surface, color);
}
