.\" Copyright 1990, Jonas Yngvesson, Inge Wallin
.\" This program and documentation may be distributed freely under
.\" the terms of GNU GENERAL PUBLIC LICENSE.
.TH PRIMITIVES 3X "December , 1990" 3X
.SH NAME
primitives - a collection of object primitives for \fIsipp\fR.
.SH SYNOPSIS
\fI#include <primitives.h>\fR
.sp
[g]cc [\fIflags\fR] \fIfiles\fR -lsipp -lm [ \fIlibraries\fR ]

.SH DESCRIPTION
\fIsipp\fR gives the user access to a number of rather low level functions
to create polygons, surfaces and objects. This manual describes a set of
functions that use the low level functions in \fIsipp\fR to create
geometric primitives. Each primitive is a complete \fIsipp\fR object.
.sp
All primitives described here will get texture coordinates equal to the
respective world coordinates.

.SH PRIMITIVES
.IP \fIObject\ *sipp_torus(bigradius,\ smallradius,\ res1,\ res2,\ surface,\ shader)\fR
.br
\fIdouble\  bigradius;\fR
.br
\fIdouble\  smallradius;\fR
.br
\fIint\     res1;\fR
.br
\fIint\     res2;\fR
.br
\fIvoid\   *surface;\fR
.br
\fIShader\ *shader;\fR
.sp
\fIsipp_torus()\fR creates a torus centered about the origin and with the
z-axis pointing up through the ring. \fIbigradius\fR is the radius of the
ring and \fIsmallradius\fR is the radius of the "tube" itself. \fIres1\fR
is the number of polygons that will be created radially around the ring
and \fIres2\fR is the number of polygons that will be created around the
tube. \fIsurface\fR is the surface description used by \fIshader()\fR
which is the shading function used when shading the torus.

.IP \fIObject\ *sipp_cone(bot_rad,\ ,top_rad,\ length,\ resolution,\ surface,\ shader)\fR
.br
\fIdouble\  bot_rad;\fR
.br
\fIdouble\  top_rad;\fR
.br
\fIdouble\  length;\fR
.br
\fIint\     resolution;\fR
.br
\fIvoid\   *surface;\fR
.br
\fIShader\ *shader;\fR
.sp
\fIsipp_cone()\fR creates a cone centered about the origin and with the z-axis
along the cones main axis. \fIbot_rad\fR and \fItop_rad\fR determines the
radius of the cone in its bottom and top, if both of these are non zero a
truncated cone is created. \fIlength\fR defines the length of the cone.
\fIresolution\fR is the number of polygons that will be created radially
around the rim.  \fIsurface\fR is the surface description used by
\fIshader()\fR which is the shading function used when shading the cone.

.IP \fIObject\ *sipp_cylinder(radius,\ length,\ resolution,\ surface,\ shader)\fR
.br
\fIdouble\  radius;\fR
.br
\fIdouble\  length;\fR
.br
\fIint\     resolution;\fR
.br
\fIvoid\   *surface;\fR
.br
\fIShader\ *shader;\fR
.sp
\fIsipp_cylinder()\fR creates a cylinder centered about the origin and with the
z-axis along the cylinders main axis. \fIradius\fR and \fIlength\fR
defines the size of the cylinder. \fIresolution\fR
is the number of polygons that will be created radially around the rim.
\fIsurface\fR is the surface description used by \fIshader()\fR
which is the shading function used when shading the cylinder.

.IP \fIObject\ *sipp_ellipsoid(x_rad,\ y_rad,\ z_rad,\ resolution,\ surface,\ shader)\fR
.br
\fIdouble\  x_rad;\fR
.br
\fIdouble\  y_rad;\fR
.br
\fIdouble\  z_rad;\fR
.br
\fIint\     resolution;\fR
.br
\fIvoid\   *surface;\fR
.br
\fIShader\ *shader;\fR
.sp
\fIsipp_ellipsoid()\fR creates a ellipsoid centered about the origin.
\fIx_rad\fR, \fIy_rad\fR and \fIz_rad\fR
defines the size of the ellipsoid. \fIresolution\fR
is the number of polygons that will be created around it's "equator".
\fIsurface\fR is the surface description used by \fIshader()\fR
which is the shading function used when shading the ellipsoid.

.IP \fIObject\ *sipp_sphere(radius,\ resolution,\ surface,\ shader)\fR
.br
\fIdouble\  radius;\fR
.br
\fIint\     resolution;\fR
.br
\fIvoid\   *surface;\fR
.br
\fIShader\ *shader;\fR
.sp
\fIsipp_sphere()\fR creates a sphere centered about the origin.
\fIradius\fR defines the size of the sphere. \fIresolution\fR
is the number of polygons that will be created around it's "equator".
\fIsurface\fR is the surface description used by \fIshader()\fR
which is the shading function used when shading the sphere.

.IP \fIObject\ *sipp_prism(num_points,\ points,\ length,\ surface,\ shader)\fR
.br
\fIint\     num_points;\fR
.br
\fIVector\ *points;\fR
.br
\fIdouble\  length;\fR
.br
\fIvoid\   *surface;\fR
.br
\fIShader\ *shader;\fR
.sp
\fIsipp_prism()\fR creates a prism defined by the polygon in
\fIpoints\fR. Only the x and y values are used and the prism will
ascend and descend equally far (\fIlength\fR / 2.0) from the x-y plane
along the z axis.  The number of points in the polygon is determined
by \fInum_points\fR.  \fIsurface\fR is the surface description used by
\fIshader()\fR which is the shading function used when shading the
prism.

.IP \fIObject\ *sipp_block(x_size,\ y_size,\ z_size,\ surface,\ shader)\fR
.br
\fIdouble\  x_size;\fR
.br
\fIdouble\  y_size;\fR
.br
\fIdouble\  z_size;\fR
.br
\fIvoid\   *surface;\fR
.br
\fIShader\ *shader;\fR
.sp
\fIsipp_block()\fR creates a square block with the size defined by
\fIx_size\fR, \fIz_size\fR and \fIz_size\fR. The block is centered
about the origin. \fIsurface\fR is the surface description used by
\fIshader()\fR which is the shading function used when shading the
block.

.IP \fIObject\ *sipp_cube(side,\ surface,\ shader)\fR
.br
\fIdouble\  side;\fR
.br
\fIvoid\   *surface;\fR
.br
\fIShader\ *shader;\fR
.sp
\fIsipp_cube()\fR creates a cube with the side of length \fIside\fR.  The
cube is centered about the origin. \fIsurface\fR is the surface description
used by \fIshader()\fR which is the shading function used when shading the
cube.

.IP \fIObject\ *sipp_bezier(file,\ res,\ surface,\ shader)\fR
.br
\fIFILE\   *file;\fR
.br
\fIint\     res;\fR
.br
\fIvoid\   *surface;\fR
.br
\fIShader\ *shader;\fR
.sp
\fIsipp_bezier()\fR reads a file containing descriptions of a set of bezier
patches or bezier curves. If the file contains descriptions of patches, these
patches will be tesselated into \fIres\fR by \fIres\fR polygons and installed
in a \fIsipp\fR object as one surface. The surface will be shaded by
\fIshader\fR using the surface description \fIsurface\fR.
.sp
If the file contains descriptions of curves, a rotational surface will be
created by rotating these curves about the y-axis. The resulting surface will
be tesselated into polygons and installed in a \fIsipp\fR object as one
surface. The surface will be shaded by \fIshader\fR using the surface
description \fIsurface\fR.
.sp
The format of the description file is rather simple. First a keyword defining
the type of description in the file, \fIbezier_curves:\fR or
\fIbezier_patches:\fR. Then follows a description of the vertices (control
points). First the word \fIvertices:\fR followed by an integer number that
tells how many vertices there are in the description, then the word
\fIvertex_list:\fR followed by the x, y and z coordinates for each vertex. The
number of vertices must be same as the number given above. This is, however,
not checked for. 
.sp
If the file contains curves, the keyword \fIcurves:\fR followed by the number
of bezier curves in the file stand on the next line. After this line, a line
with the single keyword \fIcurve_list:\fR follows. Lastly, the bezier curves
themselves follow as numbers in groups of four by four. Each number is an
index into the vertex list with the first index having number 1.
.sp
If the file contains patches, the format is the same with the following
exceptions: The word \fIpatches:\fR is substituted for \fIcurves:\fR, the word
\fIpatch_list:\fR is substituted for \fIcurve_list:\fR and the indices into
the vertex list are grouped 16 by 16 instead of 4 by 4.
.sp
Comments can be inserted anywhere in a bezier curve/patch description file by
using the hashmark character, #. The comment lasts to the end of the line.
.sp
See any standard computer graphics reference, e.g. Newman & Sproull, for a
more detailed description of Bezier curves and patches.
.sp
Example: the body of a standard Newell teapot.
.sp
.nf
# Bezier curves (rotational body) for teapot body.

bezier_curves:

vertices: 10
vertex_list:
    3.500000E-01    5.625000E-01    0.000000E+00
    3.343750E-01    5.953125E-01    0.000000E+00
    3.593750E-01    5.953125E-01    0.000000E+00
    3.750000E-01    5.625000E-01    0.000000E+00
    4.375000E-01    4.312500E-01    0.000000E+00
    5.000000E-01    3.000000E-01    0.000000E+00
    5.000000E-01    1.875000E-01    0.000000E+00
    5.000000E-01    7.500000E-02    0.000000E+00
    3.750000E-01    1.875000E-02    0.000000E+00
    3.750000E-01    0.000000E+00    0.000000E+00

curves:    3
curve_list:

  1 2 3 4

  4 5 6 7

  7 8 9 10

#End of teapot bezier file
.fi

.SH SEE ALSO
sipp(3X) - simple polygon processor, a 3d-graphics library
.br
shaders(3X) - a collection of shaders for \fIsipp\fR.
.br
geometric(3X) - Vector and matrix functions for the sipp(3X) library
.br
sipp_pixmap(3X) - pixmap handling code for \fIsipp\fR.
.br
sipp_bitmap(3X) - bitmap handling code for \fIsipp\fR.

.SH AUTHORS
Jonas Yngvesson\	\	(jonas-y@isy.liu.se)
.br
Inge Wallin\		(ingwa@isy.liu.se)

.SH BUGS
The format for the bezier patches and curves is prohibitively ugly.
