#include <stdio.h>
#include <math.h>

#include <sipp.h>
#include <primitives.h>
#include <shaders.h>



#define SUBDIVS  20

main(argc, argv)
    int    argc;
    char **argv;
{
    Surf_desc   planet_surface;
    Object     *planet;
    FILE       *outfile;
    int         size;

    if (argc == 2) {
        size = atoi(argv[1]);
    } else {
        size = 256;
    }
    
    planet_surface.ambient = 0.4;
    planet_surface.specular = 0.0;
    planet_surface.c3 = 0.5;
    planet_surface.color.red = 1.0;
    planet_surface.color.grn = 0.0;
    planet_surface.color.blu = 0.0;

    sipp_init();

    lightsource_push(1.0, 1.0, 1.0, 1.0);

    object_install(sipp_sphere(1.0, SUBDIVS, &planet_surface, planet_shader)); 

    viewpoint(0.0, 2.0, 0.0,  0.0, 0.0, 0.0,  0.0, 0.0, 1.0,  0.75);

    outfile = fopen("planet.ppm", "w");
    render_image(size, size, outfile);
}

