/* pcdispla.c      Distribution 1.2   91/1/28   Scry */

/*   The Scry system is copyright (C) 1988-1991 Regents  of  the
University  of  California.   Anyone may reproduce ``Scry'',
the software in this distribution, in whole or in part, pro-
vided that:

(1)  Any copy  or  redistribution  of  Scry  must  show  the
     Regents  of  the  University of California, through its
     Lawrence Berkeley Laboratory, as the source,  and  must
     include this notice;

(2)  Any use of this software must reference this  distribu-
     tion,  state that the software copyright is held by the
     Regents of the University of California, and  that  the
     software is used by their permission.

     It is acknowledged that the U.S. Government has  rights
in  Scry  under  Contract DE-AC03-765F00098 between the U.S.
Department of Energy and the University of California.

     Scry is provided as a professional  academic  contribu-
tion  for  joint exchange.  Thus it is experimental, is pro-
vided ``as is'', with no warranties of any kind  whatsoever,
no  support,  promise  of updates, or printed documentation.
The Regents of the University of California  shall  have  no
liability  with respect to the infringement of copyrights by
Scry, or any part thereof. */

/* Part of server RPC library.  Routines to decompress (if necessary) and
   display information contained in software frame buffer.  */

#include <stdio.h>
#include "scrysrv.h"
#include "image.h"


/* display_frame:  optionally decompresses, displays in PC frame buffer,
		   and optionally records on videodisk */

struct mapstore map ;		/* color map */
struct image_stuff image_info ;	/* image data */
    /* centering information needed if incoming image is smaller than frame
       buffer resolution */
int center_x_left ;
int center_y_bottom, center_y_top ;

    /* border color (values can range from 0 to 255) */
unsigned char back_red = 0 ;
unsigned char back_green = 0 ;
unsigned char back_blue = 0 ;

#define MAX_CAN_READ 32764

display_frame (transp)

register SVCXPRT *transp ;	/* RPC transport handle */

{
    int temp_total ;
    bool_t xdr_udata() ;
    bool_t xdr_qdata() ;

	/* get incoming image information (height, etc.) */
    if (!svc_getargs(transp,xdr_prelim,&image_info))
    {
        svcerr_decode(transp) ;
        return(0) ;
    }

    /* bugs to fix for 1.3 */
    if ((image_info.compression & LEMPEL_ZIV) &&
        (image_info.compression & CCC) && (image_info.total > MAX_CAN_READ))
    {
	fprintf (stderr,"Scry bug:  can't read in over 32K data with \
		 the use of CCC and LEMPEL_ZIV compression\n") ;
        return(0) ;
    }
    if ((image_info.compression & QUANTIZE) &&
	(image_info.compression & LEMPEL_ZIV))
    {
	fprintf (stderr,"Scry bug:  can't read in lzw compressed \
		 8-bit data; use QUANTIZE by itself") ;
        return(0) ;
    }

#ifdef DEBUG
    printf ("in display_frame %ld %d %ld %d\n",image_info.client_wd,
             image_info.width,image_info.client_ht,image_info.height) ;
#endif
        /* if incoming image smaller than server display resolution */
    if (image_info.client_wd < image_info.width)
    {
        center_x_left = (int) (image_info.width - image_info.client_wd) / 2 ;
        center_x_left -= (center_x_left % 4) ;
    }
    else
        center_x_left = 0 ;
    if (image_info.client_ht < image_info.height)
    {
        center_y_bottom = (int) (image_info.height - image_info.client_ht) / 2 ;
        center_y_top = (int) image_info.height - center_y_bottom ;
    }
    else
    {
        center_y_bottom = 0 ;
        center_y_top = (int) image_info.height ;
    }

    if (image_info.compression == NONE)
    {
	    /* receive and display uncompressed image */
        if (!svc_getargs(transp,xdr_udata,&image_info))
        {
            svcerr_decode(transp) ;
            return(0) ;
        }
    }
    else
	    /* get color map */
        if (!svc_getargs(transp,xdr_map,&map))
        {
            svcerr_decode(transp) ;
            return(0) ;
        }

        /* if a final step of Lempel-Ziv compression has been performed */
    if (image_info.compression & LEMPEL_ZIV)        
    {
        temp_total = image_info.total ;
        image_info.total = image_info.total_lz ;
	    /* get buffer */
        if (!svc_getargs(transp,xdr_get_lzw,&image_info))
        {
             svcerr_decode(transp) ;
             return(0) ;
        }
	    /* LZW decompress */
	lzw_decomp(image_info.data,&(image_info.total)) ;
        image_info.total = temp_total ;
    }
	/* if 8-bit incoming image */
    if (image_info.compression & QUANTIZE) 
    {
	    /* receive and display */
        if (!svc_getargs(transp,xdr_qdata,&image_info))
        {
            svcerr_decode(transp) ;
            return(0) ;
        }
    }
    if (image_info.compression & CCC)
    {
	    /* receive, decompress, and display */
        if (!svc_getargs(transp,xdr_ccc_decompress,&image_info))
        {
            svcerr_decode(transp) ;
            return(0) ;
        }
    }
        /* if record mode, record on videodisk */
    if (record_on && (image_info.in_at != 0))
        if (!record_frame(image_info.in_at,image_info.out_at))
            return (0) ;

	 /* send acknowledgement:  allow client to continue */
    if (svc_sendreply (transp,xdr_void,0) == 0)
    {
	fprintf (stderr, "err: rpc_service\n") ;
	return(0) ;
    }

    return (1) ;
}
