/* targa16.c      Distribution 1.2   91/1/28   Scry */

/*   The Scry system is copyright (C) 1988-1991 Regents  of  the
University  of  California.   Anyone may reproduce ``Scry'',
the software in this distribution, in whole or in part, pro-
vided that:

(1)  Any copy  or  redistribution  of  Scry  must  show  the
     Regents  of  the  University of California, through its
     Lawrence Berkeley Laboratory, as the source,  and  must
     include this notice;

(2)  Any use of this software must reference this  distribu-
     tion,  state that the software copyright is held by the
     Regents of the University of California, and  that  the
     software is used by their permission.

     It is acknowledged that the U.S. Government has  rights
in  Scry  under  Contract DE-AC03-765F00098 between the U.S.
Department of Energy and the University of California.

     Scry is provided as a professional  academic  contribu-
tion  for  joint exchange.  Thus it is experimental, is pro-
vided ``as is'', with no warranties of any kind  whatsoever,
no  support,  promise  of updates, or printed documentation.
The Regents of the University of California  shall  have  no
liability  with respect to the infringement of copyrights by
Scry, or any part thereof. */

/* TARGA 16 routines */

/* init_display:  initializes TARGA 16 board
   clear_display:  clears frame buffer */


#include        <memory.h>
#include        <stdio.h>
#include	"image.h"
#include        <tardev.h>    /* TARGA include file - large memory model */


#define         OVERLAY 0               /* overlay mode off        */ 

extern struct TARStruct *targa;


/* initializes TARGA 16 board */

int
init_display()

{
    if (GraphInit(TYPE_16))
    {
	perror("GraphInit failed - check I/O space configuration\n") ;
	return(0) ;
    }
    GetScrSize(&(image_info.width),&(image_info.height)) ;
    ++image_info.width ;
    ++image_info.height ;
#ifdef DEBUG
    fprintf (stderr,"%d %d\n",image_info.width,image_info.height) ;
#endif
    image_info.depth = 2 ;
	/* clear to grey */
    clear_display(15, 15, 18) ;
    return (1) ;
}



/*  erases the display to the color combination specified by 
    r, g, and b.  Note that the values of r, g, and b must range 
    from 0 to 255. */

clear_display(r, g, b)

unsigned int r, g, b;    /* red, green, and blue values */

{
    unsigned int r_16, g_16, b_16 ;
    short color;        /* color of screen after erase */
    unsigned short one[2048] ;         /* one scan lines */
    unsigned short *oneptr ;
    unsigned short i ;

        /* convert to 5 bits RGB */
    r_16 = r >> 3 ;
    g_16 = g >> 3 ;
    b_16 = b >> 3 ;
        /* get color in TARGA format */
    PackColor(&color, r_16, g_16, b_16, OVERLAY, 0);
    oneptr = one ;
        /* set four scan lines to color */
    for(i = 0; i < image_info.width; i++)
        *oneptr++ = color ;
            /* for all scan lines */
    for(i = 0; i < image_info.height ; i++)
        PutRow (one,0,image_info.width-1,image_info.height-i-1,-1);
}
