/* anima_write.c      Distribution 1.2   91/1/28   Scry */

/*   The Scry system is copyright (C) 1988-1991 Regents  of  the
University  of  California.   Anyone may reproduce ``Scry'',
the software in this distribution, in whole or in part, pro-
vided that:

(1)  Any copy  or  redistribution  of  Scry  must  show  the
     Regents  of  the  University of California, through its
     Lawrence Berkeley Laboratory, as the source,  and  must
     include this notice;

(2)  Any use of this software must reference this  distribu-
     tion,  state that the software copyright is held by the
     Regents of the University of California, and  that  the
     software is used by their permission.

     It is acknowledged that the U.S. Government has  rights
in  Scry  under  Contract DE-AC03-765F00098 between the U.S.
Department of Energy and the University of California.

     Scry is provided as a professional  academic  contribu-
tion  for  joint exchange.  Thus it is experimental, is pro-
vided ``as is'', with no warranties of any kind  whatsoever,
no  support,  promise  of updates, or printed documentation.
The Regents of the University of California  shall  have  no
liability  with respect to the infringement of copyrights by
Scry, or any part thereof. */


#include <stdio.h>
#include <scry_anima.h>
#include <scry_image.h>
#include <scry_client.h>
#include <scry_limits.h>


/* scry_set_filename:	set name of Anima file to be saved on
			client or server
   scry_save_anima:	write out Anima frame   */



/* set name of Anima file.  It will be saved on the client
   if the client handle (for a connection with a server) is
   NULL, otherwise on the server. */

scry_set_filename (filename,total_frames)

unsigned char *filename ;
int total_frames ;

{
    int saveflag = 0 ;
    int i ;

    if (filename == NULL)
    {
	fprintf (stderr,"scry_set_filename:  NULL filename given\n") ;
	exit(0) ;
    }
    if ((total_frames < 1) || (total_frames > 100000))
    {
	fprintf (stderr,"scry_set_filename:  %d is an illegal number of frames\n",total_frames) ;
	exit(0) ;
    }
    strcpy(S_anima_filename,filename) ;
       /* if connection open */
    if (S_client != NULL)
    {
	    /* communicate file name to server */
	sc_send_file(S_anima_filename,total_frames) ;
	    /* only CCC or CCC | LEMPEL_ZIV legal */
	if (S_image_info.compression & S_LEMPEL_ZIV)
	    saveflag = S_LEMPEL_ZIV ;
	S_image_info.compression = S_CCC | saveflag ;
    }
    else	/* save locally */
    {
        if (S_anima_file != NULL)
        {
	        /* if something there, write footer and reinitialize
		   footer variables */
            if (S_anima_bytes != 0)
            {
#ifdef MESSAGES
	        fprintf (stderr,"writing anima footer\n") ;
#endif
                anima_write_footer(S_anima_file) ;
                S_anima_bytes = 0 ;
                for (i = 0 ; i < S_anima_count ; i++)
                {
                    S_a_index[i].offset = 0 ;
                    S_a_index[i].buf_total = 0 ;
                }
                S_anima_count = 0 ;
		fclose(S_anima_file) ;
            }
            else
                unlink(S_anima_filename) ;
	}
        S_anima_file = NULL ;
        S_anima_file = fopen(filename,"w") ;
        printf ("opening anima file %s\n",S_anima_filename) ;
        if (S_a_index == NULL)
            S_a_index = (struct footer *)malloc(total_frames*sizeof(struct footer)) ;
        else
            S_a_index = (struct footer *) realloc((char *)S_a_index,total_frames*sizeof(struct footer)) ;
		/* only CCC legal */
	S_image_info.compression = S_CCC ;
    }
}


/* write out image as Anima frame */

scry_save_anima (rawimage,height,width,depth)

unsigned char *rawimage ;
int height ;
int width ;
int depth ;

{
    unsigned char *sc_compress() ;
    unsigned char *compdata ;
    unsigned char *convert_to_3() ;
    unsigned char *newimage ;
    int datasize ;
    int new_ht ;
    int new_wd ;
    char format[80] ;

    if (rawimage == NULL)
    {
	fprintf (stderr,"scry_save_anima:  space for image has not been allocated\n") ;
	scry_close() ;
	exit(0) ;
    }
    if ((height < 1) || (height > S_MAX_IMAGE_HEIGHT))
    {
	fprintf (stderr,"scry_save_anima:  height of %d is illegal\n",height) ;
	scry_close() ;
	exit(0) ;
    }
    if ((width < 1) || (width > S_MAX_IMAGE_WIDTH))
    {
	fprintf (stderr,"scry_save_anima:  width of %d is illegal\n",width) ;
	scry_close() ;
	exit(0) ;
    }
    if ((depth < S_MIN_COLOR_DEPTH) || (depth > S_MAX_COLOR_DEPTH))
    {
	fprintf (stderr,"scry_save_anima:  color depth in bytes of %d is illegal\n",depth) ;
	scry_close() ;
	exit(0) ;
    }
        /* set offset of current frame that will be saved in Anima footer */
    S_a_index[S_anima_count].offset = S_anima_bytes ;

        /* ccc_compress only works on 3-byte color resolution images */
    newimage = convert_to_3 (rawimage,height,width,depth,&new_ht,&new_wd) ;
    compdata = (unsigned char *) malloc((new_ht*new_wd)/2) ;

        /* CCC compress */
    ccc_compress (newimage,compdata,&datasize,new_ht,new_wd) ;

    free(newimage) ;


    S_image_info.total = datasize ;
    S_image_info.data = compdata ;
    S_image_info.compression = S_CCC ;
	/* write IFF header for frame */
    iff_write_header(S_anima_file,&S_image_info,new_ht,new_wd,"many map Anima file") ;
	/* write compressed image */
    iff_write_buf(S_anima_file,&S_image_info) ;
    free(compdata) ;
	/* set footer information */
    S_a_index[S_anima_count].buf_total = S_image_info.total ;
    S_anima_count++ ;
}
