/* extract.c      Distribution 1.2   91/1/28   Scry */

/*   The Scry system is copyright (C) 1988-1991 Regents  of  the
University  of  California.   Anyone may reproduce ``Scry'',
the software in this distribution, in whole or in part, pro-
vided that:

(1)  Any copy  or  redistribution  of  Scry  must  show  the
     Regents  of  the  University of California, through its
     Lawrence Berkeley Laboratory, as the source,  and  must
     include this notice;

(2)  Any use of this software must reference this  distribu-
     tion,  state that the software copyright is held by the
     Regents of the University of California, and  that  the
     software is used by their permission.

     It is acknowledged that the U.S. Government has  rights
in  Scry  under  Contract DE-AC03-765F00098 between the U.S.
Department of Energy and the University of California.

     Scry is provided as a professional  academic  contribu-
tion  for  joint exchange.  Thus it is experimental, is pro-
vided ``as is'', with no warranties of any kind  whatsoever,
no  support,  promise  of updates, or printed documentation.
The Regents of the University of California  shall  have  no
liability  with respect to the infringement of copyrights by
Scry, or any part thereof. */


#include <stdio.h>
#include <scry_anima.h>
#include <scry_image.h>
#include <scry_limits.h>


/* parse_args:     parse command-line arguments
   init_vars:      various variable initialization
   extract_frame:  extract frame from Anima file */


static void parse_args();
static void init_vars();

char anima_format[80] ;		/* whether many map or one map */

int get_in_frame ;		/* first frame in extracted sequence */
int get_out_frame ;		/* last frame in extracted sequence */

char out_name[80] ;		/* output file name */
FILE *deci_out ;

unsigned char S_map[S_MAX_COL_SIZE][3] ;	/* color map */
int S_mapnum ;	/* number of entries in color map */


struct image_stuff S_image_info ;		/* image info (height, etc.) */

main(argc, argv)

int argc;
char *argv[];

{
    int i ;
    
    init_vars();

        /* get command-line arguments */
    parse_args(argc, argv);
    if ((deci_out = fopen (out_name, "w")) == NULL)
    {
	fprintf (stderr,"can't open output file\n");
	exit(0) ;
    }
    if (S_anima_filename[0] != NULL)
    {
	    /* get Anima file footer */
	if (!getfile())
	{
	    perror ("reading anima file") ;
	    exit (0) ;
	}
	fseek(S_anima_file,0,0) ;
    }
    if ((get_in_frame < 0) || (get_in_frame >= S_anima_count) ||
	(get_in_frame > get_out_frame))
    {
	fprintf (stderr,"illegal starting frame\n") ;
	exit(0) ;
    }
    if ((get_out_frame < get_in_frame) || (get_in_frame >= S_anima_count) ||
	(get_out_frame < 0))
    {
	fprintf (stderr,"illegal ending frame\n") ;
	exit(0) ;
    }

    S_image_info.c_width = 0 ;
    S_image_info.c_height = 0 ;
    S_anima_bytes = 0 ;
    S_anima_count = 0 ;
    
	/* extract sequence */
    for (i = 0 ; i <= get_out_frame ; i++)
    {
	if (i >= get_in_frame)
	{
	    if ((i % 25) == 0)
	        fprintf (stderr,"frame %d\n",i) ;
	    extract_frame(i,deci_out) ;
	}
    }

	/* number of frames in extracted Anima file */
    S_anima_count = get_out_frame - get_in_frame + 1 ;

    anima_write_footer(deci_out) ;
    fclose(deci_out) ;
}




/* parse command-line arguments */

static void
parse_args(argc, argv)

int argc;
char *argv[];

{
    int i;
    
    for(i = 1; i < argc; i++)
    {
	    if(*argv[i] != '-')
            {
		    fprintf(stderr,"bad command line:  use %s -h for help\n", argv[0]);
		    exit(-1);
            }
	    switch(*(argv[i]+1))
            {
		case 'i':		/* input Anima file */
		    strcpy(S_anima_filename, argv[++i]);
		    break;
		case 'o':		/* extracted sequence */
		    strcpy(out_name,argv[++i]) ;
		    break ;
		case 'e':		/* frames to extract */
		    get_in_frame = atoi(argv[++i]) ;
		    get_out_frame = atoi(argv[++i]) ;
		    break ;
		case 'h':
		    fprintf(stderr,"extracts a sequence of frames from an Anima file\n") ;
		    fprintf(stderr,"usage:  extract -i input -o output -e first last\n") ;
		    fprintf(stderr,"-h : this message\n");
		    exit(-1);
		default:
		    printf("bad command line:  use %s -h for help\n", argv[0]);
		    exit(-1);
        }
    }
}




static void
init_vars()
{
    S_anima_filename[0] = '\0';
    S_anima_file = NULL;
    S_anima_bytes = 0 ;
    S_anima_count = 0 ;
    get_in_frame = 0 ;
    get_out_frame = 0 ;
}




/* extract a frame into the new file */

extract_frame(current,out)

int current ;	/* current frame number */
FILE *out ;

{
    int height, width ;
    
	/* seek to beginning of file */
    fseek(S_anima_file, 0, 0) ;
	/* read IFF header */
    if(!iff_read_header(S_anima_file, &S_image_info, &height, &width,anima_format))
        fprintf(stderr,"iff_read_header failed\n");
	    /* if different than previous size */
    if ((S_image_info.c_height != height) || (S_image_info.c_width != width))
    {
        S_image_info.c_height = height ;
        S_image_info.c_width = width ;
        if (S_image_info.data != NULL)
            free(S_image_info.data) ;
        S_image_info.data = (unsigned char *) malloc(S_image_info.c_height * S_image_info.c_width / 2) ;
    }
	/* seek to current frame */
    fseek(S_anima_file, S_a_index[current].offset, 0);

    
	/* if necessary, read IFF header */
    if ((anima_format[0] == 'm') || (current == 0))
    {
        if(!iff_read_header(S_anima_file, &S_image_info, &height, &width,anima_format))
            fprintf(stderr,"iff_read_header failed\n");
    
	    /* if different than previous size */
        if ((S_image_info.c_height != height) || (S_image_info.c_width != width))
        {
            S_image_info.c_height = height ;
            S_image_info.c_width = width ;
	    if (S_image_info.data != NULL)
	        free(S_image_info.data) ;
	    S_image_info.data = (unsigned char *) malloc(S_image_info.c_height * S_image_info.c_width / 2) ;
        }
    }
	/* read compressed image */
    S_image_info.total = S_a_index[current].buf_total ;
    iff_read_buf(S_anima_file, &S_image_info);
	/* set up footer information for this frame */
    S_a_index[S_anima_count].offset = S_anima_bytes ;
    S_a_index[S_anima_count].buf_total = S_image_info.total ;
	/* write IFF header */
    if (anima_format[0] == 'm')
	iff_write_header(out,&S_image_info,S_image_info.c_height,
			 S_image_info.c_width,"many map Anima file") ;
    else if (S_anima_count == 0)
	iff_write_header(out,&S_image_info,S_image_info.c_height,
			 S_image_info.c_width,"one map Anima file") ;
    S_anima_count++ ;
	/* write compressed image */
    iff_write_buf(out,&S_image_info) ;
}
