/* read_old_file.c      Distribution 1.2   91/1/28   Scry */

/*   The Scry system is copyright (C) 1988-1991 Regents  of  the
University  of  California.   Anyone may reproduce ``Scry'',
the software in this distribution, in whole or in part, pro-
vided that:

(1)  Any copy  or  redistribution  of  Scry  must  show  the
     Regents  of  the  University of California, through its
     Lawrence Berkeley Laboratory, as the source,  and  must
     include this notice;

(2)  Any use of this software must reference this  distribu-
     tion,  state that the software copyright is held by the
     Regents of the University of California, and  that  the
     software is used by their permission.

     It is acknowledged that the U.S. Government has  rights
in  Scry  under  Contract DE-AC03-765F00098 between the U.S.
Department of Energy and the University of California.

     Scry is provided as a professional  academic  contribu-
tion  for  joint exchange.  Thus it is experimental, is pro-
vided ``as is'', with no warranties of any kind  whatsoever,
no  support,  promise  of updates, or printed documentation.
The Regents of the University of California  shall  have  no
liability  with respect to the infringement of copyrights by
Scry, or any part thereof. */

#include <stdio.h>
#include <scry_image.h>
#include <scry_anima.h>
#include <scry_limits.h>


/* routines in this file read in old format Anima file

   read_old_map:  read in old style color map
   read_prelim:   read in old style header 
   read_comp_buf:  read in old style compressed image
   get_old_footer:  read in old style Anima footer */

   /* old format footer information */

struct header
{
    long frame ;
    long offset ;
} ;

struct header *old_index ;
long total1, total2 ;
long old_compression ;	/* old format compression */

/* reads color map */

read_old_map(file)

FILE *file;		/* stored images file handle */

{
    int i;
    short tmpnum ;
    short old_map[S_MAX_COL_SIZE] ;
    
        /* number of entries in color map */
    if(fread(&tmpnum, sizeof(short), 1, file) == 0)
	return(0);
    S_mapnum = (long) tmpnum ;
    for(i = 0; i < S_mapnum ; i++)
        if(fread(&(old_map[i]), sizeof(short), 1, file) == 0)
	    return(0);
    S_mapnum++ ;
    S_map[0][S_RED] = 0 ;
    S_map[0][S_GREEN] = 0 ;
    S_map[0][S_BLUE] = 0 ;
	/* convert from Targa format to 24-bit RGB */
    for(i = 1 ; i < S_mapnum ; i++)
    {
	S_map[i][S_RED] = ((old_map[i-1]>>10)&0x1f)<<3 ;
	S_map[i][S_GREEN] = ((old_map[i-1]>>5)&0x1f)<<3 ;
	S_map[i][S_BLUE] = (old_map[i-1] & 0x1f)<<3 ;
    }
    
    return(1);
}




/* read in old header */

read_prelim(file,buffer)

FILE *file;
struct image_stuff *buffer;    /* control information */
{
	/* following variables unused in new version */
    long first ;
    long record ;
    short compression ;
    long lempel_ziv = 0 ;

    if((fread(&compression, sizeof(short), 1, file)) == 0)
	return(0);
    old_compression = (long) compression ;
    if((fread(&first, sizeof(long), 1, file)) == 0)
        return(0);
    if((fread(&record, sizeof(long), 1, file)) == 0)
	return(0);
    if((fread(&lempel_ziv, sizeof(long), 1, file)) == 0)
	return(0);
    if((fread(&total1, sizeof(long), 1, file)) == 0)
	return(0);
    if((fread(&total2, sizeof(long), 1, file)) == 0)
	return(0);
	    /* if Lempel-Ziv compressed */
    if(lempel_ziv)
        if((fread((char *)&buffer->total_lz, sizeof(long), 1, file)) == 0)
	    return(0);
    buffer->total = total1 + total2 ;	/* total bytes in compressed image */
	/* convert to new format compression ID */
    if (old_compression == 2)
	old_compression = S_CCC ;
    if (old_compression == 99)
	old_compression = S_QUANTIZE ;
    if (lempel_ziv)
        old_compression |= S_LEMPEL_ZIV ;
    
    return(1);
}




/* read old format compressed image */

read_comp_buf(file,buffer)

FILE *file;
struct image_stuff *buffer;	/* compressed image */

{
    if(fread(buffer->data, buffer->total, 1, file) == 0)
	return(0);
    return(1);
}




/* get old Anima footer */

get_old_footer(oldfilename,oldfile)

char *oldfilename ;
FILE **oldfile ;

{
    char old_anima_id[7] ;
    short oldcount ;

    if ((*oldfile = fopen(oldfilename, "r")) == NULL)
    {
        fprintf (stderr,"can't open old file\n") ;
        exit(0) ;
    }
	
	/* Check if the file contains a footer array */
    fseek(*oldfile, -6L, 2);
    Fread(&old_anima_id[0], 6, 1, *oldfile);
    old_anima_id[6] = 0;
	
    if(strcmp(old_anima_id, "header") == 0)
    {
            /* Read no. of bytes of data in the file */
            /* This is used to seek to the beginning of the footer array */
        fseek(*oldfile, -10L, 2);
        Fread(&S_anima_bytes, sizeof(long), 1, *oldfile);
		
            /* Read the no. of frames in the file */
        fseek(*oldfile, S_anima_bytes, 0);
        Fread(&oldcount, sizeof(short), 1, *oldfile);
        S_anima_count = (int) oldcount ;

        if((old_index = Calloc(S_anima_count, struct header)) == NULL)
            perror("old footer");

        if((S_a_index = Calloc(S_anima_count, struct footer)) == NULL)
            perror("new footer");

		/* Read the footer array */
        Fread(&old_index[0], sizeof(struct header), S_anima_count, *oldfile);
        fseek(*oldfile, 0L, 0);
    }
    else			/* footer array nonpresent */
    {
        perror ("no footer present in old-format Anima file") ;
        exit (0) ;
    }
}
