
/* tessel.c      Distribution 1.1   89/3/30   Scry */

/*   The Scry system is copyright (C) 1988, 1989, Regents  of  the
University  of  California.   Anyone may reproduce ``Scry'',
the software in this distribution, in whole or in part, pro-
vided that:

(1)  Any copy  or  redistribution  of  Scry  must  show  the
     Regents  of  the  University of California, through its
     Lawrence Berkeley Laboratory, as the source,  and  must
     include this notice;

(2)  Any use of this software must reference this  distribu-
     tion,  state that the software copyright is held by the
     Regents of the University of California, and  that  the
     software is used by their permission.

     It is acknowledged that the U.S. Government has  rights
in  Scry  under  Contract DE-AC03-765F00098 between the U.S.
Department of Energy and the University of California.

     Scry is provided as a professional  academic  contribu-
tion  for  joint exchange.  Thus it is experimental, is pro-
vided ``as is'', with no warranties of any kind  whatsoever,
no  support,  promise  of updates, or printed documentation.
The Regents of the University of California  shall  have  no
liability  with respect to the infringement of copyrights by
Scry, or any part thereof.     */

/* tessel.c	Tesselation algorithms for the marching cubes
 * This is part of the "marching cubes" implementation.  These routines tessellate
 * arrays that have been scanned by the process_array routine in array.c.
 *
 * Max Rible	Lawrence Berkeley Laboratories
 *		Advanced Development group
 *		Computer Graphics Laboratory
 *		1988
 */

#include "march.h"

#define F(x) (floor((double)(x)))
#define C(x) (ceil((double)(x)))
#define IF(x) (int)(F(x))
#define IC(x) (int)(C(x))


static long ***nextslice, ***curslice, ***tmpslice;
static int init_slices();

/* This version of the tessellation function does interpolation and
 * even finds normals for the rendering algorithm, for use in Gouraud
 * shading.  There's a definite amount of redundancy in the code here,
 * looking at the three tessellation functions, but there's no other
 * way I can see without putting in a lot of time-wasting if statements.
 * Now if this were a language where you can make functions output other
 * functions, we might be able to do something about that.
 */

long
gouraud_tess(array, value, dx, dy, dz, cubes, depths, edgelist,
	     normlist, triangles, pred_edges, triangles_done, edges_done)
    float  ***array, value;
    int dx, dy, dz;
    struct cube **cubes;
    long     *depths;
    float    *edgelist[3], *normlist[3];
    long     *triangles, pred_edges, *triangles_done, *edges_done;
{
    int       i, j;		/* Indexing: slice, depth */
    register int l, m, n;	/* Indexing: triangles, edges, direction */
    register int d, od, nd, q;	/* Directions, direction index */
    int       vec[3];		/* Edge location */
    int       lx, ly, lz;	/* Current cube location */
    int       tri, ct;		/* Triangles per cube, number of corners done */
    long      sides_done = 0, tri_done = 0, num_edges = 0;
    int       t[3];		/* Array bounds */
    register unsigned tmp;
    int       fl[3], fg[3], cl[3], cg[3];	/* Surrounding coordinates */
    float     s[3], b[3], u[3];	/* Side coordinates, floor'd, ceil'd */
    int       f[3], c[3];	/* b and u int'd */
    float    *normx, *normy, *normz;	/* Saves indexing */
    float     mag;		/* Length of normal, used for normalizing */

    t[EX] = dx - 1;
    t[EY] = dy - 1;
    t[EZ] = dz - 1;


    /* Initializations */
    if ((edgelist[0] = Calloc(3 * pred_edges, float)) == NULL)
	perror("edgelist[]");

    if ((normlist[0] = Calloc(3 * pred_edges, float)) == NULL)
	perror("normlist[]");

    for (i = 1; i < 3; i++) {
	edgelist[i] = *edgelist + i * pred_edges;
	normlist[i] = *normlist + i * pred_edges;
    }
    normx = normlist[EX];
    normy = normlist[EY];
    normz = normlist[EZ];

    init_slices(dy, dz);

#define V_X vec[EX]
#define V_Y vec[EY]
#define V_Z vec[EZ]
#define Q(x,y) ((x == y) ? vec[y]+1 : vec[y])
#define I(x) (((x) < -1.0) ? -0.5 : (((x) > 1.0) ? 0.5 : (x)))
#define T(x) ((float) (x))
#define EDGES(x,y,z,d) (((x) == i) ? curslice[y][z][d] : nextslice[y][z][d])
#define SETEDGE(x,y,z,d,n) (((x) == i) ? (curslice[y][z][d] = n) : (nextslice[y][z][d] = n))

    for (i = 0; i < t[EX]; i++) {
	if (depths[i] > 0)
	    for (j = 0; j < depths[i]; j++) {
		tri = numtri[cubes[i][j].cube];
		lx = i;
		ly = cubes[i][j].y;
		lz = cubes[i][j].z;
		for (l = 0; l < tri; l++) {
		    tmp = cubedges[cubes[i][j].cube][l];
		    for (ct = 0, m = 0; m < 15; m++)
			if (tmp & BIT(m)) {
			    V_X = lx;
			    V_Y = ly;
			    V_Z = lz;
			    for (n = 0; n < 3; n++)
				if (edgenums[m][n] == 1)
				    d = n;
				else if (edgenums[m][n] == 2)
				    vec[n]++;
			    if (EDGES(V_X, V_Y, V_Z, d) == 0) {
				/* Here we interpolate the edge */
				SETEDGE(V_X, V_Y, V_Z, d, ++num_edges);
				if (d == EX) {
				    od = EY;
				    nd = EZ;
				} else if (d == EY) {
				    od = EX;
				    nd = EZ;
				} else {
				    od = EX;
				    nd = EY;
				}
				if (vec[d] < t[d])
				    s[d] = edgelist[d][num_edges] =
					T(vec[d]) - I((value - array[V_X][V_Y][V_Z]) /
						      (array[V_X][V_Y][V_Z] -
				      array[Q(d, EX)][Q(d, EY)][Q(d, EZ)]));
				else
				    s[d] = edgelist[d][num_edges] = T(vec[d]) + 0.5;
				s[od] = edgelist[od][num_edges] = T(vec[od]);
				s[nd] = edgelist[nd][num_edges] = T(vec[nd]);
#include "normfrag.c"		/* Ugly code fragment */
			    }
			    triangles[sides_done++] = EDGES(V_X, V_Y, V_Z, d);
			    if (++ct >= 3)
				break;
			}
		    triangles[sides_done - 1] *= -1;
		    tri_done++;
		}
#ifdef PARANOIA
#include "fixfrag.c"		/* Ugly code fragment */
#endif
	    }
	tmpslice = nextslice;
	nextslice = curslice;
	curslice = tmpslice;
	Memset(nextslice[0][0], 0, sizeof(long) * dy * dz * 3);
    }

#ifdef DEBUG
    printf("Triangulation complete.  %d triangles, %d edges.\n", tri_done, num_edges);
#endif

    *triangles_done = tri_done;

    *edges_done = num_edges;

    free_3d_array((char ***) nextslice);
    free_3d_array((char ***) curslice);

    return (0);
}

#undef EDGES
#undef SETEDGE

/* This is the same thing without any routines for calculating the normals. */
long
constant_tess(array, value, dx, dy, dz, cubes, depths, edgelist,
	      triangles, pred_edges, triangles_done, edges_done)
    float  ***array, value;
    int dx, dy, dz;
    struct cube **cubes;
    long     *depths;
    float    *edgelist[3];
    long     *triangles, pred_edges, *triangles_done, *edges_done;
{
    int       i, j;		/* Indexing:  slice, depth */
    register int l, m, n;	/* Indexing:  triangles, edges, direction */
    register int d, od, nd;	/* Directions */
    int       vec[3];		/* Edge location */
    int       tri, ct;		/* Triangles per cube, number of corners done */
    int       t[3];		/* Array bounds */
    long      sides_done = 0, tri_done = 0, num_edges = 0;
    int       lx, ly, lz;	/* Current cube location */
    register unsigned tmp;

    t[EX] = dx - 1;
    t[EY] = dy - 1;
    t[EZ] = dz - 1;

    if ((edgelist[0] = Calloc(3 * pred_edges, float)) == NULL)
	perror("edgelist[]");

    for (i = 1; i < 3; i++) {
	edgelist[i] = *edgelist + i * pred_edges;
    }

    init_slices(dy, dz);

#define V_X vec[EX]
#define V_Y vec[EY]
#define V_Z vec[EZ]
#define Q(x,y) ((x == y) ? vec[y]+1 : vec[y])
#define I(x) (((x) < -1.0) ? -0.5 : (((x) > 1.0) ? 0.5 : (x)))
#define T(x) ((float) (x))
#define EDGES(x,y,z,d) (((x) == i) ? curslice[y][z][d] : nextslice[y][z][d])
#define SETEDGE(x,y,z,d,n) (((x) == i) ? (curslice[y][z][d] = n) : (nextslice[y][z][d] = n))

/* Start filling the arrays with data; we only load in four slices at
 * a time, so we overwrite previous slices while maintaining the
 * illusion of a complete grid.
 */

    for (i = 0; i < t[EX]; i++) {
	if (depths[i] > 0)
	    for (j = 0; j < depths[i]; j++) {
		tri = numtri[cubes[i][j].cube];
		lx = i;
		ly = cubes[i][j].y;
		lz = cubes[i][j].z;
		for (l = 0; l < tri; l++) {
		    tmp = cubedges[cubes[i][j].cube][l];
		    for (ct = 0, m = 0; m < 15; m++)
			if (tmp & BIT(m)) {
			    V_X = lx;
			    V_Y = ly;
			    V_Z = lz;
			    for (n = 0; n < 3; n++)
				if (edgenums[m][n] == 1)
				    d = n;
				else if (edgenums[m][n] == 2)
				    vec[n]++;
			    if (EDGES(V_X, V_Y, V_Z, d) == 0) {
				/* Here we interpolate the edge */
				SETEDGE(V_X, V_Y, V_Z, d, ++num_edges);
				if (d == EX) {
				    od = EY;
				    nd = EZ;
				} else if (d == EY) {
				    od = EX;
				    nd = EZ;
				} else {
				    od = EX;
				    nd = EY;
				}
				if (vec[d] < t[d])
				    edgelist[d][num_edges] =
					T(vec[d]) + I((value - array[V_X][V_Y][V_Z]) /
				      (array[Q(d, EX)][Q(d, EY)][Q(d, EZ)] -
				       array[V_X][V_Y][V_Z]));
				else
				    edgelist[d][num_edges] = T(vec[d]) + 0.5;
				edgelist[od][num_edges] = T(vec[od]);
				edgelist[nd][num_edges] = T(vec[nd]);
			    }
			    triangles[sides_done++] = EDGES(V_X, V_Y, V_Z, d);
			    if (++ct >= 3)
				break;
			}
		    triangles[sides_done - 1] *= -1;
		    tri_done++;
		}
#ifdef PARANOIA
#include "fixfrag.c"		/* Code fragment */
#endif
	    }
	tmpslice = nextslice;
	nextslice = curslice;
	curslice = tmpslice;
	Memset(nextslice[0][0], 0, sizeof(long) * dy * dz * 3);
    }

#ifdef DEBUG
    printf("Triangulation complete.  %d triangles, %d edges.\n", tri_done, num_edges);
#endif

    *triangles_done = tri_done;

    *edges_done = num_edges;

    free_3d_array((char ***) nextslice);
    free_3d_array((char ***) curslice);

    return (0);
}

#undef EDGES
#undef SETEDGE

/*********************************************************/
static int
init_slices(dy, dz)
    int dy, dz;
{
    long   ***alloc_3d_long_array();

    nextslice = alloc_3d_long_array(dz, dy, 3);
    curslice = alloc_3d_long_array(dz, dy, 3);

}
