/*	Copyright (c) 1982 Michael Landy, Yoav Cohen, and George Sperling

Disclaimer:  No guarantees of performance accompany this software,
nor is any responsibility assumed on the part of the authors.  All the
software has been tested extensively and every effort has been made to
insure its reliability.   */

/*
 * seehisto.c - output histogram files as ASCII text
 *
 * usage:	seehisto [-zp] <hist 
 *			-p  -  pipe input to standard output
 *			-z  -  do not print zero valued bins
 *
 * to load:	cc -o seehisto seehisto.c -lhipl
 *
 * Michael Landy - 12/15/82
 */

#include <hipl_format.h>
#include <stdio.h>
char *Progname;

main(argc,argv)

int argc;
char **argv;

{
	int i,r,c,f,fr,binleft,numbin,binwidth,*hist,*hp;
	int pflag = 0, zflag = 0;
	char out[120], nxtnum[20], *strchr(), *strcat(), *strcpy();
	struct header hd;

	Progname = strsave(*argv);
	while (--argc > 0) {
		argv++;
		if (argv[0][0] == '-') {
			if (strchr(&argv[0][1],'h')) 
 				perr("usage: seehisto [-zhp] <hist");
			if (strchr(&argv[0][1],'p')) pflag++;
			if (strchr(&argv[0][1],'z')) zflag++;
		}
	}

	read_header(&hd);
	r=hd.rows;
	c=hd.cols;
	f=hd.num_frame;
	update_header(&hd,argc,argv);
	if (pflag) write_header(&hd);

	if (hd.pixel_format != PFBHIST)
		perr("image must be in byte histogram format");
	if (pread(0,&binleft,sizeof(int)) != sizeof(int))
		perr("error during read");
	if (pread(0,&numbin,sizeof(int)) != sizeof(int))
		perr("error during read");
	if (pflag) {
		if (write(1,&binleft,sizeof(int)) != sizeof(int))
			perr("error during write");
		if (write(1,&numbin,sizeof(int)) != sizeof(int))
			perr("error during write");
	}

	binwidth = 256/numbin;
	if (binwidth*numbin != 256)
		perr("strange number of bins!!?");
	hist = (int *) halloc(numbin,sizeof(int));

	fprintf(stderr,"seehisto: image size was %d x %d\n",r,c);
    fprintf(stderr,"seehisto: first bin starts at %d, and there are %d bins\n",
		binleft,numbin);
	for(fr=0;fr<f;fr++) { 
		if (pread(0,hist,numbin*sizeof(int)) != numbin*sizeof(int))
			perr("error during read");
		if (pflag)
			if (write(1,hist,numbin*sizeof(int)) != 
			    numbin*sizeof(int))
				perr("error during write");
		strcpy(out,"");
		hp = hist;
		for (i=0; i<numbin; i++, hp++) {
			if (!zflag || *hp != 0) {
				sprintf(nxtnum,"%d: %d",i,*hp);
				if (strlen(nxtnum) > (80 - strlen(out) - 4)) {
					fprintf(stderr,"%s\n",out);
					strcpy(out,"");
				}
				if (strlen(out) != 0) strcat(out," | ");
				strcat(out,nxtnum);
			}
		}
		if (strlen(out)) fprintf(stderr,"%s\n",out);
	}
}
