/*
 * pixedit_ui.c - User interface object initialization functions.
 * This file was generated by `gxv' from `pixedit.G'.
 * DO NOT EDIT BY HAND.
 */

#include <stdio.h>
#include <sys/param.h>
#include <sys/types.h>
#include <xview/xview.h>
#include <xview/canvas.h>
#include <xview/icon_load.h>
#include <xview/panel.h>
#include <xview/scrollbar.h>
#include <xview/svrimage.h>
#include <xview/termsw.h>
#include <xview/text.h>
#include <xview/tty.h>
#include <xview/xv_xrect.h>
#include "pixedit_ui.h"

/*
 * Initialize an instance of object `win'.
 */
pixedit_win_objects *
pixedit_win_objects_initialize(ip, owner)
	pixedit_win_objects	*ip;
	Xv_opaque	owner;
{
	if (!ip && !(ip = (pixedit_win_objects *) calloc(1, sizeof (pixedit_win_objects))))
		return (pixedit_win_objects *) NULL;
	if (!ip->win)
		ip->win = pixedit_win_win_create(ip, owner);
	if (!ip->control)
		ip->control = pixedit_win_control_create(ip, ip->win);
	if (!ip->edit_mode)
		ip->edit_mode = pixedit_win_edit_mode_create(ip, ip->control);
	if (!ip->save_item)
		ip->save_item = pixedit_win_save_item_create(ip, ip->control);
	if (!ip->restore_item)
		ip->restore_item = pixedit_win_restore_item_create(ip, ip->control);
	if (!ip->brush_type)
		ip->brush_type = pixedit_win_brush_type_create(ip, ip->control);
	if (!ip->mag_item)
		ip->mag_item = pixedit_win_mag_item_create(ip, ip->control);
	if (!ip->cursor_item)
		ip->cursor_item = pixedit_win_cursor_item_create(ip, ip->control);
	if (!ip->canvas)
		ip->canvas = pixedit_win_canvas_create(ip, ip->win);
	return ip;
}

/*
 * Create object `win' in the specified instance.

 */
Xv_opaque
pixedit_win_win_create(ip, owner)
	caddr_t		ip;
	Xv_opaque	owner;
{
	extern Notify_value	paint_win_event_proc();
	Xv_opaque	obj;
	
	obj = xv_create(owner, FRAME,
		XV_KEY_DATA, INSTANCE, ip,
		XV_WIDTH, 500,
		XV_HEIGHT, 500,
		XV_LABEL, "Edit Window",
		FRAME_CLOSED, FALSE,
		FRAME_SHOW_FOOTER, FALSE,
		FRAME_SHOW_RESIZE_CORNER, TRUE,
		NULL);
	xv_set(obj, WIN_CONSUME_EVENTS,
		LOC_WINENTER,
		LOC_WINEXIT,
		NULL, NULL);
	notify_interpose_event_func(obj,
		(Notify_func) paint_win_event_proc, NOTIFY_SAFE);
	return obj;
}

/*
 * Create object `control' in the specified instance.

 */
Xv_opaque
pixedit_win_control_create(ip, owner)
	caddr_t		ip;
	Xv_opaque	owner;
{
	Xv_opaque	obj;
	
	obj = xv_create(owner, PANEL,
		XV_KEY_DATA, INSTANCE, ip,
		XV_X, 0,
		XV_Y, 0,
		XV_WIDTH, 325,
		XV_HEIGHT, 95,
		WIN_BORDER, TRUE,
		NULL);
	return obj;
}

/*
 * Create object `edit_mode' in the specified instance.

 */
Xv_opaque
pixedit_win_edit_mode_create(ip, owner)
	caddr_t		ip;
	Xv_opaque	owner;
{
	extern int		change_cursor_proc();
	Xv_opaque	obj;
	
	obj = xv_create(owner, PANEL_CHOICE,
		XV_KEY_DATA, INSTANCE, ip,
		XV_X, 4,
		XV_Y, 4,
		XV_WIDTH, 164,
		XV_HEIGHT, 23,
		PANEL_VALUE_X, 83,
		PANEL_VALUE_Y, 4,
		PANEL_LAYOUT, PANEL_HORIZONTAL,
		PANEL_CHOICE_NROWS, 1,
		PANEL_LABEL_STRING, "Edit mode:",
		PANEL_NOTIFY_PROC, change_cursor_proc,
		PANEL_CHOICE_STRINGS,
			" Cut ",
			"Fill ",
			0,
		NULL);
	return obj;
}

/*
 * Create object `save_item' in the specified instance.

 */
Xv_opaque
pixedit_win_save_item_create(ip, owner)
	caddr_t		ip;
	Xv_opaque	owner;
{
	extern void		mask_save_proc();
	Xv_opaque	obj;
	
	obj = xv_create(owner, PANEL_BUTTON,
		XV_KEY_DATA, INSTANCE, ip,
		XV_X, 192,
		XV_Y, 12,
		XV_WIDTH, 46,
		XV_HEIGHT, 19,
		PANEL_LABEL_STRING, "Save",
		PANEL_NOTIFY_PROC, mask_save_proc,
		NULL);
	return obj;
}

/*
 * Create object `restore_item' in the specified instance.

 */
Xv_opaque
pixedit_win_restore_item_create(ip, owner)
	caddr_t		ip;
	Xv_opaque	owner;
{
	extern void		mask_restore_proc();
	Xv_opaque	obj;
	
	obj = xv_create(owner, PANEL_BUTTON,
		XV_KEY_DATA, INSTANCE, ip,
		XV_X, 252,
		XV_Y, 12,
		XV_WIDTH, 63,
		XV_HEIGHT, 19,
		PANEL_LABEL_STRING, "Restore",
		PANEL_NOTIFY_PROC, mask_restore_proc,
		NULL);
	return obj;
}

/*
 * Create object `brush_type' in the specified instance.

 */
Xv_opaque
pixedit_win_brush_type_create(ip, owner)
	caddr_t		ip;
	Xv_opaque	owner;
{
	extern int		change_cursor_proc();
	Xv_opaque	obj;
	
	obj = xv_create(owner, PANEL_CHOICE, PANEL_DISPLAY_LEVEL, PANEL_CURRENT,
		XV_KEY_DATA, INSTANCE, ip,
		XV_X, 4,
		XV_Y, 32,
		XV_WIDTH, 160,
		XV_HEIGHT, 23,
		PANEL_VALUE_X, 88,
		PANEL_VALUE_Y, 32,
		PANEL_LAYOUT, PANEL_HORIZONTAL,
		PANEL_CHOICE_NROWS, 1,
		PANEL_LABEL_STRING, "Brush size:",
		PANEL_NOTIFY_PROC, change_cursor_proc,
		PANEL_CHOICE_STRINGS,
			"1x1",
			"2x2",
			"3x3",
			"4x4",
			"5x5",
			"6x6",
			"20x20",
			0,
		NULL);
	return obj;
}

/*
 * Create object `mag_item' in the specified instance.

 */
Xv_opaque
pixedit_win_mag_item_create(ip, owner)
	caddr_t		ip;
	Xv_opaque	owner;
{
	extern int		mag_proc();
	Xv_opaque	obj;
	
	obj = xv_create(owner, PANEL_CHOICE, PANEL_DISPLAY_LEVEL, PANEL_CURRENT,
		XV_KEY_DATA, INSTANCE, ip,
		XV_X, 180,
		XV_Y, 48,
		XV_WIDTH, 136,
		XV_HEIGHT, 23,
		PANEL_VALUE_X, 260,
		PANEL_VALUE_Y, 48,
		PANEL_LAYOUT, PANEL_HORIZONTAL,
		PANEL_CHOICE_NROWS, 1,
		PANEL_LABEL_STRING, "Zoom Mag:",
		PANEL_NOTIFY_PROC, mag_proc,
		PANEL_CHOICE_STRINGS,
			"x 1",
			"x 2",
			"x 3",
			"x 4",
			"x 5",
			"x 6",
			0,
		NULL);
	return obj;
}

/*
 * Create object `cursor_item' in the specified instance.

 */
Xv_opaque
pixedit_win_cursor_item_create(ip, owner)
	caddr_t		ip;
	Xv_opaque	owner;
{
	extern int		change_cursor_proc();
	Xv_opaque	obj;
	
	obj = xv_create(owner, PANEL_CHOICE,
		XV_KEY_DATA, INSTANCE, ip,
		XV_X, 4,
		XV_Y, 60,
		XV_WIDTH, 170,
		XV_HEIGHT, 23,
		PANEL_VALUE_X, 61,
		PANEL_VALUE_Y, 60,
		PANEL_LAYOUT, PANEL_HORIZONTAL,
		PANEL_CHOICE_NROWS, 1,
		PANEL_LABEL_STRING, "Cursor:",
		PANEL_NOTIFY_PROC, change_cursor_proc,
		PANEL_CHOICE_STRINGS,
			"Square",
			"Round",
			0,
		NULL);
	return obj;
}

/*
 * Create object `canvas' in the specified instance.

 */
Xv_opaque
pixedit_win_canvas_create(ip, owner)
	caddr_t		ip;
	Xv_opaque	owner;
{
	extern Notify_value	edit_event_proc();
	extern void	edit_repaint_proc();
	Xv_opaque	obj;
	
	obj = xv_create(owner, CANVAS,
		XV_KEY_DATA, INSTANCE, ip,
		XV_X, 1,
		XV_Y, 100,
		XV_WIDTH, WIN_EXTEND_TO_EDGE,
		XV_HEIGHT, WIN_EXTEND_TO_EDGE,
		CANVAS_REPAINT_PROC, edit_repaint_proc,
		CANVAS_X_PAINT_WINDOW, TRUE,
		NULL);
	xv_set(canvas_paint_window(obj), WIN_CONSUME_EVENTS,
		WIN_MOUSE_BUTTONS,
		LOC_DRAG,
		LOC_MOVE,
		NULL, NULL);
	notify_interpose_event_func(canvas_paint_window(obj),
		(Notify_func) edit_event_proc, NOTIFY_SAFE);
	xv_set(canvas_paint_window(obj), XV_KEY_DATA, INSTANCE, ip, NULL);
	return obj;
}

