/*
 * pixedit_stubs.c - Notify and event callback function stubs.
 * This file was generated by `gxv' from `pixedit.G'.
 * DO NOT EDIT BY HAND.
 */

#include <stdio.h>
#include <sys/param.h>
#include <sys/types.h>
#include <xview/xview.h>
#include <xview/panel.h>
#include <xview/textsw.h>
#include <xview/xv_xrect.h>
#include <gdd.h>
#include "pixedit_ui.h"

#ifdef MAIN

/*
 * Instance XV_KEY_DATA key.  An instance is a set of related
 * user interface objects.  A pointer to an object's instance
 * is stored under this key in every object.  This must be a
 * global variable.
 */
Attr_attribute	INSTANCE;

void
main(argc, argv)
	int		argc;
	char		**argv;
{
	pixedit_win_objects	*pixedit_win;
	
	/*
	 * Initialize XView.
	 */
	xv_init(XV_INIT_ARGC_PTR_ARGV, &argc, argv, 0);
	INSTANCE = xv_unique_key();
	
	/*
	 * Initialize user interface components.
	 */
	pixedit_win = pixedit_win_objects_initialize(NULL, NULL);
	
	/*
	 * Turn control over to XView.
	 */
	xv_main_loop(pixedit_win->win);
	exit(0);
}

#endif

/*
 * Event callback function for `win'.
 */
Notify_value
paint_win_event_proc(win, event, arg, type)
	Xv_window	win;
	Event		*event;
	Notify_arg	arg;
	Notify_event_type type;
{
	pixedit_win_objects	*ip = (pixedit_win_objects *) xv_get(win, XV_KEY_DATA, INSTANCE);
	
	fprintf(stderr, "pixedit: paint_win_event_proc: event %d\n", event_id(event));
	return notify_next_event_func(win, (Notify_event) event, arg, type);
}

/*
 * Notify callback function for `edit_mode'.
 */
void
change_cursor_proc(item, value, event)
	Panel_item	item;
	int		value;
	Event		*event;
{
	pixedit_win_objects	*ip = (pixedit_win_objects *) xv_get(item, XV_KEY_DATA, INSTANCE);
	
	fprintf(stderr, "pixedit: change_cursor_proc: value: %u\n", value);
}

/*
 * Notify callback function for `save_item'.
 */
void
mask_save_proc(item, event)
	Panel_item	item;
	Event		*event;
{
	pixedit_win_objects	*ip = (pixedit_win_objects *) xv_get(item, XV_KEY_DATA, INSTANCE);
	
	fputs("pixedit: mask_save_proc\n", stderr);
}

/*
 * Notify callback function for `restore_item'.
 */
void
mask_restore_proc(item, event)
	Panel_item	item;
	Event		*event;
{
	pixedit_win_objects	*ip = (pixedit_win_objects *) xv_get(item, XV_KEY_DATA, INSTANCE);
	
	fputs("pixedit: mask_restore_proc\n", stderr);
}

/*
 * Notify callback function for `mag_item'.
 */
void
mag_proc(item, value, event)
	Panel_item	item;
	int		value;
	Event		*event;
{
	pixedit_win_objects	*ip = (pixedit_win_objects *) xv_get(item, XV_KEY_DATA, INSTANCE);
	
	fprintf(stderr, "pixedit: mag_proc: value: %u\n", value);
}

/*
 * Event callback function for `canvas'.
 */
Notify_value
edit_event_proc(win, event, arg, type)
	Xv_window	win;
	Event		*event;
	Notify_arg	arg;
	Notify_event_type type;
{
	pixedit_win_objects	*ip = (pixedit_win_objects *) xv_get(win, XV_KEY_DATA, INSTANCE);
	
	fprintf(stderr, "pixedit: edit_event_proc: event %d\n", event_id(event));
	
	if (event_action(event) == ACTION_DRAG_LOAD) {
		char	name[MAXPATHLEN];

		if (gdd_get_drag_name(win, name) != -1) {
			fprintf(stderr, "pixedit: edit_event_proc: load %s\n", name);
		}
	} else if (event_action(event) == ACTION_MENU && event_is_down(event)) {
		Menu	menu = (Menu) xv_get(win, WIN_MENU);

		if (menu)
			menu_show(menu, win, event, 0);
	}
	return notify_next_event_func(win, (Notify_event) event, arg, type);
}

/*
 * Repaint callback function for `canvas'.
 */
void
edit_repaint_proc(canvas, paint_window, display, xid, rects)
	Canvas		canvas;
	Xv_window	paint_window;
	Display		*display;
	Window		xid;
	Xv_xrectlist	*rects;
{
	fputs("pixedit: edit_repaint_proc\n", stderr);
}

