
/*  flip_quad.c                             Brian Tierney,  LBL  3/90
 *
 *   Usage: flip_quad < inseq > outseq 
 *
 *  transform a fourier image from the standard transform to the 
 *  optical transform.
 *
 *  Method: transforms the quadrants of the image from
 *     A  B     to   D  C
 *     C  D          B  A
 *
 */

/*   This program is copyright (C) 1990, Regents  of  the
University  of  California.   Anyone may reproduce this software,
in whole or in part, provided that:
(1)  Any copy  or  redistribution  must  show  the
     Regents  of  the  University of California, through its
     Lawrence Berkeley Laboratory, as the source,  and  must
     include this notice;
(2)  Any use of this software must reference this  distribu-
     tion,  state that the software copyright is held by the
     Regents of the University of California, and  that  the
     software is used by their permission.

     It is acknowledged that the U.S. Government has  rights
to this software under  Contract DE-AC03-765F00098 between the U.S.
Department of Energy and the University of California.

     This software is provided as a professional  academic  contribu-
tion  for  joint exchange.  Thus it is experimental, is pro-
vided ``as is'', with no warranties of any kind  whatsoever,
no  support,  promise  of updates, or printed documentation.
Bug reports or fixes may be sent to the author, who may or may
not act on them as he desires. 
*/

/*   Author:  Brian L. Tierney
 *            Lawrence Berkeley Laboratory
 *            Imaging and Distributed Computing Group
 *            email: bltierney@lbl.gov
*/

#include <stdio.h>
#include <sys/types.h>

#include <hipl_format.h>

char     *Progname;

/* #define DEBUG */

u_char **image, **new_image;
int  nrow, ncol;

void transform_image(), usageterm();

/*************************************************************/
main(argc, argv)
    int       argc;
    char     *argv[];
{
    register int f;
    struct header hd;

    u_char  **alloc_2d_byte_array();

    Progname = strsave(*argv);

    if (argc > 1)
	usageterm();

    read_header(&hd);
    if (hd.pixel_format != PFBYTE)
	perr("image pixel format must be byte");
    update_header(&hd, argc, argv);
    write_header(&hd);

    nrow = hd.rows;
    ncol = hd.cols;

    image = alloc_2d_byte_array(nrow, ncol);
    new_image = alloc_2d_byte_array(nrow,ncol);

    for (f = 0; f < hd.num_frame; f++) {
	read_2d_byte_array(stdin, image, nrow, ncol);

         transform_image();

	write_2d_byte_array(stdout, new_image, nrow, ncol);
    } 
    fprintf(stderr, "%s done. \n\n",argv[0]);
    return (0);
}

/********************************************************************/
void
transform_image()
{
    register int i, j, ii, jj;
    int center_x, center_y;

    center_x = ncol / 2;
    center_y = nrow / 2;

    /* move quadrant A */
    ii = center_y;
    for (i=0; i< center_y; i++) {
	jj = center_x;
	for (j=0; j< center_x; j++) {
	    if (ii >= nrow || jj >= ncol)
		fprintf(stderr, " subscript error !\n");
	    new_image[ii][jj] = image[i][j];
	    jj++;
	}
	ii++;
    }

    /* move quadrant B */
    ii = center_y;
    for (i=0; i< center_y; i++) {
	jj = 0;
	for (j=center_x; j< ncol; j++) {
	    if (ii >= nrow || jj >= ncol)
		fprintf(stderr, " subscript error !\n");
	    new_image[ii][jj] = image[i][j];
	    jj++;
	}
	ii++;
    }

    /* move quadrant C */
    ii = 0;
    for (i=center_y; i< nrow; i++) {
	jj = center_x;
	for (j=0; j< center_x; j++) {
	    if (ii >= nrow || jj >= ncol)
		fprintf(stderr, " subscript error !\n");
	    new_image[ii][jj] = image[i][j];
	    jj++;
	}
	ii++;
    }

    /* move quadrant D */
    ii = 0;
    for (i=center_y; i< nrow; i++) {
	jj = 0;
	for (j=center_x; j< ncol; j++) {
	    if (ii >= nrow || jj >= ncol)
		fprintf(stderr, " subscript error !\n");
	    new_image[ii][jj] = image[i][j];
	    jj++;
	}
	ii++;
    }

}


/*********************************************************************/
void
usageterm()
{
    fprintf(stderr, "Usage: flip_quad < inseq > outseq \n ");
    exit(0);
}
