/* $Id: plotone.c,v 1.33 90/06/30 16:25:45 pturner Exp Locker: pturner $
 *
 * plotone.c - entry for graphics
 *
 */

#include <stdio.h>
#include <setjmp.h>
#include "defines.h"
#include "globals.h"
#include "objdefs.h"

#ifdef D3D
#include "defs.h"
extern Gridstruct grid[];
extern int drawgridflag;
extern int griddispflag;

#endif				/* D3D */

extern plotstr pstr[];		/* strings */
plotstr legstr[MAXPLOT];	/* legends */

extern int pointset;		/* if pointset = TRUE then draw a symbol at
				 * (dsx,dsy) */
extern double dsx, dsy;
extern char graph_labelstr[];
extern int noerase;

extern jmp_buf begin;		/* defined in pars.y */

#ifdef EX
extern int inwin;		/* only for the experimental section below */

#endif				/* EX */

plotone()
{
    int i, sy, ly, cy;
    double xtmp1, xtmp2, ytmp1, ytmp2;
    double xbar, sd;
    double *getx(), *gety();

    if (setjmp(begin)) {
	errwin("Internal error in draw routines, can't complete plot");
	return;
    }
    setclipping(TRUE);
    if (hardcopyflag)
	device = hdevice;
    else
	device = tdevice;
    if (noerase) {
	initgraphics(device);
	noerase = 0;
    }
#ifdef D3D
    if (griddispflag >= 2) {
	draw3d_proc();
	return;
    }
#endif				/* D3D */
    defineworld(xg1, yg1, xg2, yg2);
    viewport(xv1, yv1, xv2, yv2);
    setlinestyle(defline);
    setcolor(defcolor);
    setclipping(0);		/* shut down clipping for strings, boxes,
				 * lines, and legends */
    if (graph_labelstr[0]) {
	writestr(xg1, yg2, 0, graph_labelstr);
    }
    for (i = 0; i < MAXLINES; i++) {
	if (isactive_line(i)) {
	    setcolor(lines[i].color);
	    if (!lines[i].loctype) {
		draw_arrow(lines[i].x1, lines[i].y1, lines[i].x2, lines[i].y2, lines[i].arrow, lines[i].asize);
	    } else {
		get_view2world(lines[i].x1, lines[i].y1, &xtmp1, &ytmp1);
		get_view2world(lines[i].x2, lines[i].y2, &xtmp2, &ytmp2);
		draw_arrow(xtmp1, ytmp1, xtmp2, ytmp2, lines[i].arrow, lines[i].asize);
	    }
	}
    }
    for (i = 0; i < MAXBOXES; i++) {
	if (isactive_box(i)) {
	    setcolor(boxes[i].color);
	    if (!boxes[i].loctype) {
		rect(boxes[i].x1, boxes[i].y1, boxes[i].x2, boxes[i].y2);
	    } else {
		get_view2world(boxes[i].x1, boxes[i].y1, &xtmp1, &ytmp1);
		get_view2world(boxes[i].x2, boxes[i].y2, &xtmp2, &ytmp2);
		rect(xtmp1, ytmp1, xtmp2, ytmp2);
	    }
	}
    }
    if (boxon) {
	boxplot();
    }
    setcolor(defcolor);
    setlinestyle(defline);
    setclipping(1);
    setfont(curfont);
    setcharsize(defchar);
    setticksize(xticsize, yticsize);
    drawtics();
    drawlabels(xlabel, ylabel, title, stitle);
    setticksize(1.0, 1.0);
    if (pointset) {		/* mark the reference point */
	drawsym(dsx, dsy, 7);
	drawsym(dsx, dsy, 2);
    }
    setcharsize(1.0);
    for (i = 0; i < MAXSTR; i++) {
	if (strlen(pstr[i].s) && (pstr[i].size > 0.0)) {
	    setfont(pstr[i].font);
	    setcolor(pstr[i].color);
	    setcharsize(pstr[i].size);
	    if (!pstr[i].loctype) {
		writestr(pstr[i].x, pstr[i].y, pstr[i].rot, pstr[i].s);
	    } else {
		get_view2world(pstr[i].x, pstr[i].y, &xtmp1, &ytmp1);
		writestr(xtmp1, ytmp1, pstr[i].rot, pstr[i].s);
	    }
	    setcharsize(1.0 / pstr[i].size);
	}
    }
    setfont(curfont);
    /*
     * draw sets
     */
    for (i = 0; i < maxplot; i++) {
	int j;
	double *x, *y;
	char s[20];

	if (isactive(i)) {
	    if (iserrbar(i) < 0) {
		sy = getsetplotsym(i);
		ly = getsetlinesym(i);
		cy = getsetcolor(i);
		/*
		 * if (sy == MAXSYM || cy == 0) continue;
		 */
		setcolor(cy);
		if (ly) {
		    setlinestyle(ly);
		    drawpoly(getx(i), gety(i), getsetlength(i));
		    setlinestyle(defline);
		}
		if (sy < MAXSYM) {
		    if (sy < 17)
			setcharsize(defsymsize);
		    drawpolysym(getx(i), gety(i), getsetlength(i), sy);
		    if (sy < 17)
			setcharsize(defchar);
		} else {
		    switch (sy) {
		    case MAXSYM + 3:	/* draw segments */
			drawpolyseg(getx(i), gety(i), getsetlength(i));
			break;
		    case MAXSYM + 2:	/* draw bounding box */
			getsetminmax(i, &xtmp1, &xtmp2, &ytmp1, &ytmp2);
			rect(xtmp1, ytmp1, xtmp2, ytmp2);
			stasum(gety(i), getsetlength(i), &xbar, &sd, 0);
			move2(xtmp1, xbar);
			draw2(xtmp2, xbar);
			stasum(getx(i), getsetlength(i), &xbar, &sd, 0);
			move2(xbar, ytmp1);
			draw2(xbar, ytmp2);
			break;
		    case MAXSYM + 1:	/* set number and location */
		    case MAXSYM:	/* set number */
			x = getx(i);
			y = gety(i);
			for (j = 0; j < getsetlength(i); j++) {
			    if (symok(x[j], y[j])) {
				if (sy == MAXSYM) {
				    sprintf(s, "%d", i);
				} else {
				    sprintf(s, "(%d,%d)", i, j + 1);
				}
				writestr(x[j], y[j], 0, s);
			    }
			}
			break;
		    }
		}
	    } else {
		int setn;

/* draw error bars */
		setn = iserrbar(i);
		if (isactive(setn)) {
		    cy = getsetcolor(setn);
		    setcolor(cy);
		    drawerrbar(getx(setn), gety(setn), getsetlength(setn), getx(i), gety(i),
			     getsetlength(i), getseterrbarxy(i), errbarper);
		}
	    }
	}
    }

#ifdef EX
/*
 * experimental stuff, only if running sunview, no batch mode
 */
    if (inwin) {
	define_plot_files_proc();
	for (i = 0; i < 5; i++) {
	    int j, moveto = 0, dtype = 0;
	    char s[128], buf[256];
	    double x, y;
	    FILE *fp;

	    if (isactive_plotfile(i)) {
		plotfile_filename(i, s);
		dtype = plotfile_data(i);
		if (plotfile_type(i)) {
		    fp = popen(s, "r");
		    if (fp == NULL) {
			errwin("Popen failed in plotone.c");
		    }
		} else {
		    fp = fopen(s, "r");
		    if (fp == NULL) {
			errwin("Fopen failed in plotone.c");
		    }
		}
		if (fp != NULL) {
		    setcolor(1);
		    setlinestyle(1);
		    moveto = 1;
		    while (fgets(buf, 255, fp) != NULL) {
			if (buf[0] == '%') {
			    switch (buf[1]) {
			    case 'd':
				dtype = 0;
				moveto = 1;
				break;
			    case 't':
				dtype = 1;
				break;
			    case 'l':
				if (strlen(buf) > 2) {
				    sscanf(buf + 2, "%d", &ly);
				    setlinestyle(ly);
				}
				break;
			    case 'c':
				if (strlen(buf) > 2) {
				    sscanf(buf + 2, "%d", &cy);
				    setcolor(cy);
				}
				break;
			    }
			} else if (buf[0] != '#') {
			    switch (dtype) {
			    case 0:
				if (sscanf(buf, "%lf %lf", &x, &y) == 2) {
				    if (!moveto) {
					draw2(x, y);
				    } else {
					move2(x, y);
					moveto = 0;
				    }
				} else {
				    moveto = 1;
				}
				break;
			    case 1:
				sscanf(buf, "%lf %lf %s", &x, &y, s);
				if (symok(x, y)) {
				    writestr(x, y, 0, s);
				}
				break;
			    }
			}
		    }
		    if (plotfile_type(i)) {
			pclose(fp);
		    } else {
			fclose(fp);
		    }
		}
	    }
	}
    }
#endif				/* EX */

    setfont(curfont);
    setcolor(defcolor);
    setlinestyle(defline);
    setcharsize(defchar);
    if (legendflag) {
	dolegend();
    }
#ifdef D3D
    if (drawgridflag) {
	contour1(&grid[0]);
    }
#endif				/* D3D */
    device = tdevice;
}

/*
 * draw the legend at (legx, legy)
 * ib = 1 in loop means accumulate info for box
 * ib = -1 after loop means draw box
 */
dolegend()
{

    int i, j = 0, sy, cy, ly, ib = 0;
    double tmpx, tmpy;

    if (legloctype) {
	get_view2world(legx, legy, &tmpx, &tmpy);
    } else {
	tmpx = legx;
	tmpy = legy;
    }
    j = 0;
    for (i = 0; i < maxplot; i++) {
	if (isactive(i) && (legstr[i].s[0]) && (iserrbar(i) < 0)) {
	    sy = getsetplotsym(i);
	    ly = getsetlinesym(i);
	    cy = getsetcolor(i);
	    putlegend(j, llen, lgap, 1.0, tmpx, tmpy, sy, ly, cy, ib, legstr[i].s);
	    j++;
	}
    }
    if (j > 0 && ib == 1) {
	putlegend(j - 1, llen, lgap, 1.0, tmpx, tmpy, sy, ly, cy, ib, "");
    }
}

/*
 * draw the tickmarks
 */
drawtics()
{
    if (xticflag) {
	if (xgridflag) {
	    drawxgrid(xg1, xg2, yg1, yg2, xt1, xgcol, xglin);
	} else {
	    xmajor(0, xg1, xg2, yg1, yg2, xt1, xticopflag, xticinoutflag);
	}
	if (xticslog) {
	    if (xt2 != 0.0) {
		xminorlog(xgridflag, xg1, xg2, yg1, yg2, xt2, xticopflag, xticinoutflag);
	    }
	} else if (xgridflag) {
	    drawxgrid(xg1, xg2, yg1, yg2, xt2, xgcol, xglin);
	} else {
	    xmajor(1, xg1, xg2, yg1, yg2, xt2, xticopflag, xticinoutflag);
	}
    }
    if (xticlflag) {
	xlabels(xg1, xg2, xtopflag ? yg2 : yg1, xt1, xform, fformx, xticslog, xabsflag, xticangle, xtopflag, xticlskip);
    }
    if (yticflag) {
	if (ygridflag) {
	    drawygrid(yg1, yg2, xg1, xg2, yt1, ygcol, yglin);
	} else {
	    ymajor(0, yg1, yg2, xg1, xg2, yt1, yticopflag, yticinoutflag);
	}
	if (yticslog) {
	    if (yt2 != 0.0) {
		yminorlog(ygridflag, yg1, yg2, xg1, xg2, yt2, yticopflag, yticinoutflag);
	    }
	} else if (ygridflag) {
	    drawygrid(yg1, yg2, xg1, xg2, yt2, ygcol, yglin);
	} else {
	    ymajor(1, yg1, yg2, xg1, xg2, yt2, yticopflag, yticinoutflag);
	}
    }
    if (yticlflag) {
	ylabels(yg1, yg2, ytopflag ? xg2 : xg1, yt1, yform, fformy, yticslog, yabsflag, yticangle, ytopflag, yticlskip);
    }
    if ((yg1 < 0.0) && (yg2 > 0.0)) {
	if (xzflag) {
	    drawzerox();
	    if (xztflag) {
		drawxzerotics(xt1, xt2);
	    }
	}
    }
    if ((xg1 < 0.0) && (xg2 > 0.0)) {
	if (yzflag) {
	    drawzeroy();
	    if (yztflag) {
		drawyzerotics(yt1, yt2);
	    }
	}
    }
}

/*
 * draw a box around the plot
 */
boxplot()
{
    setcolor(boxcol);
    setlinestyle(boxlin);
    if (boxflag) {
	rect(xg1, yg1, xg2, yg2);
    } else {
	move2(xg1, yg1);
	draw2(xg2, yg1);
	move2(xg1, yg1);
	draw2(xg1, yg2);
    }
}
