/* $Id: files.c,v 1.22 90/03/21 20:00:51 pturner Exp Locker: pturner $
 *
 * read data files
 *
 */

#include <stdio.h>

#define MAX_LINE_LEN 255

/* special cases from params.c */
#define	WORLD      41
#define	TICS     27
int noauto_world = 0;		/* only time these are used is at startup */
int noauto_tics = 0;

double *getx(), *gety();
static int bufsize = 512;
static int readerror = 0;
static char buf[256];		/* maximum line width for a file is 255 */

/*
  source types are
  0 ... disk file
  1 ... pipe
  2 ... stdin - only on command line

  file types are:
  0 ... x y one point per line sets separated by non-numeric
  1 ... x1 y1 y2 y3 ... y10
  2 ... IHL format
*/
int getdata(fn, src, type)
    char *fn;
    int src, type;
{
    FILE *fp;
    int retval;

    switch (src) {
    case 0:
	fp = fopen(fn, "r");
	break;
    case 1:
	fp = popen(fn, "r");
	break;
    case 2:
	fp = stdin;
	break;
    }
    if (fp == NULL) {
	sprintf(buf, "Can't open file %s", fn);
	errwin(buf);
	return 0;
    }
    switch (type) {
    case 0:
	retval = readxy(fn, fp);
	break;
    case 1:
	retval = readnxy(fn, fp);
	break;
    case 2:
	retval = readihl(fn, fp);
	break;
    }
    if (src == 1) {
	pclose(fp);
    } else {
	if (fp != stdin)	/* leave stdin open */
	    fclose(fp);
    }
    return retval;
}

/*
 * read file type 0
 */
int readxy(fn, fp)
    char *fn;
    FILE *fp;
{
    int i = 0, j, pstat, readset = 0, ptype;
    double *x, *y;

    if ((j = nextset()) == -1) {
	return (0);
    }
    x = (double *) calloc(bufsize, sizeof(double));
    y = (double *) calloc(bufsize, sizeof(double));
    if (x == NULL || y == NULL) {
	errwin("Insufficient memory for set");
	cxfree(x);
	cxfree(y);
	killset(j);
	return (0);
    }
    while (fgets(buf, MAX_LINE_LEN, fp) != NULL) {
	if (buf[0] == '#') {
	    continue;
	}
	if (buf[0] == '@') {
	    if ((ptype = read_param(buf + 1)) == WORLD) {
		noauto_world = 1;
	    } else if (ptype == TICS) {
		noauto_tics = 1;
	    }
	    continue;
	}
	convertchar(buf);
	/* count the number of items scanned */
	if ((pstat = sscanf(buf, "%lf %lf", &x[i], &y[i])) >= 1) {
	    /* supply x if missing (y winds up in x) */
	    if (pstat == 1) {
		y[i] = x[i];
		x[i] = i;
	    }
	    /* got x and y so increment */
	    i++;
	    if (i % bufsize == 0) {
		x = (double *) realloc(x, (i + bufsize) * sizeof(double));
		y = (double *) realloc(y, (i + bufsize) * sizeof(double));
	    }
	} else {
	    if (i != 0) {
		activateset(j);
		setxy(x, y, j, i);
		setcomment(j, fn);
		updatesetminmax(j);
		readset++;
	    } else {
		killset(j);
		readerror++;
		if (readerror > 10) {
		    if (yesno("Lots of errors, abort?", "Press YES or NO", "YES", "NO")) {
			cxfree(x);
			cxfree(y);
			return (0);
		    } else
			readerror = 0;
		}
	    }
	    i = 0;
	    if ((j = nextset()) == -1) {
		return (readset);
	    }
	    x = (double *) calloc(bufsize, sizeof(double));
	    y = (double *) calloc(bufsize, sizeof(double));
	    if (x == NULL || y == NULL) {
		errwin("Insufficient memory for set");
		cxfree(x);
		cxfree(y);
		killset(j);
		return (readset);
	    }
	}
    }
    if (i != 0) {
	activateset(j);
	setxy(x, y, j, i);
	setcomment(j, fn);
	updatesetminmax(j);
	readset++;
    } else {
	cxfree(x);
	cxfree(y);
	killset(j);
    }
    return (readset);
}

/*
 * read IHL format
 */
int readihl(fn, fp)
    char *fn;
    FILE *fp;
{
    int i, j, pstat, npts;
    double *x, *y, tmp;

    i = 0;
    pstat = 0;
    if ((j = nextset()) == -1) {
	return 0;
    }
    if (fgets(buf, MAX_LINE_LEN, fp) == NULL) {
	errwin("Can't read from file");
	killset(j);
	return 0;
    }
    pstat = sscanf(buf, "%d", &npts);
    if (npts == 0) {
	errwin("Number of points = 0");
	killset(j);
	return 0;
    }
    activateset(j);
    setlength(j, npts);
    setcomment(j, fn);
    x = getx(j);
    y = gety(j);
    for (i = 0; i < npts; i++) {
	if (fgets(buf, MAX_LINE_LEN, fp) == NULL) {
	    errwin("Premature EOF");
	    updatesetminmax(j);
	    return 1;
	}
	convertchar(buf);
	pstat = sscanf(buf, "%lf %lf %lf", &tmp, &x[i], &y[i]);
    }
    updatesetminmax(j);
    return 1;
}

/*
 * read x1 y1 y2 ... y10 formatted files
 * note that the maximum number of columns is 10
 */
static char *format = "%lf %lf %lf %lf %lf %lf %lf %lf %lf %lf %lf";

#define MAXSETN 10

int readnxy(fn, fp)
    char *fn;
    FILE *fp;
{
    int i, j, pstat, rcnt, cnt, scnt[MAXSETN], setn[MAXSETN], ptype;
    char buf[256];
    double *x[MAXSETN], *y[MAXSETN], xval, yr[MAXSETN];

    i = 0;
    pstat = 0;
    while ((fgets(buf, MAX_LINE_LEN, fp) != NULL) && ((buf[0] == '#') || (buf[0] == '@'))) {
	if (buf[0] == '@') {
	    if ((ptype = read_param(buf + 1)) == WORLD) {
		noauto_world = 1;
	    } else if (ptype == TICS) {
		noauto_tics = 1;
	    }
	}
    }
    convertchar(buf);
    cnt = sscanf(buf, format, &xval, &yr[0], &yr[1], &yr[2],
		 &yr[3], &yr[4], &yr[5], &yr[6], &yr[7], &yr[8], &yr[9]);
    if (cnt > 1) {
	for (i = 0; i < cnt - 1; i++) {
	    if ((setn[i] = nextset()) == -1) {
		for (j = 0; j < i; j++) {
		    killset(setn[j]);
		}
		return 0;
	    }
	    activateset(setn[i]);
	    x[i] = (double *) calloc(bufsize, sizeof(double));
	    y[i] = (double *) calloc(bufsize, sizeof(double));
	    if (x[i] == NULL || y[i] == NULL) {
		errwin("Insufficient memory for set");
		cxfree(x[i]);
		cxfree(y[i]);
		for (j = 0; j < i + 1; j++) {
		    killset(setn[j]);
		}
		return (0);
	    }
	    *(x[i]) = xval;
	    *(y[i]) = yr[i];
	    scnt[i] = 1;
	}
	while (fgets(buf, MAX_LINE_LEN, fp) != NULL) {
	    if (buf[0] == '#') {
		continue;
	    }
	    if (buf[0] == '@') {
		if ((ptype = read_param(buf + 1)) == WORLD) {
		    noauto_world = 1;
		} else if (ptype == TICS) {
		    noauto_tics = 1;
		}
		continue;
	    }
	    convertchar(buf);
	    rcnt = sscanf(buf, format, &xval, &yr[0], &yr[1], &yr[2],
		    &yr[3], &yr[4], &yr[5], &yr[6], &yr[7], &yr[8], &yr[9]);
	    for (i = 0; i < rcnt - 1; i++) {
		*(x[i] + scnt[i]) = xval;
		*(y[i] + scnt[i]) = yr[i];
		scnt[i]++;
		if (scnt[i] % bufsize == 0) {
		    x[i] = (double *) realloc(x[i], (scnt[i] + bufsize) * sizeof(double));
		    y[i] = (double *) realloc(y[i], (scnt[i] + bufsize) * sizeof(double));
		}
	    }
	}
	for (i = 0; i < cnt - 1; i++) {
	    setxy(x[i], y[i], setn[i], scnt[i]);
	    setcomment(setn[i], fn);
	    updatesetminmax(setn[i]);
	}
	return 1;
    }
    return 0;
}
