/*****************************************************************************/
/* 				  symbol.h				     */
/*===========================================================================*/
/* 									     */
/*	symbol.h  describes the generic symbol passed around		     */
/*	throughout yacc.						     */
/*									     */
/*   Copyright (C) 1990 by Ron Sass.					     */
/*									     */
/*   Permission to use, copy, modify, and distribute this software and	     */
/*   its documentation for any purpose is hereby granted, provided that	     */
/*   no fee beyond distribution costs is charged, the above copyright	     */
/*   notice appear in all copies, and that both that copyright notice	     */
/*   and this permission notice appear in the supporting documentation.	     */
/*   This software is provided "as is" without express or implied warranty.  */
/* 									     */
/*****************************************************************************/

typedef struct {
	int	type ;			/* see list below for valid values */
	union {
	    char	*idval ;	/* an identifier from lex */
	    double	numval ;	/* a number from lex */
	    point_t	*ptlist ;	/* a list of sample points */
	    inter_t	*intlist ;	/* an interval list */
	} u ;
} sym_t, *symp_t ;

#define YYSTYPE	symp_t
#define YYMAXDEPTH 1500

/*____________________ enum values for type in symbol _______________________*/
#define	S_ID	0		/* symbol points to an identifier */
#define	S_NUM	1		/* symbol points to a number */
#define	S_PT	2		/* symbol points to a list of points */
#define	S_INT	3		/* symbol points to a list of intervals */

/*___ global functions ____*/
extern sym_t	*create_id(), *create_str(), *create_num() ;
