/*======================================================================
                    L M O D E L . M 
                    doc: Mon Nov  4 13:46:31 1991
                    dlm: Wed Nov 20 15:04:52 1991
                    (c) 1991 A.M.J. Thurnherr
                    uE-Info: 26 11 FALSE 0 0 72 2 2 ofnI
======================================================================*/
/* MPL */
#include	<stdio.h>
#include	<math.h>
#include	"types.h"
#include	"world.h"
#include 	"utilities.h"

#define		LSRC	world.lstList[ls->lstId]	/* light source */
#define		MAT	world.mList[is->matId]

void lighten(is,in,pix)					/* lighting calcs */
Isect *is; Vec3 in; Col pix;
{
	Ray 	r;
	LS	*ls;
	Fp	cosAng,stretch,spec,nCor= 1.0;
	Vec3	out,wNrm;

	copyVec3(world.mList[is->matId].emittant,pix); 	/* emittant light */

        copyVec3(is->pnt,r.ori);			/* shadow rays */
	for (ls=world.lsList; ls!=NULL; ls=ls->next) { 	/* to all light sources */
		
		incVec3Vec3(pix,LSRC.ambient,MAT.ambient); /* ambient light */

		if (world.lstList[ls->lstId].local) {	/* local light */
			vec3SubVec3(ls->pos,is->pnt,r.dir);
			nrmVec3(r.dir,r.len);
		} else {				/* directional light */
			copyVec3(ls->pos,r.dir);	/* normalized */
			vec3Neg(r.dir);
			r.len = INF;
		}
		if (!rayWorldP(r,EPS,r.len-2*EPS)) {	/* not shadowed */
			/* orient */
			if ((vec3Vec3(in,is->planeN) > 0.0) &&
			    (!world.oriSurf)) { 	/* wrong normal */
				nCor = -1.0;
			}

			cosAng = nCor * vec3Vec3(is->nrm,r.dir); /* diffuse */
			if (cosAng >= 0.0) {
				incWVec3Vec3(pix,cosAng,LSRC.diffuse,MAT.diffuse);
			} 

			stretch	= 2.0 * vec3Vec3(in,is->nrm); 
			wVec3(is->nrm,stretch,wNrm);	/* specular */
			vec3SubVec3(in,wNrm,out);
			cosAng = nCor * -vec3Vec3(out,r.dir);
			if (cosAng >= 0.0) {
				spec = pow(cosAng,MAT.specularity);		
				incWVec3Vec3(pix,spec,LSRC.specular,MAT.specular);
			} 
		}
	}
}

