#ifndef RRRPC_H
#define RRRPC_H
#include <rrconfig.h>
#include <rpc/types.h>
#include <time.h>
typedef char *nm;
bool_t xdr_nm();
bool_t sendrpcargs();

struct RRConnection {
	nm progname;
	nm clientname;
	u_long clientno;
	nm servername;
	u_long servno;
	int transport;
	bool_t busy;
};
typedef struct RRConnection RRConnection;
bool_t xdr_RRConnection();


struct rpc_Pixel {
	u_char r;
	u_char g;
	u_char b;
	u_char alpha;
};
typedef struct rpc_Pixel rpc_Pixel;
bool_t xdr_rpc_Pixel();


struct RRreq {
	u_long RRID;
	RRConnection connect;
	int frame;
	int minx;
	int maxx;
	int miny;
	int maxy;
	int size;
	int sequence;
};
typedef struct RRreq RRreq;
bool_t xdr_RRreq();


struct rpc_square {
	struct {
		u_int pixels_len;
		rpc_Pixel *pixels_val;
	} pixels;
	RRreq req;
};
typedef struct rpc_square rpc_square;
bool_t xdr_rpc_square();


struct rpc_op_square {
	struct {
		u_int pixels_len;
		char *pixels_val;
	} pixels;
	RRreq req;
};
typedef struct rpc_op_square rpc_op_square;
bool_t xdr_rpc_op_square();

#endif

#define REMOTERENDER ((u_long)0x25000000)
#define REMOTERENDERVERS ((u_long)1)
#define RRMARSHALL ((u_long)1)
extern int *rrmarshall_1();
#define RRBLOCKED ((u_long)2)
extern int *rrblocked_1();
#define RRREQUEST ((u_long)3)
extern int *rrrequest_1();
#define RRFREE ((u_long)4)
extern int *rrfree_1();
#define RRINFO ((u_long)5)
extern char **rrinfo_1();
#define RRINITSERVICE ((u_long)6)
extern void *rrinitservice_1();


#define REMOTERENDERCALLBACK ((u_long)0x40000000)
#define REMOTERENDERCALLBACKVERS ((u_long)1)
#define RRSQUARE ((u_long)1)
extern void *rrsquare_1();
#define RRNEWSERVICE ((u_long)2)
extern void *rrnewservice_1();

