/*
 * main.c
 *
 * Copyright (C) 1989, 1991, Craig E. Kolb
 * All rights reserved.
 *
 * This software may be freely copied, modified, and redistributed
 * provided that this copyright notice is preserved on all copies.
 *
 * You may not distribute this software, in whole or in part, as part of
 * any commercial product without the express consent of the authors.
 *
 * There is no warranty or other guarantee of fitness of this software
 * for any purpose.  It is provided solely "as is".
 *
 * main.c,v 1.2 1995/03/31 04:22:06 explorer Exp
 *
 * main.c,v
 * Revision 1.2  1995/03/31 04:22:06  explorer
 * Comment on a hack
 *
 * Revision 1.1.1.1  1995/02/27  07:38:47  explorer
 * Import of Netshade
 *
 * Revision 1.1.1.1  1994/11/27  03:55:48  explorer
 * Initial import
 *
 * Revision 4.1  1994/08/09  08:06:23  explorer
 * Bump version to 4.1
 *
 * Revision 1.1.1.1  1994/08/08  04:52:27  explorer
 * Initial import.  This is a prerelease of 4.0.6enh3, or 4.1 possibly.
 *
 * Revision 4.0  91/07/17  17:36:46  kolb
 * Initial version.
 * 
 * 
 */

char rcsid[] = "main.c,v 1.2 1995/03/31 04:22:06 explorer Exp";

#include "rayshade.h"
#include "options.h"
#include "stats.h"
#include "viewing.h"
#include "picture.h"

#ifdef AMIGA
#ifndef __GNUC__
long InitTime[2];
#endif
#endif

/*
 * use our versions of these functions, not the global ones
 */
static void RSInitialize(), RSStartFrame();

int gray;

int
main(argc, argv)
int argc;
char **argv;
{
	Float utime, stime;

#ifdef AMIGA
#ifndef __GNUC__
        timer(InitTime);
#endif
        ReducePriority();
#endif

	/*
 	 * Initialize variables, etc.
	 */
	RSInitialize(argc, argv);
	RSStartFrame(Options.startframe);
	/*
 	 * Print more information than we'll ever need to know...
	 */
	if (Options.verbose) {
		extern Geom *World;
		/* World object info. */
		AggregatePrintInfo(World, Stats.fstats);
		/* Print info about rendering options and the like. */
		RSOptionsList();
	}
	/*
	 * Print preprocessing time.
	 */
	RSGetCpuTime(&utime, &stime);
	fprintf(Stats.fstats,"Preprocessing time:\t");
	fprintf(Stats.fstats,"%2.2fu  %2.2fs\n", utime, stime);
	fprintf(Stats.fstats,"Starting trace.\n");
	(void)fflush(Stats.fstats);
	/*
	 * Render the image.
	 */
	Render(argc, argv, gray);
	StatsPrint();
	return 0;
}

static void
RSStartFrame(frame)
int frame;
{
	/*
	 * Set the frame start time
	 */
	Options.framenum = frame;
	Options.framestart = Options.starttime +
			Options.framenum*Options.framelength;
	SamplingSetTime(Options.framestart, Options.shutterspeed,
			Options.framenum);
	/*
	 * Set up viewing parameters.
	 */
	RSViewing();
	/*
	 * Initialize world
	 */
	WorldSetup();
}

/*
 * Initialize non-time-varying goodies.
 */
static void
RSInitialize(argc, argv)
int argc;
char **argv;
{
	int i;

	/*
 	 * Initialize variables, etc.
	 */
	RSSetup();
	/*
	 * Steal the gray option, -M (mono, OK?)
	 */
	gray = 0;
	for (i = 1; i < argc; ++i) {
		if ('-' != argv[i][0] || 'M' != argv[i][1]) {
			continue;
		}
		gray = 1;
		for (; i < argc; ++i) {
			argv[i] = argv[i+1];
		}
		--argc;
	}
	/*
	 * Parse options from command line.
	 */
	RSOptionsSet(argc, argv);
	/*
	 * Process input file.
	 */
	if (Options.verbose) {
		VersionPrint();
		fprintf(Stats.fstats,"Reading input file...\n");
		(void)fflush(Stats.fstats);
	}
	RSReadInputFile();
	/*
	 * Set variables that weren't set on command line
	 * or in input file.
	 */
	RSCleanup();
	/*
	 * Set sampling options.
	 */
	SamplingSetOptions(Options.samples, Options.gaussian,
			   Options.filterwidth);
}
