/* atmosphere.h,v 1.1.1.1 1995/02/27 07:38:39 explorer Exp */

/*
 * Copyright (C) 1989, 1991, Craig E. Kolb
 * All rights reserved.
 *
 * This software may be freely copied, modified, and redistributed
 * provided that this copyright notice is preserved on all copies.
 *
 * You may not distribute this software, in whole or in part, as part of
 * any commercial product without the express consent of the authors.
 *
 * There is no warranty or other guarantee of fitness of this software
 * for any purpose.  It is provided solely "as is".
 *
 */

#ifndef ATMOSPHERE_H
#define ATMOSPHERE_H

#include "libcommon/common.h"

typedef char * AtmosRef;

typedef struct Medium {
  Float index;			/* Index of refraction */
  Float statten;		/* specular transmission attenuation */	
  struct Medium *next;
} Medium;

typedef struct Atmosphere {
  AtmosRef data;		/* Effect info */
  void	(*method)();		/* Atmosphere method */
  struct Atmosphere *next;	/* Next effect */
} Atmosphere;

extern Atmosphere *AtmosCreate _PROTO((char *, void(*)()));
extern Atmosphere *AtmosphereCopy _PROTO((Atmosphere *));
extern Medium *MediumPush _PROTO((Float, Float, Medium *));
extern void Atmospherics _PROTO((Atmosphere *, Ray *, Float,
				 Vector *, Color *));
extern Float ExpAtten _PROTO((Float, Float));

#endif /* ATMOSPHERE_H */
