/* sweptsph.h,v 1.2 1995/03/30 07:12:51 explorer Exp */

/*
 *	Copyright (C) 1992 by Lawrence K. Coffin, Craig Colb
 *	All Rights reserved.
 *
 * This software may be freely copied, modified, and redistributed
 * provided that this copyright notice is preserved on all copies.
 *
 * You may not distribute this software, in whole or in part, as part of
 * any commercial product without the express consent of the authors.
 *
 * There is no warranty or other guarantee of fitness of this software
 * for any purpose.  It is provided solely "as is".
 *
 */


#ifndef SWEPTSPH_H
#define SWEPTSPH_H

#define GeomSweptSphCreate(c,r)  GeomCreate((GeomRef)SweptSphCreate(c,r), SweptSphMethods())



typedef struct{
  Vector a0, a1, a2, a3, d1, d2;
  Float rad[4], pb[7], pd[5];
} SweptSph;

extern GeomRef SweptSphCreate _PROTO((Vector[4], Float[4]));
extern Methods *SweptSphMethods METHODS_PROTO;
extern int     SweptSphIntersect INTERSECT_PROTO;
extern int     SweptSphNormal NORMAL_PROTO;
extern void    SweptSphStats STATS_PROTO;
extern void    SweptSphBounds BOUNDS_PROTO;
extern void    SweptSphUV UV_PROTO;
extern char    *SweptSphName NAME_PROTO;

#endif /* SWEPTSPH_H */
