/* plane.h,v 1.1.1.1 1995/02/27 07:38:35 explorer Exp */

/*
 * Copyright (C) 1989, 1991, Craig E. Kolb
 * All rights reserved.
 *
 * This software may be freely copied, modified, and redistributed
 * provided that this copyright notice is preserved on all copies.
 *
 * You may not distribute this software, in whole or in part, as part of
 * any commercial product without the express consent of the authors.
 *
 * There is no warranty or other guarantee of fitness of this software
 * for any purpose.  It is provided solely "as is".
 *
 */

#ifndef PLANE_H
#define PLANE_H

#define GeomPlaneCreate(p,n)	GeomCreate((GeomRef)PlaneCreate(p,n), \
					PlaneMethods())

/*
 * Plane
 */
typedef struct {
  Vector norm, pos;	/* Plane normal, point on plane */
  Float d;		/* Plane constant. */
} Plane;

extern GeomRef  PlaneCreate _PROTO((Vector *, Vector *));
extern Methods	*PlaneMethods METHODS_PROTO;
extern int	PlaneIntersect INTERSECT_PROTO;
extern int      PlaneNormal NORMAL_PROTO;
extern void     PlaneUV UV_PROTO;
extern void	PlaneBounds BOUNDS_PROTO;
extern char	*PlaneName NAME_PROTO;
extern void     PlaneStats STATS_PROTO;
extern void     PlaneMethodRegister _PROTO((UserMethodType));

#endif /* PLANE_H */
