/* disc.h,v 1.1.1.1 1995/02/27 07:38:32 explorer Exp */

/*
 * Copyright (C) 1989, 1991, Craig E. Kolb
 * All rights reserved.
 *
 * This software may be freely copied, modified, and redistributed
 * provided that this copyright notice is preserved on all copies.
 *
 * You may not distribute this software, in whole or in part, as part of
 * any commercial product without the express consent of the authors.
 *
 * There is no warranty or other guarantee of fitness of this software
 * for any purpose.  It is provided solely "as is".
 * 
 */

#ifndef DISC_H
#define DISC_H

#define GeomDiscCreate(r,p,n)	GeomCreate((GeomRef)DiscCreate(r,p,n), \
					DiscMethods())

typedef struct disc {
  Float radius, d;		/* Radius squared, plane constant */
  Vector norm, pos;		/* Normal, center */
} Disc;

extern GeomRef  DiscCreate _PROTO((Float, Vector *, Vector *));
extern Methods	*DiscMethods METHODS_PROTO;
extern int	DiscIntersect INTERSECT_PROTO;
extern int      DiscNormal NORMAL_PROTO;
extern void     DiscUV UV_PROTO;
extern void	DiscBounds BOUNDS_PROTO;
extern char	*DiscName NAME_PROTO;
extern void     DiscStats STATS_PROTO;
extern void     DiscMethodRegister _PROTO((UserMethodType));

#endif /* DISC_H */
