/* cubicspin.h,v 1.1.1.1 1995/02/27 07:38:31 explorer Exp */

/*
 * Copyright (C) 1990, 1991, Mark Polipec, Craig E. Kolb
 * All rights reserved.
 *
 * This software may be freely copied, modified, and redistributed
 * provided that this copyright notice is preserved on all copies.
 *
 * You may not distribute this software, in whole or in part, as part of
 * any commercial product without the express consent of the authors.
 *
 * There is no warranty or other guarantee of fitness of this software
 * for any purpose.  It is provided solely "as is".
 *
 */

#ifndef CUBICSPIN_H
#define CUBICSPIN_H

#define GeomCubicSpinCreate(p,n,z,a,b,c,d) GeomCreate((GeomRef)CubicSpinCreate(p,n,z,a,b,c,d), CubicSpinMethods())

#define CUB_POS_FLAG   0x01
#define CUB_NEG_FLAG   0x02

/*
 * CubicSpin
 */
typedef struct {
  Float zlen;	/* length along axis */
  Float maxwidth;
  Float a[4];     /* coefficients of cubic equation to be spun */
  Float g[7];	/* useful terms for generating object coefficients */
  int sgnflag;	/* Flags cubics with pos and neg sections - used
		   for code optimization  */
  Trans trans;	/* general<-->canonical transform */
} CubicSpin;

extern GeomRef   CubicSpinCreate _PROTO((Vector *, Vector *, Float, Float,
					 Float, Float, Float));
extern int	 CubicSpinIntersect INTERSECT_PROTO;
extern int       CubicSpinNormal NORMAL_PROTO;
extern void	 CubicSpinBounds BOUNDS_PROTO;
extern void      CubicSpinStats STATS_PROTO;
extern void      CubicSpinUV UV_PROTO;
extern char	 *CubicSpinName NAME_PROTO;
extern Methods	 *CubicSpinMethods METHODS_PROTO;

#endif /* CUBICSPIN_H */
