/* projector.h,v 1.1.1.1 1995/02/27 07:38:29 explorer Exp */

/*
 * Copyright (C) 1989, 1991, Craig E. Kolb
 * All rights reserved.
 *
 * This software may be freely copied, modified, and redistributed
 * provided that this copyright notice is preserved on all copies.
 *
 * You may not distribute this software, in whole or in part, as part of
 * any commercial product without the express consent of the authors.
 *
 * There is no warranty or other guarantee of fitness of this software
 * for any purpose.  It is provided solely "as is".
 *
 * Projector light source itself written and copyrighted by Greg Spencer and
 * given to the Public Domain, with the above conditions.
 *
 */

#ifndef PROJECTOR_H
#define PROJECTOR_H

/* Necessary to use ImageText stuff */
#include "libtext/texture.h"
#include "libimage/image.h"
#include "libtext/imagetext.h"

#define LightProjectorCreate(c,f,t,up,tex,xa,ua,fall) LightCreate( \
			(LightRef)ProjectorCreate(f,t,up,tex,xa,ua,fall),\
			ProjectorMethods(), c)

typedef struct {
  Vector pos, dir, u,v;
  Float uangle, vangle;
  int falloff;
  ImageText *image;
} Projectorlight;

extern Projectorlight *ProjectorCreate _PROTO((Vector *, Vector *, Vector *,
					       ImageText *, Float, Float,
					       int));
extern LightMethods *ProjectorMethods _PROTO((void));
extern int ProjectorIntens _PROTO((Projectorlight *, Color *, ShadowCache *,
				   Ray *, Float, int, Color *));
extern int ProjectorImageApply _PROTO((Projectorlight *, Ray *, Color *));
extern void ProjectorDirection _PROTO((Projectorlight *, Vector *, Vector *,
				       Float *));
extern void ProjectorMethodRegister _PROTO((UserMethodType));

#endif /* PROJECTOR_H */
