/*======================================================================
                    I N E T R A Y . S T A R T . C 
                    doc: Fri Mar 13 12:21:13 1992
                    dlm: Sat Jun 13 19:38:49 1992
                    (c) 1992 ant@julia
                    uE-Info: 102 55 T 0 0 72 2 2 8 ofnI
======================================================================*/

#define		DAEMON

#include	<stdio.h>
#include	<signal.h>
#include	<syslog.h>
#include	<termio.h>
#include	<sys/types.h>
#include	<sys/stat.h>
#include	<rpc/rpc.h>
#include	"inetray.start.h"

static int 	nRunning = 0;		/* number of running servers */
static char 	*av0 = NULL;		/* server path */

extern void starter_1();		/* generated dispatch routine */

main(ac,av)
int ac; char *av[];
{
	int 	i,pid,sock,proto;
	register SVCXPRT *transp;
	struct stat buf;
	
	if (ac != 2) {
		fprintf(stderr,"Usage: %s <executable>\n",av[0]);
		exit(1);
	}
	av0 = av[1];			/* set server path */
	if (stat(av0,&buf) < 0) {
		perror("stat: cannot find executable");
		exit(1);
	}

#ifdef DAEMON
	pid = fork();
        if (pid < 0) {
                perror("cannot fork");
                exit(1);
        }
        if (pid) exit(0);
        for (i = 0 ; i < 20; i++)
                (void) close(i);
        i = open("/dev/console", 2);
        (void) dup2(i, 1);
        (void) dup2(i, 2); 
#ifndef AUX_QUIRK				/* sigio stops working! */
#ifndef SNAKE_QUIRK				/* TIOCNOTTY undef'd */
        i = open("/dev/tty", 2);
        if (i >= 0) {
                (void) ioctl(i, TIOCNOTTY, (char *)NULL);
                (void) close(i);
        }
#endif
#endif
#endif
#ifdef LOG_DAEMON
	openlog("inetray.start", LOG_PID, LOG_DAEMON);
#else
	openlog("inetray.start", LOG_PID);
#endif
	sock = RPC_ANYSOCK;
	proto = IPPROTO_UDP;
	(void) pmap_unset(STARTER, IRSV1);

	transp = svcudp_create(sock);
	if (transp == NULL) {
		syslog("cannot create udp service.");
		exit(1);
	}
	if (!svc_register(transp, STARTER, IRSV1, starter_1, proto)) {
		syslog("unable to register (STARTER, IRSV1, udp).");
		exit(1);
	}
	svc_run();
	syslog("svc_run returned");
	exit(1);
	/* NOTREACHED */
}

static void funeral()				/* bury dead children */
{
	int	status;
	
#ifndef DAEMON
	printf("first child died!\n");
#endif
	signal(SIGCHLD,SIG_IGN);		/* wait for all now */
	while (nRunning > 0) {
		wait(&status);			/* moment of rememberance */
#ifndef DAEMON
		printf("child returnded status %d\n",status);
#endif
		if (status != 0) 
			syslog(LOG_ERR,"child returned status %d",status);
		nRunning--;			/* accounting */
	}
#ifndef DAEMON
	printf("all children died!\n");
#endif
}

void *start_1(param)				/* start # of servers */
sPrm *param;
{
	int	i,pid;
	char	uid[16],wid[16];
	static char result;

#ifndef DAEMON
	printf("START request received...\n");
#endif
	if (nRunning != 0)			/* already servicing */
		return((void *)NULL);
	sprintf(uid,"%d",param->uid);		/* make parameter */
	signal(SIGCHLD,funeral);		/* wait for children */
	for (i=0; i<param->nSvcs; i++) {
		pid = fork();
		if (pid < 0) {
			syslog(LOG_ERR,"fork: %m");
			exit(1);
		}
		if (pid == 0) {			/* worker */
			sprintf(wid,"%d",i);
#ifndef DAEMON
			printf("execl: %s rpc.inetrayd %s %s\n",av0,wid,uid);
#endif
			if (execl(av0,"rpc.inetrayd",wid,uid,NULL) < 0) {
				syslog("execl: %m");
				exit(1);
			}
		}
#ifndef DAEMON
		printf("pid %d forked...\n",pid);
#endif	
		nRunning++;			/* one started */
	}
}

