// ************************************************************************
// FILE : RpBinaryBuffer.C
// 

#include <RpBinaryBuffer.h>
#include <string.h> // memcpy()

#define		BBUFFER_STEPSIZEORDER	(4)
#define		BBUFFER_STEPSIZE	(1<<BBUFFER_STEPSIZEORDER)
#define		BBUFFER_STEPSIZEMASK	(BBUFFER_STEPSIZE - 1) 

//
// assert that malloc() returns memory suitably aligned for any 
// built-in data type.
//
int
RpBinaryBuffer::resetSize( unsigned uSetSize, int iKeepContents )
{
   void *vp;
   vp = 0;
   
   if ( uSetSize )
   {
      
      vp = (void *) malloc( uSetSize );
      if ( !vp )
         return( 0 );
      
      _uUsed = (uSetSize > _uUsed) ? (_uUsed) : (uSetSize);      

      if ( iKeepContents )
         memcpy( vp, _vpBuffer, _uUsed );

   }
      
   if ( _vpBuffer )
      free( _vpBuffer );
      
   _vpBuffer = vp;
   _uSize = uSetSize;  
   
   return ( -1 );      
}


int 
RpBinaryBuffer::useBytes( unsigned uNeededSize, int iKeepContents ) 
{
   int iRet;
   
   if ( uNeededSize >= _uSize ) {
      // round size up to nearest step (bytes):
      iRet = 
         resetSize( (uNeededSize | BBUFFER_STEPSIZEMASK) + 1, iKeepContents );
      
   } else
      iRet = -1;
   
   if ( iRet )
      _uUsed = uNeededSize;
       
   return ( iRet );
}
