#ifndef RpUnaryOp_CLASS
#define RpUnaryOp_CLASS

#include <RpInputImage.h>
#include <RpType.h>
#include <assert.h>

// ************************************************************************
// TEMPLATE CLASS : RpUnaryOp< UnaryFunctoid >
// DESC:
//    Provides a fast way of creating simple image processing nodes.
//    This template uses a functoid to perform the same operation
//    for every pixel of every channel.
// SEE ALSO:
//    References on component programming or generic programming.
//    RpBinaryOp.h
// 

template< class UnaryFunctoid >
class RpUnaryOp : public RpInputImage
{
   public:
      RpUnaryOp( RpInputImage *pIn, const UnaryFunctiod& setF = UnaryFunctiod() );
      ~RpUnaryOp( void );
      
      int
      fillTile( RpImageTile *pWriteHere );
      
   protected:   
      RpInputImage	*_pHost;
      UnaryFunctoid	_func;
};


template< class UnaryFunctoid >
RpUnaryOp< UnaryFunctoid >::RpUnaryOp( RpInputImage *pIn, const UnaryFunctiod& setF )
:  _func( setF )
{
   _pHost = pIn;
   if ( _pHost )
   {
      _pHost->registerReference();
      setType( _pHost->getType() );
   }
   
   return;
}


template< class UnaryFunctoid >
RpUnaryOp< UnaryFunctoid >::~RpUnaryOp( void )
{
   if ( _pHost )
      _pHost->unregisterReference();      
   return;
}



template< class UnaryFunctoid >
int
RpUnaryOp< UnaryFunctoid >::fillTile( RpImageTile *pWriteHere )
{
   int			iRet = 0;
   
   register float	fResult;
   register float	fOp1;
   
   unsigned long	ulLoop;
   
   RpImageTile		*pTile;
   
#define RpTYPEMACRO( label, type, min, max, black, white, precedence, func ) \
   type *			label##pSrc; \
   type *			label##pDest
#include <RpType.m>   

   if ( _pHost && pWriteHere )
   {
      pTile = _pHost->newTile( pWriteHere->getArea() );
      if ( pTile )
      {
         assert( getType() == pWriteHere->getType() );
         pTile->typecast( getType() );
         
         ulLoop = pWriteHere->getArea().height * pWriteHere->getArea().width;
         switch( getType() )
         {
#define RpTYPEMACRO( label, type, low, high, black, white, prec, func ) \
      case( label ): 							\
	 label##pSrc = ( type * ) pTile->getBuffer();	 		\
	 label##pDest = ( type * ) pWriteHere->getBuffer(); 		\
	 while( ulLoop ) { 						\
	 ulLoop--; 							\
	 fOp1 = ((float) * label##pSrc );	\
	 fOp1 -= black;				\
	 fOp1 *= 1.0 / ( float )( white - black );	\
	 fResult = _func( fOp1 );			\
	 fResult *= (float) ( white - black );		\
	 fResult += black;				\
	 fResult = ( fResult > high ) ? ( high ) : ( fResult ); \
	 fResult = ( fResult < low ) ? ( low ) : ( fResult );   \
	 * label##pDest = ( type ) fResult ; 			\
	 label##pDest ++; label##pSrc ++;                       \
	 } break
#include <RpType.m>            
         };
                           
         pTile->deleteTile();         
         
      } else
         iRet = -1;
         
   } else
      iRet = -1;
   
   return ( iRet );
}

#endif
