#ifndef RpTYPECLASS
#define RpTYPECLASS

#include <float.h>
#include <limits.h>

typedef union {

#define RpTYPEMACRO( label, type, low, high, black, white, prec, func ) type label
#include <RpType.m>

} RpValue;


enum RpType {

#define RpTYPESEPER ,
#define RpTYPEENDOFLIST
#define RpTYPEMACRO( label, type, low, high, black, white, prec, func ) label
#include <RpType.m>

};


unsigned
bytesize( RpType type );

unsigned
precedence( RpType type );


//
// White and Black Points 
// and Minimum and Maximum possible values 
// for each data type
//
#define RpTYPEMACRO( label, type, low, high, black, white, prec, func )       \
extern const float label##Black;	\
extern const float label##White;	\
extern const float label##Max;	\
extern const float label##Min
#include <RpType.m>


//
// type conversions:
//
#define RpTYPEMACRO( label, type, low, high, black, white, prec, func )       \
void func ( register unsigned long uLoop, register type *pDest, void *vpSource, RpType srcType )
#include <RpType.m>


#endif
