#ifndef RpSampledImage_CLASS
#define RpSampledImage_CLASS

#include <RpInputImage.h>
#include <RpCachable.h>
#include <RpFillStrategy.h>

// ************************************************************************
// CLASS: RpSampledImage
// DESC:
//    This is the base class for images which have a distinct
//    resolution and domain.  (In other words, these images consisting of
//    finite samples on a rectangular grid) Therefore, concrete classes
//    need to specify the data type and area of the concrete image.
// NOTE:
//    Use this base class for images of limited domain or for
//    images that are should be eligible for caching.  Use the
//    RpInputImage base class for all other operators.
// NOTE:
//    Each RpSampledImage has a fill strategy.  If applications request
//    data outside the image's domain, the fill strategy is used to
//    validate the out-of-domain area. Call 
//    RpSampledImage::applyFillStrategy() from within your own overloaded
//    RpSampledImage::fillTile() methods.
//
class RpSampledImage : public RpInputImage, public RpCachable {
   public:
      RpImageTile *
      newTile( const RpImageArea& area );
      
      const RpImageArea&
      getArea( void ) const
      { return( _area ); }

      void
      setFillStrategy( RpFillStrategy *pStrategy );

      RpFillStrategy *
      getFillStrategy ( void )
      { return ( _pFiller ); }
      
   protected:         
      RpSampledImage( void );
      ~RpSampledImage( void );
   
      void
      setArea( const RpImageArea& setArea );
      
      int
      applyFillStrategy( RpImageTile *pWriteHere );
     
   private:   
      RpImageArea	_area;
      RpFillStrategy	*_pFiller;
};

#endif

